/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function10;
import kotlin.jvm.functions.Function11;
import kotlin.jvm.functions.Function12;
import kotlin.jvm.functions.Function13;
import kotlin.jvm.functions.Function14;
import kotlin.jvm.functions.Function15;
import kotlin.jvm.functions.Function16;
import kotlin.jvm.functions.Function17;
import kotlin.jvm.functions.Function18;
import kotlin.jvm.functions.Function19;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function20;
import kotlin.jvm.functions.Function21;
import kotlin.jvm.functions.Function22;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.functions.Function8;
import kotlin.jvm.functions.Function9;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

public final class ReflectClassUtilKt {
    private static final List<KClass<? extends Object>> PRIMITIVE_CLASSES;
    private static final Map<Class<? extends Object>, Class<? extends Object>> WRAPPER_TO_PRIMITIVE;
    private static final Map<Class<? extends Object>, Class<? extends Object>> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class<? extends Function<?>>, Integer> FUNCTION_CLASSES;

    public static final ClassLoader getSafeClassLoader(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"");
        }
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return Enum.class.isAssignableFrom(clazz);
    }

    public static final Class<?> getPrimitiveByWrapper(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return WRAPPER_TO_PRIMITIVE.get(clazz);
    }

    public static final Class<?> getWrapperByPrimitive(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return PRIMITIVE_TO_WRAPPER.get(clazz);
    }

    public static final Integer getFunctionClassArity(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return FUNCTION_CLASSES.get(clazz);
    }

    public static final ClassId getClassId(Class<?> object) {
        Class<?> clazz;
        block11: {
            block10: {
                block9: {
                    block8: {
                        Intrinsics.checkNotNullParameter(object, (String)"");
                        if (((Class)object).isPrimitive()) {
                            throw new IllegalArgumentException("Can't compute ClassId for primitive type: " + object);
                        }
                        if (((Class)object).isArray()) {
                            throw new IllegalArgumentException("Can't compute ClassId for array type: " + object);
                        }
                        if (((Class)object).getEnclosingMethod() != null || ((Class)object).getEnclosingConstructor() != null) break block8;
                        String string = ((Class)object).getSimpleName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                        if (!(((CharSequence)string).length() == 0)) break block9;
                    }
                    String string = ((Class)object).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    object = new FqName(string);
                    return new ClassId(((FqName)object).parent(), FqName.Companion.topLevel(((FqName)object).shortName()), true);
                }
                clazz = ((Class)object).getDeclaringClass();
                if (clazz == null || (clazz = ReflectClassUtilKt.getClassId(clazz)) == null) break block10;
                Name name = Name.identifier(((Class)object).getSimpleName());
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                if ((clazz = ((ClassId)((Object)clazz)).createNestedClassId(name)) != null) break block11;
            }
            String string = ((Class)object).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            clazz = ClassId.Companion.topLevel(new FqName(string));
        }
        return clazz;
    }

    public static final String getDesc(Class<?> clazz) {
        block32: {
            block33: {
                Intrinsics.checkNotNullParameter(clazz, (String)"");
                if (!clazz.isPrimitive()) break block32;
                String string = clazz.getName();
                if (string == null) break block33;
                int n = -1;
                switch (string.hashCode()) {
                    case 64711720: {
                        if (string.equals("boolean")) {
                            n = 1;
                        }
                        break;
                    }
                    case 3625364: {
                        if (string.equals("void")) {
                            n = 2;
                        }
                        break;
                    }
                    case 3039496: {
                        if (string.equals("byte")) {
                            n = 3;
                        }
                        break;
                    }
                    case -1325958191: {
                        if (string.equals("double")) {
                            n = 4;
                        }
                        break;
                    }
                    case 3052374: {
                        if (string.equals("char")) {
                            n = 5;
                        }
                        break;
                    }
                    case 109413500: {
                        if (string.equals("short")) {
                            n = 6;
                        }
                        break;
                    }
                    case 97526364: {
                        if (string.equals("float")) {
                            n = 7;
                        }
                        break;
                    }
                    case 104431: {
                        if (string.equals("int")) {
                            n = 8;
                        }
                        break;
                    }
                    case 3327612: {
                        if (string.equals("long")) {
                            n = 9;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        return "Z";
                    }
                    case 5: {
                        return "C";
                    }
                    case 3: {
                        return "B";
                    }
                    case 6: {
                        return "S";
                    }
                    case 8: {
                        return "I";
                    }
                    case 7: {
                        return "F";
                    }
                    case 9: {
                        return "J";
                    }
                    case 4: {
                        return "D";
                    }
                    case 2: {
                        return "V";
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported primitive type: " + clazz);
        }
        if (clazz.isArray()) {
            String string = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
        }
        StringBuilder stringBuilder = new StringBuilder("L");
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(';').toString();
    }

    public static final List<Type> getParameterizedTypeArguments(Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        if (!(type instanceof ParameterizedType)) {
            return CollectionsKt.emptyList();
        }
        if (((ParameterizedType)type).getOwnerType() == null) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
            return ArraysKt.toList((Object[])typeArray);
        }
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.generateSequence((Object)type, (Function1)ReflectClassUtilKt$$Lambda$0.INSTANCE), (Function1)ReflectClassUtilKt$$Lambda$1.INSTANCE));
    }

    private static final ParameterizedType _get_parameterizedTypeArguments_$lambda$3(ParameterizedType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        type = type.getOwnerType();
        if (type instanceof ParameterizedType) {
            return type;
        }
        return null;
    }

    private static final Sequence _get_parameterizedTypeArguments_$lambda$4(ParameterizedType parameterizedType) {
        Intrinsics.checkNotNullParameter((Object)parameterizedType, (String)"");
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
        return ArraysKt.asSequence((Object[])typeArray);
    }

    static {
        Object object;
        Object object2;
        Object[] objectArray = new KClass[8];
        Object object3 = objectArray;
        objectArray[0] = Reflection.getOrCreateKotlinClass(Boolean.TYPE);
        object3[1] = Reflection.getOrCreateKotlinClass(Byte.TYPE);
        object3[2] = Reflection.getOrCreateKotlinClass(Character.TYPE);
        object3[3] = Reflection.getOrCreateKotlinClass(Double.TYPE);
        object3[4] = Reflection.getOrCreateKotlinClass(Float.TYPE);
        object3[5] = Reflection.getOrCreateKotlinClass(Integer.TYPE);
        object3[6] = Reflection.getOrCreateKotlinClass(Long.TYPE);
        object3[7] = Reflection.getOrCreateKotlinClass(Short.TYPE);
        PRIMITIVE_CLASSES = CollectionsKt.listOf((Object[])object3);
        object3 = PRIMITIVE_CLASSES;
        Object object4 = object3;
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            object4 = iterator2.next();
            object2 = (KClass)object4;
            object = object3;
            object.add(TuplesKt.to((Object)JvmClassMappingKt.getJavaObjectType((KClass)object2), (Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)object2)));
        }
        WRAPPER_TO_PRIMITIVE = MapsKt.toMap((Iterable)((List)object3));
        object3 = PRIMITIVE_CLASSES;
        object4 = object3;
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            object4 = iterator2.next();
            object2 = (KClass)object4;
            object = object3;
            object.add(TuplesKt.to((Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)object2), (Object)JvmClassMappingKt.getJavaObjectType((KClass)object2)));
        }
        PRIMITIVE_TO_WRAPPER = MapsKt.toMap((Iterable)((List)object3));
        Class[] classArray = new Class[23];
        object3 = classArray;
        classArray[0] = Function0.class;
        object3[1] = Function1.class;
        object3[2] = Function2.class;
        object3[3] = Function3.class;
        object3[4] = Function4.class;
        object3[5] = Function5.class;
        object3[6] = Function6.class;
        object3[7] = Function7.class;
        object3[8] = Function8.class;
        object3[9] = Function9.class;
        object3[10] = Function10.class;
        object3[11] = Function11.class;
        object3[12] = Function12.class;
        object3[13] = Function13.class;
        object3[14] = Function14.class;
        object3[15] = Function15.class;
        object3[16] = Function16.class;
        object3[17] = Function17.class;
        object3[18] = Function18.class;
        object3[19] = Function19.class;
        object3[20] = Function20.class;
        object3[21] = Function21.class;
        object3[22] = Function22.class;
        object3 = CollectionsKt.listOf((Object[])object3);
        object4 = object3;
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        int n = 0;
        object4 = object4.iterator();
        while (object4.hasNext()) {
            int n2;
            object2 = object4.next();
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object2 = (Class)object2;
            object = object3;
            object.add(TuplesKt.to((Object)object2, (Object)n2));
        }
        FUNCTION_CLASSES = MapsKt.toMap((Iterable)((List)object3));
    }

    static /* synthetic */ ParameterizedType accessor$ReflectClassUtilKt$lambda0(ParameterizedType parameterizedType) {
        return ReflectClassUtilKt._get_parameterizedTypeArguments_$lambda$3(parameterizedType);
    }

    static /* synthetic */ Sequence accessor$ReflectClassUtilKt$lambda1(ParameterizedType parameterizedType) {
        return ReflectClassUtilKt._get_parameterizedTypeArguments_$lambda$4(parameterizedType);
    }
}

