/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.CipherSuiteConverter;
import io.netty.handler.ssl.GroupsConverter;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SslUtils;
import io.netty.internal.tcnative.Buffer;
import io.netty.internal.tcnative.Library;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public final class OpenSsl {
    private static final InternalLogger logger;
    private static final Throwable UNAVAILABILITY_CAUSE;
    static final List<String> DEFAULT_CIPHERS;
    static final Set<String> AVAILABLE_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_OPENSSL_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_JAVA_CIPHER_SUITES;
    private static final boolean SUPPORTS_KEYMANAGER_FACTORY;
    private static final boolean USE_KEYMANAGER_FACTORY;
    private static final boolean SUPPORTS_OCSP;
    private static final boolean TLSV13_SUPPORTED;
    private static final boolean IS_BORINGSSL;
    private static final Set<String> CLIENT_DEFAULT_PROTOCOLS;
    private static final Set<String> SERVER_DEFAULT_PROTOCOLS;
    static final Set<String> SUPPORTED_PROTOCOLS_SET;
    static final String[] EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
    static final String EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING;
    static final String[] NAMED_GROUPS;
    static final boolean JAVAX_CERTIFICATE_CREATION_SUPPORTED;
    private static final String[] DEFAULT_NAMED_GROUPS;

    static String checkTls13Ciphers(InternalLogger internalLogger, String string3) {
        if (IS_BORINGSSL && !string3.isEmpty()) {
            assert (EXTRA_SUPPORTED_TLS_1_3_CIPHERS.length > 0);
            HashSet hashSet = new HashSet(EXTRA_SUPPORTED_TLS_1_3_CIPHERS.length);
            Collections.addAll(hashSet, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
            boolean bl = false;
            for (String string2 : string3.split(":")) {
                if (hashSet.isEmpty()) {
                    bl = true;
                    break;
                }
                if (hashSet.remove(string2) || hashSet.remove(CipherSuiteConverter.toJava(string2, "TLS"))) continue;
                bl = true;
                break;
            }
            if (bl |= !hashSet.isEmpty()) {
                if (internalLogger.isInfoEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder(128);
                    for (String string3 : string3.split(":")) {
                        stringBuilder.append(CipherSuiteConverter.toJava(string3, "TLS")).append(":");
                    }
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder2.setLength(stringBuilder2.length() - 1);
                    internalLogger.info("BoringSSL doesn't allow to enable or disable TLSv1.3 ciphers explicitly. Provided TLSv1.3 ciphers: '{}', default TLSv1.3 ciphers that will be used: '{}'.", (Object)stringBuilder, (Object)EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING);
                }
                return EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING;
            }
        }
        return string3;
    }

    static boolean isSessionCacheSupported() {
        return (long)OpenSsl.version() >= 0x10100000L;
    }

    static java.security.cert.X509Certificate selfSignedCertificate() {
        return (java.security.cert.X509Certificate)SslContext.X509_CERT_FACTORY.generateCertificate(new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----".getBytes(CharsetUtil.US_ASCII)));
    }

    private static boolean doesSupportOcsp() {
        boolean bl = false;
        if ((long)OpenSsl.version() >= 0x10002000L) {
            long l = -1L;
            try {
                l = SSLContext.make((int)16, (int)1);
                SSLContext.enableOcsp((long)l, (boolean)false);
                bl = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (l != -1L) {
                    SSLContext.free((long)l);
                }
            }
        }
        return bl;
    }

    private static boolean doesSupportProtocol(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        long l = -1L;
        try {
            l = SSLContext.make((int)n, (int)2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            if (l != -1L) {
                SSLContext.free((long)l);
            }
        }
    }

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    @Deprecated
    public static boolean isAlpnSupported() {
        return (long)OpenSsl.version() >= 0x10002000L;
    }

    public static boolean isOcspSupported() {
        return SUPPORTS_OCSP;
    }

    public static int version() {
        if (OpenSsl.isAvailable()) {
            return SSL.version();
        }
        return -1;
    }

    public static String versionString() {
        if (OpenSsl.isAvailable()) {
            return SSL.versionString();
        }
        return null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    @Deprecated
    public static Set<String> availableCipherSuites() {
        return OpenSsl.availableOpenSslCipherSuites();
    }

    public static Set<String> availableOpenSslCipherSuites() {
        return AVAILABLE_OPENSSL_CIPHER_SUITES;
    }

    public static Set<String> availableJavaCipherSuites() {
        return AVAILABLE_JAVA_CIPHER_SUITES;
    }

    public static boolean isCipherSuiteAvailable(String string) {
        String string2 = CipherSuiteConverter.toOpenSsl(string, IS_BORINGSSL);
        if (string2 != null) {
            string = string2;
        }
        return AVAILABLE_OPENSSL_CIPHER_SUITES.contains(string);
    }

    public static boolean supportsKeyManagerFactory() {
        return SUPPORTS_KEYMANAGER_FACTORY;
    }

    @Deprecated
    public static boolean supportsHostnameValidation() {
        return OpenSsl.isAvailable();
    }

    static boolean useKeyManagerFactory() {
        return USE_KEYMANAGER_FACTORY;
    }

    static long memoryAddress(ByteBuf byteBuf) {
        assert (byteBuf.isDirect());
        if (byteBuf.hasMemoryAddress()) {
            return byteBuf.memoryAddress();
        }
        return Buffer.address((ByteBuffer)byteBuf.internalNioBuffer(0, byteBuf.readableBytes()));
    }

    private OpenSsl() {
    }

    private static void loadTcNative() {
        String string = PlatformDependent.normalizedOs();
        String string2 = PlatformDependent.normalizedArch();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(5);
        String string3 = "netty_tcnative";
        if ("linux".equals(string)) {
            Object object = PlatformDependent.normalizedLinuxClassifiers();
            object = object.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_" + string4);
            }
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
            linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_fedora");
        } else {
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
        }
        linkedHashSet.add(string3 + "_" + string2);
        linkedHashSet.add(string3);
        NativeLibraryLoader.loadFirstAvailable((ClassLoader)PlatformDependent.getClassLoader(SSLContext.class), (String[])linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    private static boolean initializeTcNative(String string) {
        return Library.initialize((String)"provided", (String)string);
    }

    static void releaseIfNeeded(ReferenceCounted referenceCounted) {
        if (referenceCounted.refCnt() > 0) {
            ReferenceCountUtil.safeRelease((Object)referenceCounted);
        }
    }

    static boolean isTlsv13Supported() {
        return TLSV13_SUPPORTED;
    }

    static boolean isOptionSupported(SslContextOption<?> sslContextOption) {
        if (OpenSsl.isAvailable()) {
            if (sslContextOption == OpenSslContextOption.USE_TASKS) {
                return true;
            }
            if (OpenSsl.isBoringSSL()) {
                return sslContextOption == OpenSslContextOption.ASYNC_PRIVATE_KEY_METHOD || sslContextOption == OpenSslContextOption.PRIVATE_KEY_METHOD || sslContextOption == OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS || sslContextOption == OpenSslContextOption.TLS_FALSE_START || sslContextOption == OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES;
            }
        }
        return false;
    }

    private static Set<String> defaultProtocols(String stringArray) {
        stringArray = SystemPropertyUtil.get((String)stringArray, null);
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray != null) {
            for (String string : stringArray.split(",")) {
                string = string.trim();
                hashSet.add(string);
            }
        } else {
            hashSet.add("TLSv1.2");
            hashSet.add("TLSv1.3");
        }
        return hashSet;
    }

    static String[] defaultProtocols(boolean bl) {
        Object object;
        Object object2 = object = bl ? CLIENT_DEFAULT_PROTOCOLS : SERVER_DEFAULT_PROTOCOLS;
        assert (object != null);
        ArrayList<String> arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!SUPPORTED_PROTOCOLS_SET.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    static boolean isBoringSSL() {
        return IS_BORINGSSL;
    }

    static {
        ArrayList<String> arrayList;
        logger = InternalLoggerFactory.getInstance(OpenSsl.class);
        DEFAULT_NAMED_GROUPS = new String[]{"x25519", "secp256r1", "secp384r1", "secp521r1"};
        Serializable serializable = null;
        if (SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.noOpenSsl", (boolean)false)) {
            serializable = new UnsupportedOperationException("OpenSSL was explicit disabled with -Dio.netty.handler.ssl.noOpenSsl=true");
            logger.debug("netty-tcnative explicit disabled; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.", (Throwable)serializable);
        } else {
            try {
                Class.forName("io.netty.internal.tcnative.SSLContext", false, PlatformDependent.getClassLoader(OpenSsl.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                arrayList = classNotFoundException;
                serializable = classNotFoundException;
                logger.debug("netty-tcnative not in the classpath; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.");
            }
            if (serializable == null) {
                try {
                    OpenSsl.loadTcNative();
                }
                catch (Throwable throwable) {
                    arrayList = throwable;
                    serializable = throwable;
                    logger.debug("Failed to load netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable, unless the application has already loaded the symbols by some other means. See https://netty.io/wiki/forked-tomcat-native.html for more information.", (Throwable)((Object)arrayList));
                }
                try {
                    arrayList = SystemPropertyUtil.get((String)"io.netty.handler.ssl.openssl.engine", null);
                    if (arrayList == null) {
                        logger.debug("Initialize netty-tcnative using engine: 'default'");
                    } else {
                        logger.debug("Initialize netty-tcnative using engine: '{}'", (Object)arrayList);
                    }
                    OpenSsl.initializeTcNative((String)((Object)arrayList));
                    serializable = null;
                }
                catch (Throwable throwable) {
                    if (serializable == null) {
                        serializable = throwable;
                    }
                    logger.debug("Failed to initialize netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable. See https://netty.io/wiki/forked-tomcat-native.html for more information.", throwable);
                }
            }
        }
        UNAVAILABILITY_CAUSE = serializable;
        CLIENT_DEFAULT_PROTOCOLS = OpenSsl.defaultProtocols("jdk.tls.client.protocols");
        SERVER_DEFAULT_PROTOCOLS = OpenSsl.defaultProtocols("jdk.tls.server.protocols");
        if (serializable == null) {
            Object object;
            int n;
            Object object2;
            logger.debug("netty-tcnative using native library: {}", (Object)SSL.versionString());
            arrayList = new ArrayList<String>();
            serializable = new LinkedHashSet(128);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String[] stringArray = DEFAULT_NAMED_GROUPS;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                linkedHashSet.add(GroupsConverter.toOpenSsl(stringArray[i]));
            }
            IS_BORINGSSL = "BoringSSL".equals(OpenSsl.versionString());
            if (IS_BORINGSSL) {
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"};
                StringBuilder stringBuilder = new StringBuilder(128);
                object2 = EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
                int n2 = EXTRA_SUPPORTED_TLS_1_3_CIPHERS.length;
                for (n = 0; n < n2; ++n) {
                    object = object2[n];
                    stringBuilder.append((String)object).append(":");
                }
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.setLength(stringBuilder2.length() - 1);
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = stringBuilder.toString();
            } else {
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS = EmptyArrays.EMPTY_STRINGS;
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = "";
            }
            try {
                long l = SSLContext.make((int)63, (int)1);
                Iterator object32 = linkedHashSet.iterator();
                while (object32.hasNext()) {
                    if (SSLContext.setCurvesList((long)l, (String[])new String[]{(String)object32.next()})) continue;
                    object32.remove();
                }
                stringArray = linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS);
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                try {
                    String[] stringArray2;
                    if (SslProvider.isTlsv13Supported(SslProvider.JDK)) {
                        try {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String string : SslUtils.TLSV13_CIPHERS) {
                                String string2 = CipherSuiteConverter.toOpenSsl(string, IS_BORINGSSL);
                                if (string2 == null) continue;
                                stringBuilder.append(string2).append(':');
                            }
                            if (stringBuilder.length() == 0) {
                                bl3 = false;
                            } else {
                                StringBuilder stringBuilder3 = stringBuilder;
                                stringBuilder3.setLength(stringBuilder3.length() - 1);
                                SSLContext.setCipherSuite((long)l, (String)stringBuilder.toString(), (boolean)true);
                                bl3 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl3 = false;
                        }
                    }
                    SSLContext.setCipherSuite((long)l, (String)"ALL", (boolean)false);
                    long l6 = SSL.newSSL((long)l, (boolean)true);
                    try {
                        for (String string : SSL.getCiphers((long)l6)) {
                            if (string == null || string.isEmpty() || serializable.contains(string) || !bl3 && SslUtils.isTLSv13Cipher(string)) continue;
                            serializable.add(string);
                        }
                        if (IS_BORINGSSL) {
                            Collections.addAll(serializable, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
                            Collections.addAll(serializable, new String[]{"AEAD-AES128-GCM-SHA256", "AEAD-AES256-GCM-SHA384", "AEAD-CHACHA20-POLY1305-SHA256"});
                        }
                        PemPrivateKey pemPrivateKey = PemPrivateKey.valueOf("-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCCBtayYNDrM3NFnkBbwTd6gaWp\na84ENvkWzWgFGtVAe5iZUChqrAPNdgnQs7Brb3cCBYRDWOlxtnaGmhhDOoRkFMucWEyuFEWUfops\nk0PxjfeRn+JJUEEO4Zt1JslKGUz7hbBD0gCyjgxni9bdLWK/l8YakuBu1dGYF/9FTyiY3QaKOW9a\nUtYdaKMs3zFC3JIW4FDuyxbxFwoBqvLelSbpRRAH4KjqWd+2LRPNqDw+COEAmrZnfBuwZGc/ZhK9\nihorqrOYddFiWn8/GuMEBkCaQsmzhhOb9cUX5+R5jHiL3OodvKid7nJ6tGJuwdpdlYudQv6sWh4x\n0q+vRVLewaaFAgMBAAECggEAP8tPJvFtTxhNJAkCloHz0D0vpDHqQBMgntlkgayqmBqLwhyb18pR\ni0qwgh7HHc7wWqOOQuSqlEnrWRrdcI6TSe8R/sErzfTQNoznKWIPYcI/hskk4sdnQ//Yn9/Jvnsv\nU/BBjOTJxtD+sQbhAl80JcA3R+5sArURQkfzzHOL/YMqzAsn5hTzp7HZCxUqBk3KaHRxV7NefeOE\nxlZuWSmxYWfbFIs4kx19/1t7h8CHQWezw+G60G2VBtSBBxDnhBWvqG6R/wpzJ3nEhPLLY9T+XIHe\nipzdMOOOUZorfIg7M+pyYPji+ZIZxIpY5OjrOzXHciAjRtr5Y7l99K1CG1LguQKBgQDrQfIMxxtZ\nvxU/1cRmUV9l7pt5bjV5R6byXq178LxPKVYNjdZ840Q0/OpZEVqaT1xKVi35ohP1QfNjxPLlHD+K\niDAR9z6zkwjIrbwPCnb5kuXy4lpwPcmmmkva25fI7qlpHtbcuQdoBdCfr/KkKaUCMPyY89LCXgEw\n5KTDj64UywKBgQCNfbO+eZLGzhiHhtNJurresCsIGWlInv322gL8CSfBMYl6eNfUTZvUDdFhPISL\nUljKWzXDrjw0ujFSPR0XhUGtiq89H+HUTuPPYv25gVXO+HTgBFZEPl4PpA+BUsSVZy0NddneyqLk\n42Wey9omY9Q8WsdNQS5cbUvy0uG6WFoX7wKBgQDZ1jpW8pa0x2bZsQsm4vo+3G5CRnZlUp+XlWt2\ndDcp5dC0xD1zbs1dc0NcLeGDOTDv9FSl7hok42iHXXq8AygjEm/QcuwwQ1nC2HxmQP5holAiUs4D\nWHM8PWs3wFYPzE459EBoKTxeaeP/uWAn+he8q7d5uWvSZlEcANs/6e77eQKBgD21Ar0hfFfj7mK8\n9E0FeRZBsqK3omkfnhcYgZC11Xa2SgT1yvs2Va2n0RcdM5kncr3eBZav2GYOhhAdwyBM55XuE/sO\neokDVutNeuZ6d5fqV96TRaRBpvgfTvvRwxZ9hvKF4Vz+9wfn/JvCwANaKmegF6ejs7pvmF3whq2k\ndrZVAoGAX5YxQ5XMTD0QbMAl7/6qp6S58xNoVdfCkmkj1ZLKaHKIjS/benkKGlySVQVPexPfnkZx\np/Vv9yyphBoudiTBS9Uog66ueLYZqpgxlM/6OhYg86Gm3U2ycvMxYjBM1NFiyze21AqAhI+HX+Ot\nmraV2/guSgDgZAhukRZzeQ2RucI=\n-----END PRIVATE KEY-----".getBytes(CharsetUtil.US_ASCII));
                        try {
                            SSLContext.setCertificateCallback((long)l, null);
                            stringArray2 = OpenSsl.selfSignedCertificate();
                            l2 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, new java.security.cert.X509Certificate[]{stringArray2});
                            l4 = SSL.parseX509Chain((long)l2);
                            l3 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemPrivateKey.retain());
                            l5 = SSL.parsePrivateKey((long)l3, null);
                            SSL.setKeyMaterial((long)l6, (long)l4, (long)l5);
                            bl = true;
                            try {
                                int n2 = SystemPropertyUtil.contains((String)"io.netty.handler.ssl.openssl.useKeyManagerFactory") ? 1 : 0;
                                if (!IS_BORINGSSL) {
                                    bl2 = SystemPropertyUtil.getBoolean((String)"io.netty.handler.ssl.openssl.useKeyManagerFactory", (boolean)true);
                                    if (n2 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and so will be ignored in the future");
                                    }
                                } else {
                                    bl2 = true;
                                    if (n2 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and will be ignored when using BoringSSL");
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                logger.debug("Failed to get useKeyManagerFactory system property.");
                            }
                        }
                        catch (Exception exception) {
                            logger.debug("KeyManagerFactory not supported", (Throwable)exception);
                        }
                        finally {
                            pemPrivateKey.release();
                        }
                    }
                    finally {
                        SSL.freeSSL((long)l6);
                        if (l2 != 0L) {
                            SSL.freeBIO((long)l2);
                        }
                        if (l3 != 0L) {
                            SSL.freeBIO((long)l3);
                        }
                        if (l4 != 0L) {
                            SSL.freeX509Chain((long)l4);
                        }
                        if (l5 != 0L) {
                            SSL.freePrivateKey((long)l5);
                        }
                    }
                    String string = SystemPropertyUtil.get((String)"jdk.tls.namedGroups", null);
                    if (string != null) {
                        stringArray2 = string.split(",");
                        LinkedHashSet<Object> linkedHashSet2 = new LinkedHashSet<Object>(stringArray2.length);
                        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>(stringArray2.length);
                        LinkedHashSet<Object> linkedHashSet4 = new LinkedHashSet<Object>();
                        String[] stringArray3 = stringArray2;
                        int n3 = stringArray2.length;
                        for (int i = 0; i < n3; ++i) {
                            object = stringArray3[i];
                            String string3 = GroupsConverter.toOpenSsl((String)object);
                            if (SSLContext.setCurvesList((long)l, (String[])new String[]{string3})) {
                                linkedHashSet3.add(string3);
                                linkedHashSet2.add(object);
                                continue;
                            }
                            linkedHashSet4.add(object);
                        }
                        if (linkedHashSet2.isEmpty()) {
                            stringArray = linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS);
                            logger.info("All configured namedGroups are not supported: {}. Use default: {}.", (Object)Arrays.toString(linkedHashSet4.toArray(EmptyArrays.EMPTY_STRINGS)), (Object)Arrays.toString(DEFAULT_NAMED_GROUPS));
                        } else {
                            Object[] objectArray = linkedHashSet2.toArray(EmptyArrays.EMPTY_STRINGS);
                            if (linkedHashSet4.isEmpty()) {
                                logger.info("Using configured namedGroups -D 'jdk.tls.namedGroup': {} ", (Object)Arrays.toString(objectArray));
                            } else {
                                logger.info("Using supported configured namedGroups: {}. Unsupported namedGroups: {}. ", (Object)Arrays.toString(objectArray), (Object)Arrays.toString(linkedHashSet4.toArray(EmptyArrays.EMPTY_STRINGS)));
                            }
                            stringArray = linkedHashSet3.toArray(EmptyArrays.EMPTY_STRINGS);
                        }
                    } else {
                        stringArray = linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS);
                    }
                }
                finally {
                    SSLContext.free((long)l);
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to get the list of available OpenSSL cipher suites.", (Throwable)exception);
            }
            NAMED_GROUPS = stringArray;
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.unmodifiableSet(serializable);
            LinkedHashSet<String> linkedHashSet4 = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() << 1);
            for (String string : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                if (!SslUtils.isTLSv13Cipher(string)) {
                    linkedHashSet4.add(CipherSuiteConverter.toJava(string, "TLS"));
                    linkedHashSet4.add(CipherSuiteConverter.toJava(string, "SSL"));
                    continue;
                }
                linkedHashSet4.add(string);
            }
            SslUtils.addIfSupported(linkedHashSet4, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
            SslUtils.addIfSupported(linkedHashSet4, arrayList, SslUtils.TLSV13_CIPHER_SUITES);
            SslUtils.addIfSupported(linkedHashSet4, arrayList, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
            SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, linkedHashSet4);
            DEFAULT_CIPHERS = Collections.unmodifiableList(arrayList);
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet4);
            object2 = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() + AVAILABLE_JAVA_CIPHER_SUITES.size());
            object2.addAll(AVAILABLE_OPENSSL_CIPHER_SUITES);
            object2.addAll(AVAILABLE_JAVA_CIPHER_SUITES);
            AVAILABLE_CIPHER_SUITES = object2;
            SUPPORTS_KEYMANAGER_FACTORY = bl;
            USE_KEYMANAGER_FACTORY = bl2;
            LinkedHashSet<String> linkedHashSet5 = new LinkedHashSet<String>(6);
            linkedHashSet5.add("SSLv2Hello");
            if (OpenSsl.doesSupportProtocol(1, SSL.SSL_OP_NO_SSLv2)) {
                linkedHashSet5.add("SSLv2");
            }
            if (OpenSsl.doesSupportProtocol(2, SSL.SSL_OP_NO_SSLv3)) {
                linkedHashSet5.add("SSLv3");
            }
            if (OpenSsl.doesSupportProtocol(4, SSL.SSL_OP_NO_TLSv1)) {
                linkedHashSet5.add("TLSv1");
            }
            if (OpenSsl.doesSupportProtocol(8, SSL.SSL_OP_NO_TLSv1_1)) {
                linkedHashSet5.add("TLSv1.1");
            }
            if (OpenSsl.doesSupportProtocol(16, SSL.SSL_OP_NO_TLSv1_2)) {
                linkedHashSet5.add("TLSv1.2");
            }
            if (bl3 && OpenSsl.doesSupportProtocol(32, SSL.SSL_OP_NO_TLSv1_3)) {
                linkedHashSet5.add("TLSv1.3");
                TLSV13_SUPPORTED = true;
            } else {
                TLSV13_SUPPORTED = false;
            }
            SUPPORTED_PROTOCOLS_SET = Collections.unmodifiableSet(linkedHashSet5);
            SUPPORTS_OCSP = OpenSsl.doesSupportOcsp();
            if (logger.isDebugEnabled()) {
                logger.debug("Supported protocols (OpenSSL): {} ", SUPPORTED_PROTOCOLS_SET);
                logger.debug("Default cipher suites (OpenSSL): {}", DEFAULT_CIPHERS);
            }
            try {
                X509Certificate.getInstance("-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----".getBytes(CharsetUtil.US_ASCII));
                n = 1;
            }
            catch (CertificateException certificateException) {
                n = 0;
            }
            JAVAX_CERTIFICATE_CREATION_SUPPORTED = n;
            return;
        }
        DEFAULT_CIPHERS = Collections.emptyList();
        AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.emptySet();
        AVAILABLE_JAVA_CIPHER_SUITES = Collections.emptySet();
        AVAILABLE_CIPHER_SUITES = Collections.emptySet();
        SUPPORTS_KEYMANAGER_FACTORY = false;
        USE_KEYMANAGER_FACTORY = false;
        SUPPORTED_PROTOCOLS_SET = Collections.emptySet();
        SUPPORTS_OCSP = false;
        TLSV13_SUPPORTED = false;
        IS_BORINGSSL = false;
        EXTRA_SUPPORTED_TLS_1_3_CIPHERS = EmptyArrays.EMPTY_STRINGS;
        EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = "";
        NAMED_GROUPS = DEFAULT_NAMED_GROUPS;
        JAVAX_CERTIFICATE_CREATION_SUPPORTED = false;
    }
}

