/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class GlobalTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ConcurrentMap<Integer, PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    long maxGlobalWriteSize = 0x19000000L;

    void createGlobalTrafficCounter(ScheduledExecutorService object) {
        object = new TrafficCounter(this, (ScheduledExecutorService)ObjectUtil.checkNotNull((Object)object, (String)"executor"), "GlobalTC", this.checkInterval);
        this.setTrafficCounter((TrafficCounter)object);
        ((TrafficCounter)object).start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 2;
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3, long l4) {
        super(l, l2, l3, l4);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2, long l3) {
        super(l, l2, l3);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l, long l2) {
        super(l, l2);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l) {
        super(l);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalTrafficShapingHandler(EventExecutor eventExecutor) {
        this.createGlobalTrafficCounter((ScheduledExecutorService)eventExecutor);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l) {
        this.maxGlobalWriteSize = l;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private PerChannel getOrSetPerChannel(ChannelHandlerContext object) {
        object = object.channel();
        PerChannel perChannel = (PerChannel)this.channelQueues.get(object = Integer.valueOf(object.hashCode()));
        if (perChannel == null) {
            perChannel = new PerChannel();
            new PerChannel().messagesQueue = new ArrayDeque();
            perChannel.queueSize = 0L;
            perChannel.lastWriteTimestamp = perChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put((Integer)object, perChannel);
        }
        return perChannel;
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.getOrSetPerChannel(channelHandlerContext);
        super.handlerAdded(channelHandlerContext);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        Object object = channel.hashCode();
        if ((object = (PerChannel)this.channelQueues.remove(object)) != null) {
            Object object2 = object;
            synchronized (object2) {
                if (channel.isActive()) {
                    for (ToSend toSend : ((PerChannel)object).messagesQueue) {
                        long l = this.calculateSize(toSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l);
                        ((PerChannel)object).queueSize -= l;
                        this.queuesSize.addAndGet(-l);
                        channelHandlerContext.write(toSend.toSend, toSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-((PerChannel)object).queueSize);
                    for (ToSend toSend : ((PerChannel)object).messagesQueue) {
                        if (!(toSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)toSend.toSend).release();
                    }
                }
                ((PerChannel)object).messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    long checkWaitReadTime(ChannelHandlerContext object, long l, long l2) {
        object = object.channel().hashCode();
        if ((object = (PerChannel)this.channelQueues.get(object)) != null && l > this.maxTime && l2 + l - object.lastReadTimestamp > this.maxTime) {
            l = this.maxTime;
        }
        return l;
    }

    @Override
    void informReadOperation(ChannelHandlerContext object, long l) {
        object = object.channel().hashCode();
        if ((object = (PerChannel)this.channelQueues.get(object)) != null) {
            object.lastReadTimestamp = l;
        }
    }

    @Override
    void submitWrite(final ChannelHandlerContext channelHandlerContext, Object object, long l, long l2, long l3, ChannelPromise channelPromise) {
        Object object2 = channelHandlerContext.channel();
        object2 = object2.hashCode();
        if ((object2 = (PerChannel)this.channelQueues.get(object2)) == null) {
            object2 = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l4 = l2;
        boolean bl = false;
        Object object3 = object2;
        synchronized (object3) {
            if (l2 == 0L && object2.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l);
                channelHandlerContext.write(object, channelPromise);
                object2.lastWriteTimestamp = l3;
                return;
            }
            if (l2 > this.maxTime && l3 + l2 - object2.lastWriteTimestamp > this.maxTime) {
                l4 = this.maxTime;
            }
            object = new ToSend(l4 + l3, object, l, channelPromise);
            object2.messagesQueue.addLast((ToSend)object);
            object2.queueSize += l;
            this.queuesSize.addAndGet(l);
            this.checkWriteSuspend(channelHandlerContext, l4, object2.queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl = true;
            }
        }
        if (bl) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        long l5 = ((ToSend)object).relativeTimeAction;
        object = object2;
        channelHandlerContext.executor().schedule(new Runnable((PerChannel)object, l5){
            final /* synthetic */ PerChannel val$forSchedule;
            final /* synthetic */ long val$futureNow;
            {
                this.val$forSchedule = perChannel;
                this.val$futureNow = l;
            }

            @Override
            public void run() {
                GlobalTrafficShapingHandler.this.sendAllValid(channelHandlerContext, this.val$forSchedule, this.val$futureNow);
            }
        }, l4, TimeUnit.MILLISECONDS);
    }

    private void sendAllValid(ChannelHandlerContext channelHandlerContext, PerChannel perChannel, long l) {
        PerChannel perChannel2 = perChannel;
        synchronized (perChannel2) {
            ToSend toSend = perChannel.messagesQueue.pollFirst();
            while (toSend != null) {
                long l2;
                if (toSend.relativeTimeAction <= l) {
                    l2 = toSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l2);
                    perChannel.queueSize -= l2;
                } else {
                    perChannel.messagesQueue.addFirst(toSend);
                    break;
                }
                this.queuesSize.addAndGet(-l2);
                channelHandlerContext.write(toSend.toSend, toSend.promise);
                perChannel.lastWriteTimestamp = l;
                toSend = perChannel.messagesQueue.pollFirst();
            }
            if (perChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final Object toSend;
        final long size;
        final ChannelPromise promise;

        private ToSend(long l, Object object, long l2, ChannelPromise channelPromise) {
            this.relativeTimeAction = l;
            this.toSend = object;
            this.size = l2;
            this.promise = channelPromise;
        }
    }

    private static final class PerChannel {
        ArrayDeque<ToSend> messagesQueue;
        long queueSize;
        long lastWriteTimestamp;
        long lastReadTimestamp;

        private PerChannel() {
        }
    }
}

