/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeJvmKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.server.http.content.LastModifiedJavaTimeKt;
import io.ktor.util.cio.FileChannelsKt;
import io.ktor.utils.io.ByteReadChannel;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\t\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/http/content/LocalFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Ljava/io/File;", "file", "Lio/ktor/http/ContentType;", "contentType", "<init>", "(Ljava/io/File;Lio/ktor/http/ContentType;)V", "Lio/ktor/utils/io/ByteReadChannel;", "readFrom", "()Lio/ktor/utils/io/ByteReadChannel;", "Lkotlin/ranges/LongRange;", "range", "(Lkotlin/ranges/LongRange;)Lio/ktor/utils/io/ByteReadChannel;", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "ktor-server-core"})
public final class LocalFileContent
extends OutgoingContent.ReadChannelContent {
    private final File file;
    private final ContentType contentType;

    public LocalFileContent(File file2, ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        this.file = file2;
        this.contentType = contentType;
        if (!this.file.exists()) {
            throw new IOException("No such file " + this.file.getAbsolutePath());
        }
        long l2 = this.file.lastModified();
        VersionsKt.setVersions((OutgoingContent)((OutgoingContent)this), (List)CollectionsKt.plus((Collection)VersionsKt.getVersions((OutgoingContent)((OutgoingContent)this)), (Object)LastModifiedJavaTimeKt.LastModifiedVersion(l2)));
    }

    public /* synthetic */ LocalFileContent(File file2, ContentType contentType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            contentType = FileContentTypeJvmKt.defaultForFile((ContentType.Companion)ContentType.Companion, (File)file2);
        }
        this(file2, contentType);
    }

    public final File getFile() {
        return this.file;
    }

    public final ContentType getContentType() {
        return this.contentType;
    }

    public final Long getContentLength() {
        return this.file.length();
    }

    public final ByteReadChannel readFrom() {
        return FileChannelsKt.readChannel$default((File)this.file, (long)0L, (long)0L, null, (int)7, null);
    }

    public final ByteReadChannel readFrom(LongRange longRange) {
        Intrinsics.checkNotNullParameter((Object)longRange, (String)"");
        return FileChannelsKt.readChannel$default((File)this.file, (long)longRange.getFirst(), (long)longRange.getLast(), null, (int)4, null);
    }
}

