/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.regex.Pattern;

public class Transform {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_PSEUDO_END = "]]&gt;";
    private static final String CDATA_EMBEDED_END = "]]>]]&gt;<![CDATA[";
    private static final int CDATA_END_LEN = 3;
    private static final Pattern UNSAFE_XML_CHARS = Pattern.compile("[\u0000-\b\u000b\f\u000e-\u001f<>&'\"]");

    public static String escapeTags(String charSequence) {
        if (charSequence == null || charSequence.length() == 0 || !UNSAFE_XML_CHARS.matcher(charSequence).find()) {
            return charSequence;
        }
        charSequence = new StringBuffer((String)charSequence);
        return Transform.escapeTags((StringBuffer)charSequence);
    }

    public static String escapeTags(StringBuffer stringBuffer) {
        block8: for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block8;
                }
                case '&': {
                    int n = i;
                    stringBuffer.replace(n, n + 1, "&amp;");
                    continue block8;
                }
                case '<': {
                    int n = i;
                    stringBuffer.replace(n, n + 1, "&lt;");
                    continue block8;
                }
                case '>': {
                    int n = i;
                    stringBuffer.replace(n, n + 1, "&gt;");
                    continue block8;
                }
                case '\"': {
                    int n = i;
                    stringBuffer.replace(n, n + 1, "&quot;");
                    continue block8;
                }
                case '\'': {
                    int n = i;
                    stringBuffer.replace(n, n + 1, "&#39;");
                    continue block8;
                }
                default: {
                    if (c >= ' ') continue block8;
                    int n = i;
                    stringBuffer.replace(n, n + 1, "\ufffd");
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void appendEscapingCDATA(StringBuilder stringBuilder, String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(CDATA_END);
        if (n < 0) {
            stringBuilder.append(string);
            return;
        }
        int n2 = 0;
        while (n >= 0) {
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append(CDATA_EMBEDED_END);
            n2 = n + CDATA_END_LEN;
            if (n2 < string.length()) {
                n = string.indexOf(CDATA_END, n2);
                continue;
            }
            return;
        }
        stringBuilder.append(string.substring(n2));
    }
}

