/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileFilterUtil {
    public static void sortFileArrayByName(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File object, File object2) {
                object = ((File)object).getName();
                object2 = ((File)object2).getName();
                return ((String)object).compareTo((String)object2);
            }
        });
    }

    public static void reverseSortFileArrayByName(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File object, File object2) {
                object = ((File)object).getName();
                object2 = ((File)object2).getName();
                return ((String)object2).compareTo((String)object);
            }
        });
    }

    public static String afterLastSlash(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static boolean isEmptyDirectory(File stringArray) {
        if (!stringArray.isDirectory()) {
            throw new IllegalArgumentException("[" + String.valueOf(stringArray) + "] must be a directory");
        }
        return (stringArray = stringArray.list()) == null || stringArray.length == 0;
    }

    public static File[] filesInFolderMatchingStemRegex(File file, String object) {
        if (file == null) {
            return new File[0];
        }
        if (!file.exists() || !file.isDirectory()) {
            return new File[0];
        }
        object = Pattern.compile((String)object);
        return file.listFiles((arg_0, arg_1) -> FileFilterUtil.lambda$filesInFolderMatchingStemRegex$0((Pattern)object, arg_0, arg_1));
    }

    public static int findHighestCounter(File[] fileArray, String string) {
        int n = Integer.MIN_VALUE;
        for (File file : fileArray) {
            int n2 = FileFilterUtil.extractCounter(file, string);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    public static int extractCounter(File object, String string) {
        Object object2 = Pattern.compile(string);
        if (!((Matcher)(object2 = ((Pattern)object2).matcher((CharSequence)(object = ((File)object).getName())))).matches()) {
            throw new IllegalStateException("The regex [" + string + "] should match [" + (String)object + "]");
        }
        object = ((Matcher)object2).group(1);
        return Integer.parseInt((String)object);
    }

    public static String slashify(String string) {
        return string.replace('\\', '/');
    }

    public static void removeEmptyParentDirectories(File file, int n) {
        while (true) {
            if (n >= 3) {
                return;
            }
            if (!(file = file.getParentFile()).isDirectory() || !FileFilterUtil.isEmptyDirectory(file)) break;
            file.delete();
            ++n;
        }
    }

    private static /* synthetic */ boolean lambda$filesInFolderMatchingStemRegex$0(Pattern pattern, File file, String string) {
        return pattern.matcher(string).matches();
    }
}

