/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.List;

public class StatusPrinter2 {
    private PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public void setPrintStream(PrintStream printStream) {
        this.ps = printStream;
    }

    public void printInCaseOfErrorsOrWarnings(Context context) {
        this.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    public void printInCaseOfErrorsOrWarnings(Context object, long l) {
        if (object == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = object.getStatusManager();
        if (statusManager == null) {
            this.ps.println("WARN: Context named \"" + object.getName() + "\" has no status manager");
            return;
        }
        if (((StatusUtil)(object = new StatusUtil((Context)object))).getHighestLevel(l) > 0) {
            this.print(statusManager, l);
        }
    }

    public void printIfErrorsOccured(Context object) {
        if (object == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = object.getStatusManager();
        if (statusManager == null) {
            this.ps.println("WARN: Context named \"" + object.getName() + "\" has no status manager");
            return;
        }
        if (((StatusUtil)(object = new StatusUtil((Context)object))).getHighestLevel(0L) == 2) {
            this.print(statusManager);
        }
    }

    public void print(Context context) {
        this.print(context, 0L);
    }

    public void print(Context context, long l) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
            return;
        }
        this.print(statusManager, l);
    }

    public void print(StatusManager statusManager) {
        this.print(statusManager, 0L);
    }

    public void print(StatusManager object, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        object = StatusUtil.filterStatusListByTimeThreshold(object.getCopyOfStatusList(), l);
        this.buildStrFromStatusList(stringBuilder, (List<Status>)object);
        this.ps.println(stringBuilder.toString());
    }

    public void print(List<Status> list) {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildStrFromStatusList(stringBuilder, list);
        this.ps.println(stringBuilder.toString());
    }

    private void buildStrFromStatusList(StringBuilder stringBuilder, List<Status> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Status status = (Status)object.next();
            this.buildStr(stringBuilder, "", status);
        }
    }

    private void appendThrowable(StringBuilder stringBuilder, Throwable stringArray) {
        String[] stringArray2 = ThrowableToStringArray.convert((Throwable)stringArray);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("Caused by: ")) {
                if (Character.isDigit(string.charAt(0))) {
                    stringBuilder.append("\t... ");
                } else {
                    stringBuilder.append("\tat ");
                }
            }
            stringBuilder.append(string).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public void buildStr(StringBuilder stringBuilder, String string, Status status) {
        Object object;
        String string2 = status.hasChildren() ? string + "+ " : string + "|-";
        if (cachingDateFormat != null) {
            object = cachingDateFormat.format(status.getTimestamp());
            stringBuilder.append((String)object).append(" ");
        }
        stringBuilder.append(string2).append(status).append(CoreConstants.LINE_SEPARATOR);
        if (status.getThrowable() != null) {
            this.appendThrowable(stringBuilder, status.getThrowable());
        }
        if (status.hasChildren()) {
            object = status.iterator();
            while (object.hasNext()) {
                status = (Status)object.next();
                this.buildStr(stringBuilder, string + "  ", status);
            }
        }
    }
}

