/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\u001a\u001b\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\u0006\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u001b\u0010\u0007\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u001b\u0010\b\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\b\u0010\u0005\u001a\u001b\u0010\t\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001b\u0010\u000b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u000b\u0010\n\u001a7\u0010\u0013\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a'\u0010\r\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\r\u0010\u0018\"\u0014\u0010\u0019\u001a\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\"\u0014\u0010\u001b\u001a\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001a\"\u001a\u0010\u001c\u001a\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001a\u001a\u0004\b\u001d\u0010\u001e\"\u001a\u0010\u001f\u001a\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b \u0010\u001e\u00a8\u0006!"}, d2={"", "Lio/ktor/network/tls/CipherSuite;", "suite", "Ljavax/crypto/spec/SecretKeySpec;", "clientMacKey", "([BLio/ktor/network/tls/CipherSuite;)Ljavax/crypto/spec/SecretKeySpec;", "serverMacKey", "serverKey", "clientKey", "clientIV", "([BLio/ktor/network/tls/CipherSuite;)[B", "serverIV", "Ljavax/crypto/SecretKey;", "masterSecret", "seed", "", "keySize", "macSize", "ivSize", "keyMaterial", "(Ljavax/crypto/SecretKey;[BIII)[B", "preMasterSecret", "clientRandom", "serverRandom", "(Ljavax/crypto/SecretKey;[B[B)Ljavax/crypto/spec/SecretKeySpec;", "MASTER_SECRET_LABEL", "[B", "KEY_EXPANSION_LABEL", "CLIENT_FINISHED_LABEL", "getCLIENT_FINISHED_LABEL", "()[B", "SERVER_FINISHED_LABEL", "getSERVER_FINISHED_LABEL", "ktor-network-tls"})
public final class KeysKt {
    private static final byte[] MASTER_SECRET_LABEL;
    private static final byte[] KEY_EXPANSION_LABEL;
    private static final byte[] CLIENT_FINISHED_LABEL;
    private static final byte[] SERVER_FINISHED_LABEL;

    public static final byte[] getCLIENT_FINISHED_LABEL() {
        return CLIENT_FINISHED_LABEL;
    }

    public static final byte[] getSERVER_FINISHED_LABEL() {
        return SERVER_FINISHED_LABEL;
    }

    public static final SecretKeySpec clientMacKey(byte[] byArray, CipherSuite cipherSuite) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        return new SecretKeySpec(byArray, 0, cipherSuite.getMacStrengthInBytes(), cipherSuite.getHash().getMacName());
    }

    public static final SecretKeySpec serverMacKey(byte[] byArray, CipherSuite cipherSuite) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        return new SecretKeySpec(byArray, cipherSuite.getMacStrengthInBytes(), cipherSuite.getMacStrengthInBytes(), cipherSuite.getHash().getMacName());
    }

    public static final SecretKeySpec serverKey(byte[] byArray, CipherSuite cipherSuite) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        return new SecretKeySpec(byArray, 2 * cipherSuite.getMacStrengthInBytes() + cipherSuite.getKeyStrengthInBytes(), cipherSuite.getKeyStrengthInBytes(), StringsKt.substringBefore$default((String)cipherSuite.getJdkCipherName(), (String)"/", null, (int)2, null));
    }

    public static final SecretKeySpec clientKey(byte[] byArray, CipherSuite cipherSuite) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        return new SecretKeySpec(byArray, 2 * cipherSuite.getMacStrengthInBytes(), cipherSuite.getKeyStrengthInBytes(), StringsKt.substringBefore$default((String)cipherSuite.getJdkCipherName(), (String)"/", null, (int)2, null));
    }

    public static final byte[] clientIV(byte[] byArray, CipherSuite cipherSuite) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        int n = 2 * cipherSuite.getMacStrengthInBytes() + 2 * cipherSuite.getKeyStrengthInBytes();
        int n2 = 2 * cipherSuite.getMacStrengthInBytes() + 2 * cipherSuite.getKeyStrengthInBytes() + cipherSuite.getFixedIvLength();
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    public static final byte[] serverIV(byte[] byArray, CipherSuite cipherSuite) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        int n = 2 * cipherSuite.getMacStrengthInBytes() + 2 * cipherSuite.getKeyStrengthInBytes() + cipherSuite.getFixedIvLength();
        int n2 = 2 * cipherSuite.getMacStrengthInBytes() + 2 * cipherSuite.getKeyStrengthInBytes() + 2 * cipherSuite.getFixedIvLength();
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
    }

    public static final byte[] keyMaterial(SecretKey secretKey, byte[] byArray, int n, int n2, int n3) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        n = 2 * n2 + 2 * n + 2 * n3;
        return HashesKt.PRF(secretKey, KEY_EXPANSION_LABEL, byArray, n);
    }

    public static final SecretKeySpec masterSecret(SecretKey secretKey, byte[] byArray, byte[] byArray2) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray2, (String)"");
        return new SecretKeySpec(HashesKt.PRF(secretKey, MASTER_SECRET_LABEL, ArraysKt.plus((byte[])byArray, (byte[])byArray2), 48), secretKey.getAlgorithm());
    }

    static {
        String string = "master secret";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
        MASTER_SECRET_LABEL = byArray;
        string = "key expansion";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"");
        KEY_EXPANSION_LABEL = byArray2;
        string = "client finished";
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"");
        CLIENT_FINISHED_LABEL = byArray3;
        string = "server finished";
        byte[] byArray4 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"");
        SERVER_FINISHED_LABEL = byArray4;
    }
}

