/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.tls.cipher.GCMCipherKt;
import io.ktor.network.tls.cipher.TLSCipher;
import io.ktor.utils.io.core.ByteReadPacketKt;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.b.q;
import kotlinx.b.t;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lio/ktor/network/tls/cipher/GCMCipher;", "Lio/ktor/network/tls/cipher/TLSCipher;", "Lio/ktor/network/tls/CipherSuite;", "suite", "", "keyMaterial", "<init>", "(Lio/ktor/network/tls/CipherSuite;[B)V", "Lio/ktor/network/tls/TLSRecord;", "record", "encrypt", "(Lio/ktor/network/tls/TLSRecord;)Lio/ktor/network/tls/TLSRecord;", "decrypt", "Lio/ktor/network/tls/CipherSuite;", "[B", "", "inputCounter", "J", "outputCounter", "ktor-network-tls"})
public final class GCMCipher
implements TLSCipher {
    private final CipherSuite suite;
    private final byte[] keyMaterial;
    private long inputCounter;
    private long outputCounter;

    public GCMCipher(CipherSuite cipherSuite, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        this.suite = cipherSuite;
        this.keyMaterial = byArray;
    }

    @Override
    public final TLSRecord encrypt(TLSRecord tLSRecord) {
        Intrinsics.checkNotNullParameter((Object)tLSRecord, (String)"");
        Cipher cipher = GCMCipherKt.access$gcmEncryptCipher(this.suite, this.keyMaterial, tLSRecord.getType(), (int)ByteReadPacketKt.getRemaining((t)tLSRecord.getPacket()), this.outputCounter, this.outputCounter);
        long l2 = this.outputCounter;
        cipher = CipherUtilsKt.cipherLoop(tLSRecord.getPacket(), cipher, (Function1<? super q, Unit>)((Function1)arg_0 -> GCMCipher.encrypt$lambda$0(l2, arg_0)));
        long l3 = this.outputCounter;
        this.outputCounter = l3 + 1L;
        return new TLSRecord(tLSRecord.getType(), null, (t)cipher, 2, null);
    }

    @Override
    public final TLSRecord decrypt(TLSRecord tLSRecord) {
        Intrinsics.checkNotNullParameter((Object)tLSRecord, (String)"");
        t t2 = tLSRecord.getPacket();
        long l2 = ByteReadPacketKt.getRemaining((t)t2);
        long l3 = t2.i();
        long l4 = this.inputCounter;
        this.inputCounter = l4 + 1L;
        Cipher cipher = GCMCipherKt.access$gcmDecryptCipher(this.suite, this.keyMaterial, tLSRecord.getType(), (int)l2, l3, l4);
        return new TLSRecord(tLSRecord.getType(), tLSRecord.getVersion(), CipherUtilsKt.cipherLoop$default(t2, cipher, null, 2, null));
    }

    private static final Unit encrypt$lambda$0(long l2, q q2) {
        Intrinsics.checkNotNullParameter((Object)q2, (String)"");
        q2.f(l2);
        return Unit.INSTANCE;
    }
}

