/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;

public abstract class IQ
extends Stanza
implements IqView {
    public static final String IQ_ELEMENT = "iq";
    public static final String QUERY_ELEMENT = "query";
    private final QName childElementQName;
    private final String childElementName;
    private final String childElementNamespace;
    private Type type = Type.get;

    protected IQ(IQ iQ) {
        super(iQ);
        this.type = iQ.getType();
        this.childElementName = iQ.childElementName;
        this.childElementNamespace = iQ.childElementNamespace;
        this.childElementQName = iQ.childElementQName;
    }

    protected IQ(String string, String string2) {
        this(IqData.EMPTY, string, string2);
    }

    protected IQ(AbstractIqBuilder<?> abstractIqBuilder, String string, String string2) {
        this(abstractIqBuilder, string != null ? new QName(string2, string) : null);
    }

    protected IQ(AbstractIqBuilder<?> abstractIqBuilder, QName qName) {
        super(abstractIqBuilder);
        this.type = abstractIqBuilder.type;
        if (qName != null) {
            this.childElementQName = qName;
            this.childElementName = qName.getLocalPart();
            this.childElementNamespace = qName.getNamespaceURI();
            return;
        }
        this.childElementQName = null;
        this.childElementName = null;
        this.childElementNamespace = null;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = Objects.requireNonNull(type, "type must not be null");
    }

    public final QName getChildElementQName() {
        return this.childElementQName;
    }

    public final String getChildElementName() {
        return this.childElementName;
    }

    public final String getChildElementNamespace() {
        return this.childElementNamespace;
    }

    @Override
    public final String getElementName() {
        return IQ_ELEMENT;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IQ Stanza (");
        stringBuilder.append(this.getChildElementName()).append(' ').append(this.getChildElementNamespace());
        stringBuilder.append(") [");
        this.logCommonAttributes(stringBuilder);
        stringBuilder.append("type=").append((Object)this.type).append(',');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public final XmlStringBuilder toXML(XmlEnvironment object) {
        object = new XmlStringBuilder(this, (XmlEnvironment)object);
        this.addCommonAttributes((XmlStringBuilder)object);
        if (this.type == null) {
            ((XmlStringBuilder)object).attribute("type", "get");
        } else {
            ((XmlStringBuilder)object).attribute("type", this.type.toString());
        }
        ((XmlStringBuilder)object).rightAngleBracket();
        this.appendInnerXml((XmlStringBuilder)object);
        ((XmlStringBuilder)object).closeElement(IQ_ELEMENT);
        return object;
    }

    public final XmlStringBuilder getChildElementXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        this.appendInnerXml(xmlStringBuilder);
        return xmlStringBuilder;
    }

    private void appendInnerXml(XmlStringBuilder xmlStringBuilder) {
        if (this.type == Type.error) {
            this.appendErrorIfExists(xmlStringBuilder);
        }
        if (this.childElementName == null) {
            return;
        }
        IQChildElementXmlStringBuilder iQChildElementXmlStringBuilder = this.getIQChildElementBuilder(new IQChildElementXmlStringBuilder(this.getChildElementName(), this.getChildElementNamespace(), null, xmlStringBuilder.getXmlEnvironment()));
        if (iQChildElementXmlStringBuilder == null) {
            return;
        }
        xmlStringBuilder.append(iQChildElementXmlStringBuilder);
        List<ExtensionElement> list = this.getExtensions();
        if (iQChildElementXmlStringBuilder.isEmptyElement) {
            if (list.isEmpty()) {
                xmlStringBuilder.closeEmptyElement();
                return;
            }
            xmlStringBuilder.rightAngleBracket();
        }
        xmlStringBuilder.append(list);
        xmlStringBuilder.closeElement(iQChildElementXmlStringBuilder.element);
    }

    protected abstract IQChildElementXmlStringBuilder getIQChildElementBuilder(IQChildElementXmlStringBuilder var1);

    public static IQ createResultIQ(IQ iQ) {
        return new EmptyResultIQ(iQ);
    }

    public static ErrorIQ createErrorResponse(IQ iQ, StanzaError stanzaError) {
        return ErrorIQ.createErrorResponse(iQ, stanzaError);
    }

    @Deprecated
    public static ErrorIQ createErrorResponse(IQ iQ, StanzaError.Builder builder) {
        return IQ.createErrorResponse(iQ, builder.build());
    }

    public static ErrorIQ createErrorResponse(IQ iQ, StanzaError.Condition condition) {
        return IQ.createErrorResponse(iQ, StanzaError.getBuilder(condition).build());
    }

    public static class IQChildElementXmlStringBuilder
    extends XmlStringBuilder {
        private final String element;
        private boolean isEmptyElement;

        public IQChildElementXmlStringBuilder(ExtensionElement extensionElement, XmlEnvironment xmlEnvironment) {
            this(extensionElement.getElementName(), extensionElement.getNamespace(), extensionElement.getLanguage(), xmlEnvironment);
        }

        private IQChildElementXmlStringBuilder(String string, String string2, String string3, XmlEnvironment xmlEnvironment) {
            super(string, string2, string3, xmlEnvironment);
            this.element = string;
        }

        public void setEmptyElement() {
            this.isEmptyElement = true;
        }
    }

    public static enum ResponseType {
        result(Type.result),
        error(Type.error);

        final Type type;

        private ResponseType(Type type) {
            this.type = type;
        }

        final Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        get,
        set,
        result,
        error;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

