/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.e.a.i;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlLangElement;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.PacketUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.XmppElementUtil;

public abstract class Stanza
implements StanzaView,
TopLevelStreamElement {
    public static final String TEXT = "text";
    public static final String ITEM = "item";
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase(Locale.US);
    private final MultiMap<QName, ExtensionElement> extensionElements;
    private final String namespace = "jabber:client";
    private final StanzaIdSource usedStanzaIdSource;
    private String id = null;
    private i to;
    private i from;
    private StanzaError error = null;
    protected String language;

    protected Stanza() {
        this.extensionElements = new MultiMap();
        this.usedStanzaIdSource = null;
        this.id = StandardStanzaIdSource.DEFAULT.getNewStanzaId();
    }

    protected Stanza(StanzaBuilder<?> stanzaBuilder) {
        if (stanzaBuilder.stanzaIdSource != null) {
            this.id = stanzaBuilder.stanzaIdSource.getNewStanzaId();
            assert (StringUtils.isNullOrNotEmpty(this.id));
            this.usedStanzaIdSource = stanzaBuilder.stanzaIdSource;
        } else {
            this.id = stanzaBuilder.stanzaId;
            this.usedStanzaIdSource = null;
        }
        this.to = stanzaBuilder.to;
        this.from = stanzaBuilder.from;
        this.error = stanzaBuilder.stanzaError;
        this.language = stanzaBuilder.language;
        this.extensionElements = stanzaBuilder.extensionElements.clone();
    }

    protected Stanza(Stanza stanza) {
        this.usedStanzaIdSource = stanza.usedStanzaIdSource;
        this.id = stanza.getStanzaId();
        this.to = stanza.getTo();
        this.from = stanza.getFrom();
        this.error = stanza.error;
        this.extensionElements = stanza.extensionElements.clone();
    }

    @Override
    public final String getStanzaId() {
        return this.id;
    }

    public void setStanzaId(String string) {
        if (string != null) {
            StringUtils.requireNotNullNorEmpty(string, "id must either be null or not the empty String");
        }
        this.id = string;
    }

    public final boolean hasStanzaIdSet() {
        return this.id != null;
    }

    @Deprecated
    public String setStanzaId() {
        if (!this.hasStanzaIdSet()) {
            this.setNewStanzaId();
        }
        return this.getStanzaId();
    }

    public final void throwIfNoStanzaId() {
        if (this.hasStanzaIdSet()) {
            return;
        }
        throw new IllegalArgumentException("The stanza has no RFC stanza ID set, although one is required");
    }

    protected String setNewStanzaId() {
        this.id = this.usedStanzaIdSource != null ? this.usedStanzaIdSource.getNewStanzaId() : StandardStanzaIdSource.DEFAULT.getNewStanzaId();
        return this.getStanzaId();
    }

    @Override
    public final i getTo() {
        return this.to;
    }

    public void setTo(i i2) {
        this.to = i2;
    }

    @Override
    public final i getFrom() {
        return this.from;
    }

    public void setFrom(i i2) {
        this.from = i2;
    }

    @Override
    public final StanzaError getError() {
        return this.error;
    }

    public void setError(StanzaError stanzaError) {
        this.error = stanzaError;
    }

    @Deprecated
    public void setError(StanzaError.Builder builder) {
        this.setError(builder.build());
    }

    @Override
    public final String getLanguage() {
        return this.language;
    }

    @Deprecated
    public void setLanguage(String string) {
        this.language = string;
    }

    @Override
    public final List<ExtensionElement> getExtensions() {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.values();
        }
    }

    public final MultiMap<QName, ExtensionElement> getExtensionsMap() {
        return this.cloneExtensionsMap();
    }

    final MultiMap<QName, ExtensionElement> cloneExtensionsMap() {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.clone();
        }
    }

    public final List<ExtensionElement> getExtensions(String object, String string) {
        StringUtils.requireNotNullNorEmpty(object, "elementName must not be null nor empty");
        StringUtils.requireNotNullNorEmpty(string, "namespace must not be null nor empty");
        object = new QName(string, (String)object);
        return this.getExtensions((QName)object);
    }

    @Override
    public final List<ExtensionElement> getExtensions(QName object) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            object = this.extensionElements.getAll((QName)object);
        }
        return Collections.unmodifiableList(object);
    }

    @Override
    public final <E extends ExtensionElement> List<E> getExtensions(Class<E> clazz) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return XmppElementUtil.getElementsFrom(this.extensionElements, clazz);
        }
    }

    public final ExtensionElement getExtension(String string) {
        return PacketUtil.extensionElementFrom(this.getExtensions(), null, string);
    }

    public final ExtensionElement getExtensionElement(String object, String string) {
        if (string == null) {
            return null;
        }
        object = new QName(string, (String)object);
        if ((object = this.getExtension((QName)object)) == null) {
            return null;
        }
        return object;
    }

    @Deprecated
    public final <E extends ExtensionElement> E getExtension(String string, String string2) {
        return (E)this.getExtensionElement(string, string2);
    }

    @Override
    public final ExtensionElement getExtension(QName qName) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            return this.extensionElements.getFirst(qName);
        }
    }

    public final void addExtension(ExtensionElement extensionElement) {
        if (extensionElement == null) {
            return;
        }
        QName qName = extensionElement.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            this.extensionElements.put(qName, extensionElement);
            return;
        }
    }

    public final ExtensionElement overrideExtension(ExtensionElement extensionElement) {
        if (extensionElement == null) {
            return null;
        }
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            ExtensionElement extensionElement2 = this.removeExtension(extensionElement.getElementName(), extensionElement.getNamespace());
            this.addExtension(extensionElement);
            return extensionElement2;
        }
    }

    public final void addExtensions(Collection<? extends ExtensionElement> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ExtensionElement extensionElement = (ExtensionElement)object.next();
            this.addExtension(extensionElement);
        }
    }

    public final boolean hasExtension(String object, String object2) {
        if (object == null) {
            return this.hasExtension((String)object2);
        }
        object = new QName((String)object2, (String)object);
        object2 = this.extensionElements;
        synchronized (object2) {
            return this.extensionElements.containsKey((QName)object);
        }
    }

    @Override
    public final boolean hasExtension(String string) {
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            for (ExtensionElement extensionElement : this.extensionElements.values()) {
                if (!extensionElement.getNamespace().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public final ExtensionElement removeExtension(String object, String object2) {
        object = new QName((String)object2, (String)object);
        object2 = this.extensionElements;
        synchronized (object2) {
            return this.extensionElements.remove((QName)object);
        }
    }

    @Deprecated
    public final ExtensionElement removeExtension(ExtensionElement extensionElement) {
        Object object = extensionElement.getQName();
        MultiMap<QName, ExtensionElement> multiMap = this.extensionElements;
        synchronized (multiMap) {
            object = this.extensionElements.getAll((QName)object);
            boolean bl = object.remove(extensionElement);
            if (bl) {
                return extensionElement;
            }
        }
        return null;
    }

    public abstract String toString();

    @Override
    public final String getNamespace() {
        return "jabber:client";
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    protected final void addCommonAttributes(XmlStringBuilder xmlStringBuilder) {
        xmlStringBuilder.optAttribute("to", (CharSequence)this.getTo());
        xmlStringBuilder.optAttribute("from", (CharSequence)this.getFrom());
        xmlStringBuilder.optAttribute("id", this.getStanzaId());
    }

    protected void logCommonAttributes(StringBuilder stringBuilder) {
        if (this.getTo() != null) {
            stringBuilder.append("to=").append((CharSequence)this.to).append(',');
        }
        if (this.getFrom() != null) {
            stringBuilder.append("from=").append((CharSequence)this.from).append(',');
        }
        if (this.hasStanzaIdSet()) {
            stringBuilder.append("id=").append(this.id).append(',');
        }
    }

    protected final void appendErrorIfExists(XmlStringBuilder xmlStringBuilder) {
        StanzaError stanzaError = this.getError();
        if (stanzaError != null) {
            xmlStringBuilder.append(stanzaError);
        }
    }

    static String determineLanguage(XmlLangElement xmlLangElement, String string) {
        if (string != null && !string.isEmpty()) {
            return string;
        }
        return xmlLangElement.getLanguage();
    }
}

