/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static InputStream getInputStreamForClasspathFile(String string) {
        return FileUtils.getInputStreamForClasspathFile(string, null);
    }

    public static InputStream getInputStreamForClasspathFile(String string, ClassLoader classLoader) {
        try {
            return FileUtils.getStreamForClasspathFile(string, classLoader);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Suppressed IOException in getInputStreamForClasspathFile", iOException);
            return null;
        }
    }

    public static InputStream getStreamForClasspathFile(String string, ClassLoader object) {
        List<ClassLoader> list = FileUtils.getClassLoaders();
        if (object != null) {
            list.add(0, (ClassLoader)((Object)object));
        }
        for (ClassLoader classLoader : list) {
            InputStream object2 = classLoader.getResourceAsStream(string);
            if (object2 == null) continue;
            return object2;
        }
        throw new IOException("Unable to get '" + string + "' from classpath. Tried ClassLoaders:" + list);
    }

    public static InputStream getStreamForUri(URI object, ClassLoader classLoader) {
        String string = ((URI)object).getScheme();
        if (string.equals("classpath")) {
            object = ((URI)object).getSchemeSpecificPart();
            return FileUtils.getStreamForClasspathFile((String)object, classLoader);
        }
        object = ((URI)object).toURL();
        return ((URL)object).openStream();
    }

    public static List<ClassLoader> getClassLoaders() {
        ClassLoader[] classLoaderArray = new ClassLoader[2];
        ClassLoader[] classLoaderArray2 = classLoaderArray;
        classLoaderArray[0] = FileUtils.class.getClassLoader();
        classLoaderArray2[1] = Thread.currentThread().getContextClassLoader();
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(classLoaderArray2.length);
        int cfr_ignored_0 = classLoaderArray2.length;
        for (int k = 0; k < 2; ++k) {
            ClassLoader classLoader = classLoaderArray2[k];
            if (classLoader == null) continue;
            arrayList.add(classLoader);
        }
        return arrayList;
    }

    public static boolean addLines(String object, Set<String> set) {
        object = URI.create((String)object);
        object = FileUtils.getStreamForUri((URI)object, null);
        object = new InputStreamReader((InputStream)object, StandardCharsets.UTF_8);
        object = new BufferedReader((Reader)object);
        try {
            String string;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                set.add(string);
            }
        }
        finally {
            ((BufferedReader)object).close();
        }
        return true;
    }

    public static String readFileOrThrow(File object) {
        object = new FileReader((File)object);
        try {
            int n;
            Object object2 = new char[8192];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n = ((Reader)object).read((char[])object2)) >= 0) {
                stringBuilder.append((char[])object2, 0, n);
            }
            object2 = stringBuilder.toString();
            return object2;
        }
        finally {
            ((Reader)object).close();
        }
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFileOrThrow(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.FINE, "readFile", fileNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "readFile", iOException);
        }
        return null;
    }

    public static void writeFileOrThrow(File object, CharSequence charSequence) {
        object = new FileWriter((File)object, false);
        try {
            ((Writer)object).write(charSequence.toString());
            return;
        }
        finally {
            ((OutputStreamWriter)object).close();
        }
    }

    public static boolean writeFile(File file, CharSequence charSequence) {
        try {
            FileUtils.writeFileOrThrow(file, charSequence);
            return true;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "writeFile", iOException);
            return false;
        }
    }

    public static FileOutputStream prepareFileOutputStream(File file) {
        if (!file.exists()) {
            File file2 = file.getParentFile();
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("Cannot create directory " + file2.getAbsolutePath());
            }
            if (!file.createNewFile()) {
                throw new IOException("Cannot create file " + file.getAbsolutePath());
            }
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("File " + file.getAbsolutePath() + " is not a file!"));
        }
        return new FileOutputStream(file);
    }

    public static FileInputStream prepareFileInputStream(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return new FileInputStream(file);
            }
            throw new IOException("File " + file.getAbsolutePath() + " is not a file!");
        }
        throw new FileNotFoundException("File " + file.getAbsolutePath() + " not found.");
    }

    public static void maybeDeleteFileOrThrow(File file) {
        if (!file.exists()) {
            return;
        }
        boolean bl = file.delete();
        if (!bl) {
            throw new IOException("Could not delete file " + file);
        }
    }

    public static void maybeCreateFileWithParentDirectories(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot create directory " + file2);
        }
        if (file.isFile()) {
            return;
        }
        if (!file.exists()) {
            if (file.createNewFile()) {
                return;
            }
            throw new IOException("Cannot create file " + file);
        }
        if (file.isDirectory()) {
            throw new IOException("File " + file + " exists, but is a directory.");
        }
        throw new IOException("File " + file + " exists, but is neither a file nor a directory");
    }
}

