/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.e.a.a.d;
import org.e.a.e;
import org.e.a.f;
import org.e.a.g;
import org.e.a.i;
import org.e.c.b;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.util.InternetAddress;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public class ParserUtils {
    public static final String JID = "jid";

    public static void assertAtStartTag(XmlPullParser xmlPullParser) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.START_ELEMENT);
    }

    public static void assertAtStartTag(XmlPullParser xmlPullParser, String string) {
        ParserUtils.assertAtStartTag(xmlPullParser);
        assert (string.equals(xmlPullParser.getName()));
    }

    public static void assertAtEndTag(XmlPullParser xmlPullParser) {
        assert (xmlPullParser.getEventType() == XmlPullParser.Event.END_ELEMENT);
    }

    public static void forwardToStartElement(XmlPullParser xmlPullParser) {
        XmlPullParser.Event event = xmlPullParser.getEventType();
        while (event != XmlPullParser.Event.START_ELEMENT) {
            if (event == XmlPullParser.Event.END_DOCUMENT) {
                throw new IllegalArgumentException("Document contains no start tag");
            }
            event = xmlPullParser.next();
        }
    }

    public static void forwardToEndTagOfDepth(XmlPullParser xmlPullParser, int n) {
        XmlPullParser.Event event = xmlPullParser.getEventType();
        while (event != XmlPullParser.Event.END_ELEMENT || xmlPullParser.getDepth() != n) {
            assert (event != XmlPullParser.Event.END_DOCUMENT);
            event = xmlPullParser.next();
        }
    }

    public static i getJidAttribute(XmlPullParser xmlPullParser) {
        return ParserUtils.getJidAttribute(xmlPullParser, JID);
    }

    public static i getJidAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return d.a((String)object);
    }

    public static e getBareJidAttribute(XmlPullParser xmlPullParser) {
        return ParserUtils.getBareJidAttribute(xmlPullParser, JID);
    }

    public static e getBareJidAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return d.d((String)object);
    }

    public static f getFullJidAttribute(XmlPullParser xmlPullParser) {
        return ParserUtils.getFullJidAttribute(xmlPullParser, JID);
    }

    public static f getFullJidAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return d.e((String)object);
    }

    public static g getEntityJidAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        if (!(object = d.a((String)object)).m()) {
            return null;
        }
        string = object.q();
        if (string != null) {
            return string;
        }
        object = object.o();
        return object;
    }

    public static org.e.a.b.d getResourcepartAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return org.e.a.b.d.b((String)object);
    }

    public static boolean parseXmlBoolean(String string) {
        switch (string) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
        }
        throw new IllegalArgumentException(string + " is not a valid boolean string");
    }

    public static Boolean getBooleanAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        object = ((String)object).toLowerCase(Locale.US);
        return ParserUtils.parseXmlBoolean((String)object);
    }

    public static boolean getBooleanAttribute(XmlPullParser object, String string, boolean bl) {
        if ((object = ParserUtils.getBooleanAttribute((XmlPullParser)object, string)) == null) {
            return bl;
        }
        return (Boolean)object;
    }

    public static Byte getByteAttributeFromNextText(XmlPullParser object) {
        object = object.nextText();
        return Byte.valueOf((String)object);
    }

    public static int getIntegerAttributeOrThrow(XmlPullParser object, String string, String string2) {
        if ((object = ParserUtils.getIntegerAttribute((XmlPullParser)object, string)) == null) {
            throw new IOException(string2);
        }
        return (Integer)object;
    }

    public static Integer getIntegerAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return Integer.valueOf((String)object);
    }

    public static int getIntegerAttribute(XmlPullParser object, String string, int n) {
        if ((object = ParserUtils.getIntegerAttribute((XmlPullParser)object, string)) == null) {
            return n;
        }
        return (Integer)object;
    }

    public static UInt16 getUInt16Attribute(XmlPullParser object, String string) {
        if ((object = ParserUtils.getIntegerAttribute((XmlPullParser)object, string)) == null) {
            return null;
        }
        return UInt16.from((Integer)object);
    }

    public static UInt16 getRequiredUInt16Attribute(XmlPullParser object, String string) {
        if ((object = ParserUtils.getUInt16Attribute(object, string)) == null) {
            throw new SmackParsingException.RequiredAttributeMissingException(string);
        }
        return object;
    }

    public static int getIntegerFromNextText(XmlPullParser object) {
        object = object.nextText();
        return Integer.valueOf((String)object);
    }

    public static Long getLongAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return Long.valueOf((String)object);
    }

    public static long getLongAttribute(XmlPullParser object, String string, long l) {
        if ((object = ParserUtils.getLongAttribute((XmlPullParser)object, string)) == null) {
            return l;
        }
        return (Long)object;
    }

    public static UInt32 getUInt32Attribute(XmlPullParser object, String string) {
        if ((object = ParserUtils.getLongAttribute((XmlPullParser)object, string)) == null) {
            return null;
        }
        return UInt32.from((Long)object);
    }

    public static double getDoubleFromNextText(XmlPullParser object) {
        object = object.nextText();
        return Double.valueOf((String)object);
    }

    public static Double getDoubleAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return Double.valueOf((String)object);
    }

    public static double getDoubleAttribute(XmlPullParser object, String string, long l) {
        if ((object = ParserUtils.getDoubleAttribute((XmlPullParser)object, string)) == null) {
            return l;
        }
        return (Double)object;
    }

    public static Short getShortAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue("", string)) == null) {
            return null;
        }
        return Short.valueOf((String)object);
    }

    public static short getShortAttribute(XmlPullParser object, String string, short s) {
        if ((object = ParserUtils.getShortAttribute((XmlPullParser)object, string)) == null) {
            return s;
        }
        return (Short)object;
    }

    public static Date getDateFromOptionalXep82String(String string) {
        if (string == null) {
            return null;
        }
        return ParserUtils.getDateFromXep82String(string);
    }

    public static Date getDateFromXep82String(String string) {
        try {
            return b.a((String)string);
        }
        catch (ParseException parseException) {
            throw new SmackParsingException.SmackTextParseException(parseException);
        }
    }

    public static Date getDateFromString(String string) {
        try {
            return b.b((String)string);
        }
        catch (ParseException parseException) {
            throw new SmackParsingException.SmackTextParseException(parseException);
        }
    }

    public static Date getDateFromNextText(XmlPullParser object) {
        object = object.nextText();
        return ParserUtils.getDateFromString((String)object);
    }

    public static URI getUriFromNextText(XmlPullParser object) {
        object = object.nextText();
        try {
            return new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SmackParsingException.SmackUriSyntaxParsingException(uRISyntaxException);
        }
    }

    public static String getRequiredAttribute(XmlPullParser object, String string) {
        if (StringUtils.isNullOrEmpty((CharSequence)(object = object.getAttributeValue("", string)))) {
            throw new IOException("Attribute " + string + " is null or empty (" + (String)object + ')');
        }
        return object;
    }

    public static String getRequiredNextText(XmlPullParser object) {
        if (StringUtils.isNullOrEmpty((CharSequence)(object = object.nextText()))) {
            throw new IOException("Next text is null or empty (" + (String)object + ')');
        }
        return object;
    }

    public static String getXmlLang(XmlPullParser object, XmlEnvironment xmlEnvironment) {
        if ((object = ParserUtils.getXmlLang(object)) != null) {
            return object;
        }
        return xmlEnvironment.getEffectiveLanguage();
    }

    public static String getXmlLang(XmlPullParser xmlPullParser) {
        return xmlPullParser.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
    }

    @Deprecated
    public static QName getQName(XmlPullParser xmlPullParser) {
        return xmlPullParser.getQName();
    }

    public static InternetAddress getInternetAddressIngoringZoneIdAttribute(XmlPullParser object, String string) {
        if ((object = object.getAttributeValue(string)) == null) {
            return null;
        }
        return InternetAddress.fromIgnoringZoneId((String)object);
    }
}

