/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttpResponse
extends DefaultHttpMessage
implements HttpResponse {
    private HttpResponseStatus status;

    public DefaultHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus) {
        this(httpVersion, httpResponseStatus, DefaultHttpHeadersFactory.headersFactory());
    }

    @Deprecated
    public DefaultHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, boolean bl) {
        this(httpVersion, httpResponseStatus, DefaultHttpHeadersFactory.headersFactory().withValidation(bl));
    }

    @Deprecated
    public DefaultHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, boolean bl, boolean bl2) {
        this(httpVersion, httpResponseStatus, DefaultHttpHeadersFactory.headersFactory().withValidation(bl).withCombiningHeaders(bl2));
    }

    public DefaultHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, HttpHeadersFactory httpHeadersFactory) {
        this(httpVersion, httpResponseStatus, httpHeadersFactory.newHeaders());
    }

    public DefaultHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
        super(httpVersion, httpHeaders);
        this.status = (HttpResponseStatus)ObjectUtil.checkNotNull((Object)httpResponseStatus, (String)"status");
    }

    @Override
    @Deprecated
    public HttpResponseStatus getStatus() {
        return this.status();
    }

    @Override
    public HttpResponseStatus status() {
        return this.status;
    }

    @Override
    public HttpResponse setStatus(HttpResponseStatus httpResponseStatus) {
        this.status = (HttpResponseStatus)ObjectUtil.checkNotNull((Object)httpResponseStatus, (String)"status");
        return this;
    }

    @Override
    public HttpResponse setProtocolVersion(HttpVersion httpVersion) {
        super.setProtocolVersion(httpVersion);
        return this;
    }

    public String toString() {
        return HttpMessageUtil.appendResponse(new StringBuilder(256), this).toString();
    }

    @Override
    public int hashCode() {
        int n = 31 + this.status.hashCode();
        n = n * 31 + super.hashCode();
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpResponse)) {
            return false;
        }
        DefaultHttpResponse defaultHttpResponse = (DefaultHttpResponse)object;
        return this.status.equals(defaultHttpResponse.status()) && super.equals(object);
    }
}

