/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;

public class HttpServerExpectContinueHandler
extends ChannelInboundHandlerAdapter {
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse ACCEPT = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);

    protected HttpResponse acceptMessage(HttpRequest httpRequest) {
        return ACCEPT.retainedDuplicate();
    }

    protected HttpResponse rejectResponse(HttpRequest httpRequest) {
        return EXPECTATION_FAILED.retainedDuplicate();
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        HttpMessage httpMessage;
        if (object instanceof HttpRequest && HttpUtil.is100ContinueExpected(httpMessage = (HttpRequest)object)) {
            HttpResponse httpResponse = this.acceptMessage((HttpRequest)httpMessage);
            if (httpResponse == null) {
                httpMessage = this.rejectResponse((HttpRequest)httpMessage);
                ReferenceCountUtil.release((Object)object);
                channelHandlerContext.writeAndFlush((Object)httpMessage).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                return;
            }
            channelHandlerContext.writeAndFlush((Object)httpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            httpMessage.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
        }
        super.channelRead(channelHandlerContext, object);
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        ACCEPT.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
    }
}

