/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@ChannelHandler.Sharable
public abstract class ChannelInitializer<C extends Channel>
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializer.class);
    private final Set<ChannelHandlerContext> initMap = Collections.newSetFromMap(new ConcurrentHashMap());

    protected abstract void initChannel(C var1);

    @Override
    public final void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (this.initChannel(channelHandlerContext)) {
            channelHandlerContext.pipeline().fireChannelRegistered();
            this.removeState(channelHandlerContext);
            return;
        }
        channelHandlerContext.fireChannelRegistered();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (logger.isWarnEnabled()) {
            logger.warn("Failed to initialize a channel. Closing: " + channelHandlerContext.channel(), throwable);
        }
        channelHandlerContext.close();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isRegistered() && this.initChannel(channelHandlerContext)) {
            this.removeState(channelHandlerContext);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.initMap.remove(channelHandlerContext);
    }

    private boolean initChannel(ChannelHandlerContext channelHandlerContext) {
        if (this.initMap.add(channelHandlerContext)) {
            try {
                this.initChannel(channelHandlerContext.channel());
            }
            catch (Throwable throwable) {
                ((ChannelHandlerAdapter)this).exceptionCaught(channelHandlerContext, throwable);
            }
            finally {
                if (!channelHandlerContext.isRemoved()) {
                    channelHandlerContext.pipeline().remove(this);
                }
            }
            return true;
        }
        return false;
    }

    private void removeState(final ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.isRemoved()) {
            this.initMap.remove(channelHandlerContext);
            return;
        }
        channelHandlerContext.executor().execute(new Runnable(){

            @Override
            public void run() {
                ChannelInitializer.this.initMap.remove(channelHandlerContext);
            }
        });
    }
}

