/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.text.StyleContext;

class LinuxFontPolicy {
    LinuxFontPolicy() {
    }

    static Font getFont() {
        if (SystemInfo.isKDE) {
            return LinuxFontPolicy.getKDEFont();
        }
        return LinuxFontPolicy.getGnomeFont();
    }

    private static Font getGnomeFont() {
        int n;
        String string;
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName");
        if (!(object instanceof String)) {
            object = "sans 10";
        }
        String string2 = "";
        int n2 = 0;
        double d = 10.0;
        object = new StringTokenizer((String)object);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string3 = ((StringTokenizer)object).nextToken();
            if (string3.endsWith(",")) {
                string3 = string3.substring(0, string3.length() - 1).trim();
            }
            if ((string = string3.toLowerCase(Locale.ENGLISH)).equals("italic") || string.equals("oblique")) {
                n2 |= 2;
                continue;
            }
            if (string.equals("bold")) {
                n2 |= 1;
                continue;
            }
            if (Character.isDigit(string3.charAt(0))) {
                try {
                    d = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string.startsWith("semi-") || string.startsWith("demi-")) {
                string3 = string3.substring(0, 4) + string3.substring(5);
            } else if (string.startsWith("extra-") || string.startsWith("ultra-")) {
                string3 = string3.substring(0, 5) + string3.substring(6);
            }
            string2 = string2.isEmpty() ? string3 : string2 + ' ' + string3;
        }
        if (string2.startsWith("Ubuntu") && !SystemInfo.isJetBrainsJVM && !FlatSystemProperties.getBoolean("flatlaf.useUbuntuFont", false)) {
            string2 = "Liberation Sans";
        }
        if ((n = (int)((d *= LinuxFontPolicy.getGnomeFontScale()) + 0.5)) <= 0) {
            n = 1;
        }
        if ((string = LinuxFontPolicy.mapFcName(string2.toLowerCase(Locale.ENGLISH))) != null) {
            string2 = string;
        }
        return LinuxFontPolicy.createFontEx(string2, n2, n, d);
    }

    private static Font createFontEx(String string, int n, int n2, double d) {
        while (true) {
            Object object = LinuxFontPolicy.createFont(string, n, n2, d);
            if ("Dialog".equals(string)) {
                return object;
            }
            if (!"Dialog".equals(((Font)object).getFamily())) {
                FontMetrics fontMetrics = StyleContext.getDefaultStyleContext().getFontMetrics((Font)object);
                if (fontMetrics.getHeight() > n2 << 1 || fontMetrics.stringWidth("a") == 0) {
                    return LinuxFontPolicy.createFont("Dialog", n, n2, d);
                }
                return object;
            }
            int n3 = string.lastIndexOf(32);
            if (n3 < 0) {
                return LinuxFontPolicy.createFont("Dialog", n, n2, d);
            }
            object = string.substring(n3 + 1).toLowerCase(Locale.ENGLISH);
            if (((String)object).contains("bold") || ((String)object).contains("heavy") || ((String)object).contains("black")) {
                n |= 1;
            }
            string = string.substring(0, n3);
        }
    }

    private static Font createFont(String object, int n, int n2, double d) {
        object = FlatLaf.createCompositeFont((String)object, n, n2);
        object = ((Font)object).deriveFont(n, (float)d);
        return object;
    }

    private static double getGnomeFontScale() {
        if (LinuxFontPolicy.isSystemScaling()) {
            return 1.3333333333333333;
        }
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
        if (object instanceof Integer) {
            int n = (Integer)object / 1024;
            if (n == -1) {
                n = 96;
            }
            if (n < 50) {
                n = 50;
            }
            return (double)n / 72.0;
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getNormalizingTransform().getScaleY();
    }

    private static String mapFcName(String string) {
        int n = -1;
        switch (string.hashCode()) {
            case 3522707: {
                if (!string.equals("sans")) break;
                n = 0;
                break;
            }
            case -1536685117: {
                if (!string.equals("sans-serif")) break;
                n = 1;
                break;
            }
            case 109326717: {
                if (!string.equals("serif")) break;
                n = 2;
                break;
            }
            case -1431958525: {
                if (!string.equals("monospace")) break;
                n = 3;
            }
        }
        switch (n) {
            case 0: {
                return "sansserif";
            }
            case 1: {
                return "sansserif";
            }
            case 2: {
                return "serif";
            }
            case 3: {
                return "monospaced";
            }
        }
        return null;
    }

    private static Font getKDEFont() {
        double d;
        double d2;
        Object object = LinuxFontPolicy.readConfig("kdeglobals");
        Object object2 = LinuxFontPolicy.readConfig("kcmfonts");
        object = LinuxFontPolicy.getConfigEntry(object, "General", "font");
        object2 = LinuxFontPolicy.getConfigEntry(object2, "General", "forceFontDPI");
        String string = "sansserif";
        int n = 0;
        int n2 = 10;
        if (object != null) {
            List<String> list = StringUtils.split((String)object, ',');
            try {
                string = list.get(0);
                n2 = Integer.parseInt(list.get(1));
                if ("75".equals(list.get(4))) {
                    n = 1;
                }
                if ("1".equals(list.get(5))) {
                    n |= 2;
                }
            }
            catch (RuntimeException runtimeException) {
                LoggingFacade.INSTANCE.logConfig("FlatLaf: Failed to parse 'font=" + (String)object + "'.", runtimeException);
            }
        }
        int n3 = 96;
        if (object2 != null && !LinuxFontPolicy.isSystemScaling()) {
            try {
                n3 = Integer.parseInt((String)object2);
                if (n3 <= 0) {
                    n3 = 96;
                }
                if (n3 < 50) {
                    n3 = 50;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LoggingFacade.INSTANCE.logConfig("FlatLaf: Failed to parse 'forceFontDPI=" + (String)object2 + "'.", numberFormatException);
            }
        }
        if ((n2 = (int)((d2 = (double)n2 * (d = (double)n3 / 72.0)) + 0.5)) <= 0) {
            n2 = 1;
        }
        return LinuxFontPolicy.createFont(string, n, n2, d2);
    }

    private static List<String> readConfig(String string) {
        Object object = new File(System.getProperty("user.home"));
        Object object2 = new String[]{".config", ".kde4/share/config", ".kde/share/config"};
        Object object3 = null;
        int cfr_ignored_0 = ((String[])object2).length;
        for (int i = 0; i < 3; ++i) {
            object3 = object2[i];
            if (((File)(object3 = new File((File)object, (String)object3 + "/" + string))).isFile()) break;
        }
        if (!((File)object3).isFile()) {
            return Collections.emptyList();
        }
        object2 = new ArrayList(200);
        try {
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object3), StandardCharsets.US_ASCII));
            try {
                String string2;
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    ((ArrayList)object2).add(string2);
                }
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        catch (IOException iOException) {
            LoggingFacade.INSTANCE.logConfig("FlatLaf: Failed to read '" + string + "'.", iOException);
        }
        return object2;
    }

    private static String getConfigEntry(List<String> object, String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            if (!bl) {
                if (string3.length() < n + 2 || string3.charAt(0) != '[' || string3.charAt(n + 1) != ']' || string3.indexOf(string) != 1) continue;
                bl = true;
                continue;
            }
            if (string3.startsWith("[")) {
                return null;
            }
            if (string3.length() < n2 + 2 || string3.charAt(n2) != '=' || !string3.startsWith(string2)) continue;
            return string3.substring(n2 + 1);
        }
        return null;
    }

    private static boolean isSystemScaling() {
        GraphicsConfiguration graphicsConfiguration;
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        GraphicsConfiguration graphicsConfiguration2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return UIScale.getSystemScaleFactor(graphicsConfiguration) > 1.0;
    }
}

