/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToggleButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class FlatButtonBorder
extends FlatBorder {
    @FlatStylingSupport.Styleable
    protected int arc = UIManager.getInt("Button.arc");
    protected Color endBorderColor = UIManager.getColor("Button.endBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = UIManager.getColor("Button.hoverBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float defaultBorderWidth = FlatUIUtils.getUIFloat("Button.default.borderWidth", 1.0f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultBorderColor = FlatUIUtils.getUIColor("Button.default.startBorderColor", "Button.default.borderColor");
    protected Color defaultEndBorderColor = UIManager.getColor("Button.default.endBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedBorderColor = UIManager.getColor("Button.default.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusColor = UIManager.getColor("Button.default.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverBorderColor = UIManager.getColor("Button.default.hoverBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float toolbarFocusWidth = FlatUIUtils.getUIFloat("Button.toolbar.focusWidth", 1.5f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarFocusColor = UIManager.getColor("Button.toolbar.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarMargin = UIManager.getInsets("Button.toolbar.margin");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarSpacingInsets = UIManager.getInsets("Button.toolbar.spacingInsets");

    public FlatButtonBorder() {
        this.innerFocusWidth = FlatUIUtils.getUIFloat("Button.innerFocusWidth", this.innerFocusWidth);
        this.borderWidth = FlatUIUtils.getUIFloat("Button.borderWidth", this.borderWidth);
        this.borderColor = FlatUIUtils.getUIColor("Button.startBorderColor", "Button.borderColor");
        this.disabledBorderColor = UIManager.getColor("Button.disabledBorderColor");
        this.focusedBorderColor = UIManager.getColor("Button.focusedBorderColor");
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(!FlatButtonUI.isContentAreaFilled(component) || FlatButtonUI.isToolBarButton(component) || FlatButtonUI.isBorderlessButton(component) && !FlatUIUtils.isPermanentFocusOwner(component) || FlatButtonUI.isHelpButton(component) || FlatToggleButtonUI.isTabButton(component))) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            return;
        }
        if (FlatButtonUI.isToolBarButton(component) && this.isFocused(component)) {
            this.paintToolBarFocus(component, graphics, n, n2, n3, n4);
        }
    }

    protected void paintToolBarFocus(Component serializable, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics);
            float f = UIScale.scale(this.toolbarFocusWidth);
            float f2 = UIScale.scale((float)this.getArc((Component)serializable));
            Color color = this.getOutlineColor((Component)serializable);
            Insets insets = UIScale.scale(this.toolbarSpacingInsets);
            serializable = color != null ? color : this.getFocusColor((Component)serializable);
            FlatUIUtils.paintOutlinedComponent((Graphics2D)graphics, n += insets.left, n2 += insets.top, n3 -= insets.left + insets.right, n4 -= insets.top + insets.bottom, 0.0f, 0.0f, 0.0f, f, f2, null, (Paint)((Object)serializable), null);
            return;
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    protected Color getFocusColor(Component component) {
        if (this.toolbarFocusColor != null && FlatButtonUI.isToolBarButton(component)) {
            return this.toolbarFocusColor;
        }
        if (FlatButtonUI.isDefaultButton(component)) {
            return this.defaultFocusColor;
        }
        return super.getFocusColor(component);
    }

    @Override
    protected boolean isFocused(Component component) {
        return FlatButtonUI.isFocusPainted(component) && super.isFocused(component);
    }

    @Override
    protected Paint getBorderColor(Component component) {
        Color color;
        boolean bl = FlatButtonUI.isDefaultButton(component);
        Paint paint = FlatButtonUI.buttonStateColor(component, bl ? this.defaultBorderColor : this.borderColor, this.disabledBorderColor, bl ? this.defaultFocusedBorderColor : this.focusedBorderColor, bl ? this.defaultHoverBorderColor : this.hoverBorderColor, null);
        Color color2 = bl ? this.defaultBorderColor : this.borderColor;
        Color color3 = color = bl ? this.defaultEndBorderColor : this.endBorderColor;
        if (paint == color2 && color != null && !color2.equals(color)) {
            paint = new GradientPaint(0.0f, 0.0f, color2, 0.0f, component.getHeight(), color);
        }
        return paint;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        if (FlatButtonUI.isToolBarButton(component)) {
            component = component instanceof AbstractButton ? ((AbstractButton)component).getMargin() : null;
            FlatUIUtils.setInsets(insets, UIScale.scale(FlatUIUtils.addInsets(this.toolbarSpacingInsets, (Insets)(component != null && !(component instanceof UIResource) ? component : this.toolbarMargin))));
        } else {
            insets = super.getBorderInsets(component, insets);
            if (FlatButtonUI.isIconOnlyOrSingleCharacterButton(component) && ((AbstractButton)component).getMargin() instanceof UIResource) {
                Insets insets2 = insets;
                insets2.left = insets2.right = Math.min(insets.top, insets.bottom);
            }
        }
        return insets;
    }

    @Override
    protected int getFocusWidth(Component component) {
        if (FlatToggleButtonUI.isTabButton(component)) {
            return 0;
        }
        return super.getFocusWidth(component);
    }

    @Override
    protected float getBorderWidth(Component component) {
        if (FlatButtonUI.isDefaultButton(component)) {
            return this.defaultBorderWidth;
        }
        return this.borderWidth;
    }

    @Override
    protected int getArc(Component component) {
        if (this.isCellEditor(component)) {
            return 0;
        }
        switch (FlatButtonUI.getButtonType(component)) {
            case 0: {
                return 0;
            }
            case 1: {
                return Short.MAX_VALUE;
            }
        }
        return this.arc;
    }
}

