/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;

public class FlatLineBorder
extends FlatEmptyBorder {
    private final Color lineColor;
    private final float lineThickness;
    private final int arc;

    public FlatLineBorder(Insets insets, Color color) {
        this(insets, color, 1.0f, 0);
    }

    public FlatLineBorder(Insets insets, Color color, float f, int n) {
        super(insets);
        this.lineColor = color;
        this.lineThickness = f;
        this.arc = n;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public int getArc() {
        return this.arc;
    }

    @Override
    public void paintBorder(Component object, Graphics graphics, int n, int n2, int n3, int n4) {
        if (object instanceof JComponent && ((JComponent)object).getClientProperty("FlatLaf.internal.FlatPopupFactory.popupUsesNativeBorder") != null) {
            return;
        }
        object = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)object);
            FlatUIUtils.paintOutlinedComponent((Graphics2D)object, n, n2, n3, n4, 0.0f, 0.0f, 0.0f, UIScale.scale(this.getLineThickness()), UIScale.scale(this.getArc()), null, this.getLineColor(), null);
            return;
        }
        finally {
            ((Graphics)object).dispose();
        }
    }
}

