/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class FlatSpinnerUI
extends BasicSpinnerUI
implements FlatStylingSupport.StyleableUI {
    private Handler handler;
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    @FlatStylingSupport.Styleable
    protected String buttonStyle;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonBackground;
    @FlatStylingSupport.Styleable
    protected float buttonSeparatorWidth;
    @FlatStylingSupport.Styleable
    protected Color buttonSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedArrowColor;
    @FlatStylingSupport.Styleable
    protected Insets padding;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;
    private static final int MAC_STEPPER_WIDTH = 15;
    private static final int MAC_STEPPER_GAP = 3;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatSpinnerUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.spinner, "opaque", Boolean.FALSE);
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.buttonStyle = UIManager.getString("Spinner.buttonStyle");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.disabledBackground = UIManager.getColor("Spinner.disabledBackground");
        this.disabledForeground = UIManager.getColor("Spinner.disabledForeground");
        this.focusedBackground = UIManager.getColor("Spinner.focusedBackground");
        this.buttonBackground = UIManager.getColor("Spinner.buttonBackground");
        this.buttonSeparatorWidth = FlatUIUtils.getUIFloat("Spinner.buttonSeparatorWidth", FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f));
        this.buttonSeparatorColor = UIManager.getColor("Spinner.buttonSeparatorColor");
        this.buttonDisabledSeparatorColor = UIManager.getColor("Spinner.buttonDisabledSeparatorColor");
        this.buttonArrowColor = UIManager.getColor("Spinner.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("Spinner.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("Spinner.buttonHoverArrowColor");
        this.buttonPressedArrowColor = UIManager.getColor("Spinner.buttonPressedArrowColor");
        this.padding = UIManager.getInsets("Spinner.padding");
        MigLayoutVisualPadding.install(this.spinner);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.focusedBackground = null;
        this.buttonBackground = null;
        this.buttonSeparatorColor = null;
        this.buttonDisabledSeparatorColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        this.buttonPressedArrowColor = null;
        this.padding = null;
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(this.spinner);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        FlatSpinnerUI flatSpinnerUI = this;
        flatSpinnerUI.addEditorFocusListener(flatSpinnerUI.spinner.getEditor());
        this.spinner.addFocusListener(this.getHandler());
        this.spinner.addPropertyChangeListener(this.getHandler());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        FlatSpinnerUI flatSpinnerUI = this;
        flatSpinnerUI.removeEditorFocusListener(flatSpinnerUI.spinner.getEditor());
        this.spinner.removeFocusListener(this.getHandler());
        this.spinner.removePropertyChangeListener(this.getHandler());
        this.handler = null;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installStyle() {
        try {
            FlatSpinnerUI flatSpinnerUI = this;
            flatSpinnerUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatSpinnerUI.spinner, "Spinner"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        this.updateEditorPadding();
        this.updateArrowButtonsStyle();
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.spinner, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        FlatSpinnerUI flatSpinnerUI = this;
        return FlatStylingSupport.getAnnotatedStyleableInfos(flatSpinnerUI, flatSpinnerUI.spinner.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        FlatSpinnerUI flatSpinnerUI = this;
        return FlatStylingSupport.getAnnotatedStyleableValue(flatSpinnerUI, flatSpinnerUI.spinner.getBorder(), string);
    }

    @Override
    protected JComponent createEditor() {
        JComponent jComponent = super.createEditor();
        this.configureEditor(jComponent);
        return jComponent;
    }

    @Override
    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        super.replaceEditor(jComponent, jComponent2);
        this.configureEditor(jComponent2);
        this.removeEditorFocusListener(jComponent);
        this.addEditorFocusListener(jComponent2);
    }

    protected void configureEditor(JComponent jComponent) {
        jComponent.setOpaque(false);
        jComponent = FlatSpinnerUI.getEditorTextField(jComponent);
        if (jComponent != null) {
            jComponent.setOpaque(false);
        }
        this.updateEditorPadding();
        this.updateEditorColors();
    }

    private void addEditorFocusListener(JComponent jComponent) {
        if ((jComponent = FlatSpinnerUI.getEditorTextField(jComponent)) != null) {
            jComponent.addFocusListener(this.getHandler());
        }
    }

    private void removeEditorFocusListener(JComponent jComponent) {
        if ((jComponent = FlatSpinnerUI.getEditorTextField(jComponent)) != null) {
            jComponent.removeFocusListener(this.getHandler());
        }
    }

    private void updateEditorPadding() {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.putClientProperty("JTextField.padding", this.padding);
        }
    }

    private void updateEditorColors() {
        JTextField jTextField = FlatSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.setForeground(FlatUIUtils.nonUIResource(this.getForeground(true)));
            jTextField.setDisabledTextColor(FlatUIUtils.nonUIResource(this.getForeground(false)));
        }
    }

    private static JTextField getEditorTextField(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        return null;
    }

    public static boolean isPermanentFocusOwner(JSpinner jComponent) {
        if (FlatUIUtils.isPermanentFocusOwner(jComponent)) {
            return true;
        }
        return (jComponent = FlatSpinnerUI.getEditorTextField(jComponent.getEditor())) != null && FlatUIUtils.isPermanentFocusOwner(jComponent);
    }

    protected Color getBackground(boolean bl) {
        if (bl) {
            Color color = this.spinner.getBackground();
            if (!(color instanceof UIResource)) {
                return color;
            }
            if (this.focusedBackground != null && FlatSpinnerUI.isPermanentFocusOwner(this.spinner)) {
                return this.focusedBackground;
            }
            return color;
        }
        return this.disabledBackground;
    }

    protected Color getForeground(boolean bl) {
        if (bl) {
            return this.spinner.getForeground();
        }
        return this.disabledForeground;
    }

    @Override
    protected LayoutManager createLayout() {
        return this.getHandler();
    }

    @Override
    protected Component createNextButton() {
        return this.createArrowButton(1, "Spinner.nextButton");
    }

    @Override
    protected Component createPreviousButton() {
        return this.createArrowButton(5, "Spinner.previousButton");
    }

    private Component createArrowButton(int n, String string) {
        FlatArrowButton flatArrowButton = new FlatArrowButton(n, this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null){

            @Override
            public int getArrowWidth() {
                if (FlatSpinnerUI.this.isMacStyle()) {
                    return 7;
                }
                return super.getArrowWidth();
            }

            @Override
            public float getArrowThickness() {
                if (FlatSpinnerUI.this.isMacStyle()) {
                    return 1.5f;
                }
                return super.getArrowThickness();
            }

            @Override
            public float getYOffset() {
                if (FlatSpinnerUI.this.isMacStyle()) {
                    return 0.0f;
                }
                return super.getYOffset();
            }

            @Override
            public boolean isRoundBorderAutoXOffset() {
                if (FlatSpinnerUI.this.isMacStyle()) {
                    return false;
                }
                return super.isRoundBorderAutoXOffset();
            }
        };
        flatArrowButton.setName(string);
        flatArrowButton.setYOffset(n == 1 ? 1.25f : -1.25f);
        if (n == 1) {
            this.installNextButtonListeners(flatArrowButton);
        } else {
            this.installPreviousButtonListeners(flatArrowButton);
        }
        return flatArrowButton;
    }

    private void updateArrowButtonsStyle() {
        for (Component component : this.spinner.getComponents()) {
            if (!(component instanceof FlatArrowButton)) continue;
            ((FlatArrowButton)component).updateStyle(this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null);
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f = FlatUIUtils.getBorderFocusWidth(jComponent);
        float f2 = FlatUIUtils.getBorderArc(jComponent);
        if (jComponent.isOpaque() && (f > 0.0f || f2 > 0.0f)) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics2D);
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        boolean bl = this.spinner.isEnabled();
        int n3 = this.spinner.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.isMacStyle();
        int n4 = bl2 ? this.getMacStyleButtonsWidth() : 0;
        graphics2D.setColor(this.getBackground(bl));
        FlatUIUtils.paintComponentBackground(graphics2D, n3 != 0 ? 0 : n4, 0, n - n4, n2, f, f2);
        n4 = !"none".equals(this.buttonStyle) ? 1 : 0;
        Handler handler = this.getHandler();
        if (n4 != 0 && (handler.nextButton != null || handler.previousButton != null)) {
            Color color;
            Component component = handler.nextButton != null ? handler.nextButton : handler.previousButton;
            int n5 = component.getX();
            int n6 = component.getWidth();
            Color color2 = color = bl ? this.buttonSeparatorColor : this.buttonDisabledSeparatorColor;
            if (bl2) {
                Insets insets = this.spinner.getInsets();
                int n7 = Math.round(FlatUIUtils.getBorderLineWidth(this.spinner));
                int n8 = n5;
                n = insets.top - n7;
                n3 = n6;
                n7 = n2 - insets.top - insets.bottom + (n7 << 1);
                float f3 = UIScale.scale(this.buttonSeparatorWidth);
                FlatUIUtils.paintOutlinedComponent(graphics2D, n8, n, n3, n7, 0.0f, 0.0f, 0.0f, f3, UIScale.scale(12), null, color, this.buttonBackground);
                if (color != null) {
                    int n9 = UIScale.scale(1);
                    graphics2D.setColor(color);
                    graphics2D.fill(new Rectangle2D.Float((float)n8 + f3, (float)n + (float)(n7 - n9) / 2.0f, (float)n3 - f3 * 2.0f, n9));
                }
            } else {
                if (bl && this.buttonBackground != null) {
                    graphics2D.setColor(this.buttonBackground);
                    Shape shape = graphics2D.getClip();
                    if (n3 != 0) {
                        graphics2D.clipRect(n5, 0, n - n5, n2);
                    } else {
                        graphics2D.clipRect(0, 0, n5 + n6, n2);
                    }
                    FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, n, n2, f, f2);
                    graphics2D.setClip(shape);
                }
                if (color != null && this.buttonSeparatorWidth > 0.0f) {
                    graphics2D.setColor(color);
                    float f4 = UIScale.scale(this.buttonSeparatorWidth);
                    f2 = n3 != 0 ? (float)n5 : (float)(n5 + n6) - f4;
                    graphics2D.fill(new Rectangle2D.Float(f2, f, f4, (float)(n2 - 1) - f * 2.0f));
                }
            }
        }
        this.paint(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    boolean isMacStyle() {
        return "mac".equals(this.buttonStyle);
    }

    int getMacStyleButtonsWidth() {
        if (this.handler.nextButton != null || this.handler.previousButton != null) {
            return UIScale.scale(3) + UIScale.scale(15);
        }
        return 0;
    }

    private class Handler
    implements LayoutManager,
    FocusListener,
    PropertyChangeListener {
        private Component editor = null;
        private Component nextButton;
        private Component previousButton;

        private Handler() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            int n = -1;
            switch (string.hashCode()) {
                case 2071006605: {
                    if (!string.equals("Editor")) break;
                    n = 0;
                    break;
                }
                case 2424595: {
                    if (!string.equals("Next")) break;
                    n = 1;
                    break;
                }
                case -1209131241: {
                    if (!string.equals("Previous")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    this.editor = component;
                    return;
                }
                case 1: {
                    this.nextButton = component;
                    return;
                }
                case 2: {
                    this.previousButton = component;
                }
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.editor) {
                this.editor = null;
                return;
            }
            if (component == this.nextButton) {
                this.nextButton = null;
                return;
            }
            if (component == this.previousButton) {
                this.previousButton = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container serializable) {
            serializable = serializable.getInsets();
            Insets insets = UIScale.scale(FlatSpinnerUI.this.padding);
            Dimension dimension = this.editor != null ? this.editor.getPreferredSize() : new Dimension(0, 0);
            int n = FlatUIUtils.minimumWidth(FlatSpinnerUI.this.spinner, FlatSpinnerUI.this.minimumWidth);
            int n2 = dimension.height + insets.top + insets.bottom;
            float f = FlatUIUtils.getBorderFocusWidth(FlatSpinnerUI.this.spinner);
            return new Dimension(Math.max(((Insets)serializable).left + ((Insets)serializable).right + dimension.width + insets.left + insets.right + n2, UIScale.scale(n) + Math.round(f * 2.0f)), ((Insets)serializable).top + ((Insets)serializable).bottom + n2);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            Cloneable cloneable = container.getSize();
            Cloneable cloneable2 = container.getInsets();
            cloneable = FlatUIUtils.subtractInsets(new Rectangle((Dimension)cloneable), cloneable2);
            if (this.nextButton == null && this.previousButton == null) {
                if (this.editor != null) {
                    this.editor.setBounds((Rectangle)cloneable);
                }
                return;
            }
            cloneable2 = new Rectangle((Rectangle)cloneable);
            cloneable = new Rectangle((Rectangle)cloneable);
            FontMetrics fontMetrics = FlatSpinnerUI.this.spinner.getFontMetrics(FlatSpinnerUI.this.spinner.getFont());
            int n = fontMetrics.getHeight() + UIScale.scale(FlatSpinnerUI.this.padding.top) + UIScale.scale(FlatSpinnerUI.this.padding.bottom);
            int n2 = n * 3 / 4;
            boolean bl = FlatSpinnerUI.this.isMacStyle();
            int n3 = bl ? UIScale.scale(3) : 0;
            int n4 = bl ? UIScale.scale(15) : ((Rectangle)cloneable).height;
            ((Rectangle)cloneable).width = n = Math.min(Math.max(n4, n2), n);
            ((Rectangle)cloneable2).width -= n + n3;
            int n5 = container.getComponentOrientation().isLeftToRight();
            if (n5 != 0) {
                ((Rectangle)cloneable).x += ((Rectangle)cloneable2).width + n3;
            } else {
                ((Rectangle)cloneable2).x += n + n3;
            }
            if (bl && (n = Math.round(FlatUIUtils.getBorderLineWidth(FlatSpinnerUI.this.spinner))) > 0) {
                ((Rectangle)cloneable).x = ((Rectangle)cloneable).x + (n5 != 0 ? n : -n);
                ((Rectangle)cloneable).y -= n;
                ((Rectangle)cloneable).height += n << 1;
            }
            if (this.editor != null) {
                this.editor.setBounds((Rectangle)cloneable2);
            }
            n = ((Rectangle)cloneable).height / 2 + ((Rectangle)cloneable).height % 2;
            if (this.nextButton != null) {
                this.nextButton.setBounds(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, n);
            }
            if (this.previousButton != null) {
                n5 = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height - n;
                this.previousButton.setBounds(((Rectangle)cloneable).x, n5, ((Rectangle)cloneable).width, n);
            }
        }

        @Override
        public void focusGained(FocusEvent serializable) {
            FlatSpinnerUI.this.spinner.repaint();
            if (((ComponentEvent)serializable).getComponent() == FlatSpinnerUI.this.spinner && (serializable = FlatSpinnerUI.getEditorTextField(FlatSpinnerUI.this.spinner.getEditor())) != null) {
                ((JComponent)serializable).requestFocusInWindow();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            FlatSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent object) {
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "foreground": 
                case "enabled": {
                    FlatSpinnerUI.this.updateEditorColors();
                    return;
                }
                case "JComponent.roundRect": 
                case "JComponent.outline": {
                    FlatSpinnerUI.this.spinner.repaint();
                    return;
                }
                case "JComponent.minimumWidth": {
                    FlatSpinnerUI.this.spinner.revalidate();
                    return;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    FlatSpinnerUI.this.installStyle();
                    FlatSpinnerUI.this.spinner.revalidate();
                    FlatSpinnerUI.this.spinner.repaint();
                }
            }
        }
    }
}

