/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class FlatSplitPaneUI
extends BasicSplitPaneUI
implements FlatStylingSupport.StyleableUI,
FlatTitlePane.TitleBarCaptionHitTest {
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Color draggingColor;
    @FlatStylingSupport.Styleable
    protected Color oneTouchArrowColor;
    @FlatStylingSupport.Styleable
    protected Color oneTouchHoverArrowColor;
    @FlatStylingSupport.Styleable
    protected Color oneTouchPressedArrowColor;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatSplitPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        this.arrowType = UIManager.getString("Component.arrowType");
        this.draggingColor = UIManager.getColor("SplitPaneDivider.draggingColor");
        this.oneTouchArrowColor = UIManager.getColor("SplitPaneDivider.oneTouchArrowColor");
        this.oneTouchHoverArrowColor = UIManager.getColor("SplitPaneDivider.oneTouchHoverArrowColor");
        this.oneTouchPressedArrowColor = UIManager.getColor("SplitPaneDivider.oneTouchPressedArrowColor");
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.draggingColor = null;
        this.oneTouchArrowColor = null;
        this.oneTouchHoverArrowColor = null;
        this.oneTouchPressedArrowColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return FlatStylingSupport.createPropertyChangeListener(this.splitPane, this::installStyle, super.createPropertyChangeListener());
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        FlatSplitPaneUI flatSplitPaneUI = this;
        return flatSplitPaneUI.new FlatSplitPaneDivider(flatSplitPaneUI);
    }

    protected void installStyle() {
        try {
            FlatSplitPaneUI flatSplitPaneUI = this;
            flatSplitPaneUI.applyStyle(FlatStylingSupport.getResolvedStyle(flatSplitPaneUI.splitPane, "SplitPane"));
            return;
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
            return;
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.divider instanceof FlatSplitPaneDivider) {
            ((FlatSplitPaneDivider)this.divider).updateStyle();
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        try {
            if (this.divider instanceof FlatSplitPaneDivider) {
                return ((FlatSplitPaneDivider)this.divider).applyStyleProperty(string, object);
            }
        }
        catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {}
        FlatSplitPaneUI flatSplitPaneUI = this;
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(flatSplitPaneUI, flatSplitPaneUI.splitPane, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent object) {
        object = FlatStylingSupport.getAnnotatedStyleableInfos(this);
        if (this.divider instanceof FlatSplitPaneDivider) {
            object.putAll(((FlatSplitPaneDivider)this.divider).getStyleableInfos());
        }
        return object;
    }

    @Override
    public Object getStyleableValue(JComponent object, String string) {
        if (this.divider instanceof FlatSplitPaneDivider && (object = ((FlatSplitPaneDivider)this.divider).getStyleableValue(string)) != null) {
            return object;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            @Override
            public void paint(Graphics graphics) {
                if (!FlatSplitPaneUI.this.isContinuousLayout() && FlatSplitPaneUI.this.getLastDragLocation() != -1) {
                    FlatSplitPaneUI.this.paintDragDivider(graphics, 0);
                }
            }
        };
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            this.paintDragDivider(graphics, this.getLastDragLocation());
        }
    }

    private void paintDragDivider(Graphics graphics, int n) {
        int n2 = this.getOrientation() == 1 ? 1 : 0;
        int n3 = n2 != 0 ? n : 0;
        n = n2 == 0 ? n : 0;
        int n4 = n2 != 0 ? this.dividerSize : this.splitPane.getWidth();
        n2 = n2 == 0 ? this.dividerSize : this.splitPane.getHeight();
        graphics.setColor(FlatUIUtils.deriveColor(this.draggingColor, this.splitPane.getBackground()));
        graphics.fillRect(n3, n, n4, n2);
        if (this.divider instanceof FlatSplitPaneDivider) {
            ((FlatSplitPaneDivider)this.divider).paintStyle(graphics, n3, n, n4, n2);
        }
    }

    @Override
    public Boolean isTitleBarCaptionAt(int n, int n2) {
        return null;
    }

    protected class FlatSplitPaneDivider
    extends BasicSplitPaneDivider {
        @FlatStylingSupport.Styleable
        protected String style;
        @FlatStylingSupport.Styleable
        protected Color hoverColor;
        @FlatStylingSupport.Styleable
        protected Color pressedColor;
        @FlatStylingSupport.Styleable
        protected Color gripColor;
        @FlatStylingSupport.Styleable
        protected int gripDotCount;
        @FlatStylingSupport.Styleable
        protected int gripDotSize;
        @FlatStylingSupport.Styleable
        protected int gripGap;

        protected FlatSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
            super(basicSplitPaneUI);
            this.style = UIManager.getString("SplitPaneDivider.style");
            this.hoverColor = UIManager.getColor("SplitPaneDivider.hoverColor");
            this.pressedColor = UIManager.getColor("SplitPaneDivider.pressedColor");
            this.gripColor = UIManager.getColor("SplitPaneDivider.gripColor");
            this.gripDotCount = FlatUIUtils.getUIInt("SplitPaneDivider.gripDotCount", 3);
            this.gripDotSize = FlatUIUtils.getUIInt("SplitPaneDivider.gripDotSize", 3);
            this.gripGap = FlatUIUtils.getUIInt("SplitPaneDivider.gripGap", 2);
            this.setLayout(new FlatDividerLayout());
        }

        protected Object applyStyleProperty(String string, Object object) {
            return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
        }

        public Map<String, Class<?>> getStyleableInfos() {
            return FlatStylingSupport.getAnnotatedStyleableInfos(this);
        }

        public Object getStyleableValue(String string) {
            return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
        }

        void updateStyle() {
            if (this.leftButton instanceof FlatOneTouchButton) {
                ((FlatOneTouchButton)this.leftButton).updateStyle();
            }
            if (this.rightButton instanceof FlatOneTouchButton) {
                ((FlatOneTouchButton)this.rightButton).updateStyle();
            }
        }

        @Override
        public void setDividerSize(int n) {
            super.setDividerSize(UIScale.scale(n));
        }

        @Override
        protected JButton createLeftOneTouchButton() {
            return new FlatOneTouchButton(true);
        }

        @Override
        protected JButton createRightOneTouchButton() {
            return new FlatOneTouchButton(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent object) {
            super.propertyChange((PropertyChangeEvent)object);
            switch (((PropertyChangeEvent)object).getPropertyName()) {
                case "dividerLocation": {
                    this.doLayout();
                    return;
                }
                case "JSplitPane.expandableSide": {
                    this.revalidate();
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            Color color;
            if ((FlatSplitPaneUI.this.isContinuousLayout() && this.dragger != null ? this.pressedColor : (color = this.isMouseOver() && this.dragger == null ? this.hoverColor : null)) != null) {
                graphics.setColor(FlatUIUtils.deriveColor(color, this.splitPane.getBackground()));
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(graphics);
            this.paintStyle(graphics, 0, 0, this.getWidth(), this.getHeight());
        }

        protected void paintStyle(Graphics graphics, int n, int n2, int n3, int n4) {
            if ("plain".equals(this.style)) {
                return;
            }
            Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
            graphics.setColor(this.gripColor);
            this.paintGrip(graphics, n, n2, n3, n4);
            FlatUIUtils.resetRenderingHints(graphics, objectArray);
        }

        protected void paintGrip(Graphics graphics, int n, int n2, int n3, int n4) {
            FlatUIUtils.paintGrip(graphics, n, n2, n3, n4, this.splitPane.getOrientation() == 0, this.gripDotCount, this.gripDotSize, this.gripGap, true);
        }

        protected boolean isLeftCollapsed() {
            int n = this.splitPane.getDividerLocation();
            Insets insets = this.splitPane.getInsets();
            if (this.orientation == 0) {
                return n == insets.top;
            }
            return n == insets.left;
        }

        protected boolean isRightCollapsed() {
            int n = this.splitPane.getDividerLocation();
            Insets insets = this.splitPane.getInsets();
            if (this.orientation == 0) {
                return n == this.splitPane.getHeight() - this.getHeight() - insets.bottom;
            }
            return n == this.splitPane.getWidth() - this.getWidth() - insets.right;
        }

        @Override
        protected void setMouseOver(boolean bl) {
            super.setMouseOver(bl);
            this.repaintIfNecessary();
        }

        @Override
        protected void prepareForDragging() {
            super.prepareForDragging();
            this.repaintIfNecessary();
        }

        @Override
        protected void finishDraggingTo(int n) {
            super.finishDraggingTo(n);
            this.repaintIfNecessary();
        }

        private void repaintIfNecessary() {
            if (this.hoverColor != null || this.pressedColor != null) {
                this.repaint();
            }
        }

        protected class FlatDividerLayout
        extends BasicSplitPaneDivider.DividerLayout {
            protected FlatDividerLayout() {
                super(FlatSplitPaneDivider.this);
            }

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                if (FlatSplitPaneDivider.this.leftButton == null || FlatSplitPaneDivider.this.rightButton == null || !FlatSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    return;
                }
                int n = UIScale.scale(4);
                if (FlatSplitPaneDivider.this.orientation == 0) {
                    FlatSplitPaneDivider.this.leftButton.setSize(FlatSplitPaneDivider.this.leftButton.getWidth() + n, FlatSplitPaneDivider.this.leftButton.getHeight());
                    FlatSplitPaneDivider.this.rightButton.setBounds(FlatSplitPaneDivider.this.leftButton.getX() + FlatSplitPaneDivider.this.leftButton.getWidth(), FlatSplitPaneDivider.this.rightButton.getY(), FlatSplitPaneDivider.this.rightButton.getWidth() + n, FlatSplitPaneDivider.this.rightButton.getHeight());
                } else {
                    FlatSplitPaneDivider.this.leftButton.setSize(FlatSplitPaneDivider.this.leftButton.getWidth(), FlatSplitPaneDivider.this.leftButton.getHeight() + n);
                    FlatSplitPaneDivider.this.rightButton.setBounds(FlatSplitPaneDivider.this.rightButton.getX(), FlatSplitPaneDivider.this.leftButton.getY() + FlatSplitPaneDivider.this.leftButton.getHeight(), FlatSplitPaneDivider.this.rightButton.getWidth(), FlatSplitPaneDivider.this.rightButton.getHeight() + n);
                }
                n = FlatSplitPaneDivider.this.isLeftCollapsed() ? 1 : 0;
                boolean bl = FlatSplitPaneDivider.this.isRightCollapsed();
                if (n != 0 || bl) {
                    FlatSplitPaneDivider.this.leftButton.setVisible(n == 0);
                    FlatSplitPaneDivider.this.rightButton.setVisible(!bl);
                } else {
                    Object object = FlatSplitPaneDivider.this.splitPane.getClientProperty("JSplitPane.expandableSide");
                    FlatSplitPaneDivider.this.leftButton.setVisible(object == null || !"left".equals(object));
                    FlatSplitPaneDivider.this.rightButton.setVisible(object == null || !"right".equals(object));
                }
                if (!FlatSplitPaneDivider.this.leftButton.isVisible()) {
                    FlatSplitPaneDivider.this.rightButton.setLocation(FlatSplitPaneDivider.this.leftButton.getLocation());
                }
            }
        }

        protected class FlatOneTouchButton
        extends FlatArrowButton {
            protected final boolean left;

            protected FlatOneTouchButton(boolean bl) {
                super(1, FlatSplitPaneUI.this.arrowType, FlatSplitPaneUI.this.oneTouchArrowColor, null, FlatSplitPaneUI.this.oneTouchHoverArrowColor, null, FlatSplitPaneUI.this.oneTouchPressedArrowColor, null);
                this.setCursor(Cursor.getPredefinedCursor(0));
                ToolTipManager.sharedInstance().registerComponent(this);
                this.left = bl;
            }

            protected void updateStyle() {
                FlatOneTouchButton flatOneTouchButton = this;
                flatOneTouchButton.updateStyle(flatOneTouchButton.FlatSplitPaneUI.this.arrowType, FlatSplitPaneUI.this.oneTouchArrowColor, null, FlatSplitPaneUI.this.oneTouchHoverArrowColor, null, FlatSplitPaneUI.this.oneTouchPressedArrowColor, null);
            }

            @Override
            public int getDirection() {
                if (FlatSplitPaneDivider.this.orientation == 0) {
                    if (this.left) {
                        return 1;
                    }
                    return 5;
                }
                if (this.left) {
                    return 7;
                }
                return 3;
            }

            @Override
            public String getToolTipText(MouseEvent object) {
                object = FlatSplitPaneDivider.this.orientation == 0 ? (this.left ? (FlatSplitPaneDivider.this.isRightCollapsed() ? "SplitPaneDivider.expandBottomToolTipText" : "SplitPaneDivider.collapseTopToolTipText") : (FlatSplitPaneDivider.this.isLeftCollapsed() ? "SplitPaneDivider.expandTopToolTipText" : "SplitPaneDivider.collapseBottomToolTipText")) : (this.left ? (FlatSplitPaneDivider.this.isRightCollapsed() ? "SplitPaneDivider.expandRightToolTipText" : "SplitPaneDivider.collapseLeftToolTipText") : (FlatSplitPaneDivider.this.isLeftCollapsed() ? "SplitPaneDivider.expandLeftToolTipText" : "SplitPaneDivider.collapseRightToolTipText"));
                Object object2 = FlatSplitPaneDivider.this.splitPane.getClientProperty(object);
                if (object2 instanceof String) {
                    return (String)object2;
                }
                return UIManager.getString(object, this.getLocale());
            }
        }
    }
}

