/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.awt.Color;

public class HSLColor {
    private final Color rgb;
    private final float[] hsl;
    private final float alpha;

    public HSLColor(Color color) {
        this.rgb = color;
        this.hsl = HSLColor.fromRGB(color);
        this.alpha = (float)color.getAlpha() / 255.0f;
    }

    public HSLColor(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public HSLColor(float f, float f2, float f3, float f4) {
        this.hsl = new float[]{f, f2, f3};
        this.alpha = f4;
        this.rgb = HSLColor.toRGB(this.hsl, f4);
    }

    public HSLColor(float[] fArray) {
        this(fArray, 1.0f);
    }

    public HSLColor(float[] fArray, float f) {
        this.hsl = fArray;
        this.alpha = f;
        this.rgb = HSLColor.toRGB(fArray, f);
    }

    public Color adjustHue(float f) {
        return HSLColor.toRGB(f, this.hsl[1], this.hsl[2], this.alpha);
    }

    public Color adjustLuminance(float f) {
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f, this.alpha);
    }

    public Color adjustSaturation(float f) {
        return HSLColor.toRGB(this.hsl[0], f, this.hsl[2], this.alpha);
    }

    public Color adjustShade(float f) {
        f = (100.0f - f) / 100.0f;
        f = Math.max(0.0f, this.hsl[2] * f);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f, this.alpha);
    }

    public Color adjustTone(float f) {
        f = (f + 100.0f) / 100.0f;
        f = Math.min(100.0f, this.hsl[2] * f);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f, this.alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color getComplementary() {
        float f = (this.hsl[0] + 180.0f) % 360.0f;
        return HSLColor.toRGB(f, this.hsl[1], this.hsl[2]);
    }

    public float getHue() {
        return this.hsl[0];
    }

    public float[] getHSL() {
        return this.hsl;
    }

    public float getLuminance() {
        return this.hsl[2];
    }

    public Color getRGB() {
        return this.rgb;
    }

    public float getSaturation() {
        return this.hsl[1];
    }

    public String toString() {
        String string = "HSLColor[h=" + this.hsl[0] + ",s=" + this.hsl[1] + ",l=" + this.hsl[2] + ",alpha=" + this.alpha + "]";
        return string;
    }

    public static float[] fromRGB(Color object) {
        float[] fArray = ((Color)object).getRGBColorComponents(null);
        object = fArray;
        float f = fArray[0];
        Object object2 = object[1];
        Object object3 = object[2];
        float f2 = Math.min(f, Math.min((float)object2, (float)object3));
        float f3 = Math.max(f, Math.max((float)object2, (float)object3));
        float f4 = 0.0f;
        if (f3 == f2) {
            f4 = 0.0f;
        } else if (f3 == f) {
            f4 = (60.0f * (object2 - object3) / (f3 - f2) + 360.0f) % 360.0f;
        } else if (f3 == object2) {
            f4 = 60.0f * (object3 - f) / (f3 - f2) + 120.0f;
        } else if (f3 == object3) {
            f4 = 60.0f * (f - object2) / (f3 - f2) + 240.0f;
        }
        object3 = (f3 + f2) / 2.0f;
        f = f3 == f2 ? 0.0f : (object3 <= 0.5f ? (f3 - f2) / (f3 + f2) : (f3 - f2) / (2.0f - f3 - f2));
        return new float[]{f4, f * 100.0f, (float)(object3 * 100.0f)};
    }

    public static Color toRGB(float[] fArray) {
        return HSLColor.toRGB(fArray, 1.0f);
    }

    public static Color toRGB(float[] fArray, float f) {
        return HSLColor.toRGB(fArray[0], fArray[1], fArray[2], f);
    }

    public static Color toRGB(float f, float f2, float f3) {
        return HSLColor.toRGB(f, f2, f3, 1.0f);
    }

    public static Color toRGB(float f, float f2, float f3, float f4) {
        float f5;
        if (f2 < 0.0f || f2 > 100.0f) {
            String string = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(string);
        }
        if (f3 < 0.0f || f3 > 100.0f) {
            String string = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f || f4 > 1.0f) {
            String string = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(string);
        }
        f %= 360.0f;
        f2 /= 100.0f;
        f2 = (double)f5 < 0.5 ? f3 * (f2 + 1.0f) : (f3 /= 100.0f) + f2 - f2 * f3;
        f3 = f3 * 2.0f - f2;
        float f6 = Math.max(0.0f, HSLColor.HueToRGB(f3, f2, (f /= 360.0f) + 0.33333334f));
        float f7 = Math.max(0.0f, HSLColor.HueToRGB(f3, f2, f));
        f = Math.max(0.0f, HSLColor.HueToRGB(f3, f2, f - 0.33333334f));
        f6 = Math.min(f6, 1.0f);
        f7 = Math.min(f7, 1.0f);
        f = Math.min(f, 1.0f);
        return new Color(f6, f7, f, f4);
    }

    private static float HueToRGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (f3 * 2.0f < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * 6.0f * (0.6666667f - f3);
        }
        return f;
    }
}

