/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final EnhancedHandle<?> NOOP_HANDLE = new EnhancedHandle<Object>(){

        @Override
        public final void recycle(Object object) {
        }

        @Override
        public final void unguardedRecycle(Object object) {
        }

        public final String toString() {
            return "NOOP_HANDLE";
        }
    };
    private static final int DEFAULT_INITIAL_MAX_CAPACITY_PER_THREAD = 4096;
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int RATIO;
    private static final int DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD;
    private static final boolean BLOCKING_POOL;
    private static final boolean BATCH_FAST_TL_ONLY;
    private final int maxCapacityPerThread;
    private final int interval;
    private final int chunkSize;
    private final FastThreadLocal<LocalPool<T>> threadLocal = new FastThreadLocal<LocalPool<T>>(){

        @Override
        protected LocalPool<T> initialValue() {
            return new LocalPool(Recycler.this.maxCapacityPerThread, Recycler.this.interval, Recycler.this.chunkSize);
        }

        @Override
        protected void onRemoval(LocalPool<T> localPool) {
            super.onRemoval(localPool);
            MessagePassingQueue messagePassingQueue = localPool.pooledHandles;
            localPool.pooledHandles = null;
            localPool.owner = null;
            messagePassingQueue.clear();
        }
    };

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    protected Recycler(int n) {
        this(n, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    @Deprecated
    protected Recycler(int n, int n2) {
        this(n, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    @Deprecated
    protected Recycler(int n, int n2, int n3, int n4) {
        this(n, n3, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    @Deprecated
    protected Recycler(int n, int n2, int n3, int n4, int n5) {
        this(n, n3, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    protected Recycler(int n, int n2, int n3) {
        this.interval = Math.max(0, n2);
        if (n <= 0) {
            this.maxCapacityPerThread = 0;
            this.chunkSize = 0;
            return;
        }
        this.maxCapacityPerThread = Math.max(4, n);
        this.chunkSize = Math.max(2, Math.min(n3, this.maxCapacityPerThread >> 1));
    }

    public final T get() {
        if (this.maxCapacityPerThread == 0) {
            return (T)this.newObject(NOOP_HANDLE);
        }
        LocalPool<Object> localPool = this.threadLocal.get();
        DefaultHandle<LocalPool<T>> defaultHandle = localPool.claim();
        if (defaultHandle == null) {
            defaultHandle = localPool.newHandle();
            if (defaultHandle != null) {
                localPool = this.newObject(defaultHandle);
                defaultHandle.set(localPool);
            } else {
                localPool = this.newObject(NOOP_HANDLE);
            }
        } else {
            localPool = defaultHandle.get();
        }
        return (T)localPool;
    }

    @Deprecated
    public final boolean recycle(T t, Handle<T> handle) {
        if (handle == NOOP_HANDLE) {
            return false;
        }
        handle.recycle(t);
        return true;
    }

    final int threadLocalSize() {
        LocalPool<T> localPool = this.threadLocal.getIfExists();
        if (localPool == null) {
            return 0;
        }
        return ((LocalPool)localPool).pooledHandles.size() + ((LocalPool)localPool).batch.size();
    }

    protected abstract T newObject(Handle<T> var1);

    static {
        int n = SystemPropertyUtil.getInt("io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("io.netty.recycler.maxCapacity", 4096));
        if (n < 0) {
            n = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = n;
        DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD = SystemPropertyUtil.getInt("io.netty.recycler.chunkSize", 32);
        RATIO = Math.max(0, SystemPropertyUtil.getInt("io.netty.recycler.ratio", 8));
        BLOCKING_POOL = SystemPropertyUtil.getBoolean("io.netty.recycler.blocking", false);
        BATCH_FAST_TL_ONLY = SystemPropertyUtil.getBoolean("io.netty.recycler.batchFastThreadLocalOnly", true);
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
                logger.debug("-Dio.netty.recycler.chunkSize: disabled");
                logger.debug("-Dio.netty.recycler.blocking: disabled");
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
                logger.debug("-Dio.netty.recycler.chunkSize: {}", (Object)DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
                logger.debug("-Dio.netty.recycler.blocking: {}", (Object)BLOCKING_POOL);
                logger.debug("-Dio.netty.recycler.batchFastThreadLocalOnly: {}", (Object)BATCH_FAST_TL_ONLY);
            }
        }
    }

    private static final class BlockingMessageQueue<T>
    implements MessagePassingQueue<T> {
        private final Queue<T> deque;
        private final int maxCapacity;

        BlockingMessageQueue(int n) {
            this.maxCapacity = n;
            this.deque = new ArrayDeque<T>();
        }

        @Override
        public final synchronized boolean offer(T t) {
            if (this.deque.size() == this.maxCapacity) {
                return false;
            }
            return this.deque.offer(t);
        }

        @Override
        public final synchronized T poll() {
            return this.deque.poll();
        }

        @Override
        public final synchronized T peek() {
            return this.deque.peek();
        }

        @Override
        public final synchronized int size() {
            return this.deque.size();
        }

        @Override
        public final synchronized void clear() {
            this.deque.clear();
        }

        @Override
        public final synchronized boolean isEmpty() {
            return this.deque.isEmpty();
        }

        @Override
        public final int capacity() {
            return this.maxCapacity;
        }

        @Override
        public final boolean relaxedOffer(T t) {
            return this.offer(t);
        }

        @Override
        public final T relaxedPoll() {
            return this.poll();
        }

        @Override
        public final T relaxedPeek() {
            return this.peek();
        }

        @Override
        public final int drain(MessagePassingQueue.Consumer<T> consumer, int n) {
            T t;
            int n2;
            for (n2 = 0; n2 < n && (t = this.poll()) != null; ++n2) {
                consumer.accept(t);
            }
            return n2;
        }

        @Override
        public final int fill(MessagePassingQueue.Supplier<T> supplier, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int drain(MessagePassingQueue.Consumer<T> consumer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int fill(MessagePassingQueue.Supplier<T> supplier) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void drain(MessagePassingQueue.Consumer<T> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void fill(MessagePassingQueue.Supplier<T> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LocalPool<T>
    implements MessagePassingQueue.Consumer<DefaultHandle<T>> {
        private final int ratioInterval;
        private final int chunkSize;
        private final ArrayDeque<DefaultHandle<T>> batch;
        private volatile Thread owner;
        private volatile MessagePassingQueue<DefaultHandle<T>> pooledHandles;
        private int ratioCounter;

        LocalPool(int n, int n2, int n3) {
            this.ratioInterval = n2;
            this.chunkSize = n3;
            this.batch = new ArrayDeque(n3);
            Thread thread = Thread.currentThread();
            this.owner = !BATCH_FAST_TL_ONLY || thread instanceof FastThreadLocalThread ? thread : null;
            this.pooledHandles = BLOCKING_POOL ? new BlockingMessageQueue<DefaultHandle<T>>(n) : (MessagePassingQueue)((Object)PlatformDependent.newMpscQueue(n3, n));
            this.ratioCounter = n2;
        }

        final DefaultHandle<T> claim() {
            MessagePassingQueue<DefaultHandle<T>> messagePassingQueue = this.pooledHandles;
            if (messagePassingQueue == null) {
                return null;
            }
            if (this.batch.isEmpty()) {
                LocalPool localPool = this;
                messagePassingQueue.drain(localPool, localPool.chunkSize);
            }
            if ((messagePassingQueue = this.batch.pollLast()) != null) {
                ((DefaultHandle)((Object)messagePassingQueue)).toClaimed();
            }
            return messagePassingQueue;
        }

        final void release(DefaultHandle<T> defaultHandle, boolean bl) {
            if (bl) {
                defaultHandle.toAvailable();
            } else {
                defaultHandle.unguardedToAvailable();
            }
            MessagePassingQueue<DefaultHandle<T>> messagePassingQueue = this.owner;
            if (messagePassingQueue != null && Thread.currentThread() == messagePassingQueue && this.batch.size() < this.chunkSize) {
                this.accept(defaultHandle);
                return;
            }
            if (messagePassingQueue != null && LocalPool.isTerminated((Thread)((Object)messagePassingQueue))) {
                this.owner = null;
                this.pooledHandles = null;
                return;
            }
            messagePassingQueue = this.pooledHandles;
            if (messagePassingQueue != null) {
                messagePassingQueue.relaxedOffer(defaultHandle);
            }
        }

        private static boolean isTerminated(Thread thread) {
            if (PlatformDependent.isJ9Jvm()) {
                return !thread.isAlive();
            }
            return thread.getState() == Thread.State.TERMINATED;
        }

        final DefaultHandle<T> newHandle() {
            if (++this.ratioCounter >= this.ratioInterval) {
                this.ratioCounter = 0;
                return new DefaultHandle(this);
            }
            return null;
        }

        @Override
        public final void accept(DefaultHandle<T> defaultHandle) {
            this.batch.addLast(defaultHandle);
        }
    }

    private static final class DefaultHandle<T>
    extends EnhancedHandle<T> {
        private static final int STATE_CLAIMED = 0;
        private static final int STATE_AVAILABLE = 1;
        private static final AtomicIntegerFieldUpdater<DefaultHandle<?>> STATE_UPDATER;
        private volatile int state;
        private final LocalPool<T> localPool;
        private T value;

        DefaultHandle(LocalPool<T> localPool) {
            this.localPool = localPool;
        }

        @Override
        public final void recycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.localPool.release(this, true);
        }

        @Override
        public final void unguardedRecycle(Object object) {
            if (object != this.value) {
                throw new IllegalArgumentException("object does not belong to handle");
            }
            this.localPool.release(this, false);
        }

        final T get() {
            return this.value;
        }

        final void set(T t) {
            this.value = t;
        }

        final void toClaimed() {
            assert (this.state == 1);
            STATE_UPDATER.lazySet(this, 0);
        }

        final void toAvailable() {
            int n = STATE_UPDATER.getAndSet(this, 1);
            if (n == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
        }

        final void unguardedToAvailable() {
            int n = this.state;
            if (n == 1) {
                throw new IllegalStateException("Object has been recycled already.");
            }
            STATE_UPDATER.lazySet(this, 1);
        }

        static {
            AtomicIntegerFieldUpdater<DefaultHandle> atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultHandle.class, "state");
            STATE_UPDATER = atomicIntegerFieldUpdater;
        }
    }

    public static abstract class EnhancedHandle<T>
    implements Handle<T> {
        public abstract void unguardedRecycle(Object var1);

        private EnhancedHandle() {
        }
    }

    public static interface Handle<T>
    extends ObjectPool.Handle<T> {
    }
}

