/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;
    private final boolean logNotifyFailure;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promiseArray) {
        this(true, promiseArray);
    }

    @SafeVarargs
    public PromiseNotifier(boolean bl, Promise<? super V> ... promiseArray) {
        ObjectUtil.checkNotNull(promiseArray, "promises");
        Promise<? super V>[] promiseArray2 = promiseArray;
        int n = promiseArray.length;
        for (int i = 0; i < n; ++i) {
            Promise<? super V> promise = promiseArray2[i];
            ObjectUtil.checkNotNullWithIAE(promise, "promise");
        }
        this.promises = (Promise[])promiseArray.clone();
        this.logNotifyFailure = bl;
    }

    public static <V, F extends Future<V>> F cascade(F f, Promise<? super V> promise) {
        return PromiseNotifier.cascade(true, f, promise);
    }

    public static <V, F extends Future<V>> F cascade(boolean bl, final F f, final Promise<? super V> promise) {
        promise.addListener(new FutureListener(){

            @Override
            public final void operationComplete(Future future) {
                if (future.isCancelled()) {
                    f.cancel(false);
                }
            }
        });
        f.addListener(new PromiseNotifier(bl, new Promise[]{promise}){

            @Override
            public final void operationComplete(Future future) {
                if (promise.isCancelled() && future.isCancelled()) {
                    return;
                }
                2 v0 = this;
                super.operationComplete(v0.f);
            }
        });
        return f;
    }

    @Override
    public void operationComplete(F object) {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (object.isSuccess()) {
            object = object.get();
            Promise<? super V>[] promiseArray = this.promises;
            int n = this.promises.length;
            for (int i = 0; i < n; ++i) {
                Promise<? super V> promise = promiseArray[i];
                PromiseNotificationUtil.trySuccess(promise, object, internalLogger);
            }
            return;
        }
        if (object.isCancelled()) {
            object = this.promises;
            int n = this.promises.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                PromiseNotificationUtil.tryCancel(object2, internalLogger);
            }
            return;
        }
        object = object.cause();
        Promise<? super V>[] promiseArray = this.promises;
        int n = this.promises.length;
        for (int i = 0; i < n; ++i) {
            Promise<? super V> promise = promiseArray[i];
            PromiseNotificationUtil.tryFailure(promise, (Throwable)object, internalLogger);
        }
    }
}

