/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueueL3Pad;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeLongArrayAccess;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class MpmcArrayQueue<E>
extends MpmcArrayQueueL3Pad<E> {
    public static final int MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.mpmc.max.lookahead.step", 4096);
    private final int lookAheadStep = Math.max(2, Math.min(this.capacity() / 4, MAX_LOOK_AHEAD_STEP));

    public MpmcArrayQueue(int n) {
        super(RangeUtil.checkGreaterThanOrEqual(n, 2, "capacity"));
    }

    @Override
    public boolean offer(E e) {
        long l;
        long l2;
        if (e == null) {
            throw new NullPointerException();
        }
        long l3 = this.mask;
        long l4 = l3 + 1L;
        long[] lArray = this.sequenceBuffer;
        long l5 = Long.MIN_VALUE;
        while (true) {
            long l6;
            if ((l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l2 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l = this.lvProducerIndex(), l3))) < l) {
                if (l - l4 >= l5 && l - l4 >= (l5 = this.lvConsumerIndex())) {
                    return false;
                }
                l6 = l + 1L;
            }
            if (l6 > l) continue;
            long l7 = l;
            if (this.casProducerIndex(l7, l7 + 1L)) break;
        }
        UnsafeRefArrayAccess.spRefElement(this.buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l, l3), e);
        UnsafeLongArrayAccess.soLongElement(lArray, l2, l + 1L);
        return true;
    }

    @Override
    public E poll() {
        long l;
        long l2;
        long[] lArray = this.sequenceBuffer;
        long l3 = this.mask;
        long l4 = -1L;
        while (true) {
            long l5;
            long l6;
            if ((l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l2 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l = this.lvConsumerIndex(), l3))) < (l5 = l + 1L)) {
                if (l >= l4 && l == (l4 = this.lvProducerIndex())) {
                    return null;
                }
                l6 = l5 + 1L;
            }
            if (l6 > l5) continue;
            long l7 = l;
            if (this.casConsumerIndex(l7, l7 + 1L)) break;
        }
        long l8 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l, l3);
        Object e = UnsafeRefArrayAccess.lpRefElement(this.buffer, l8);
        UnsafeRefArrayAccess.spRefElement(this.buffer, l8, null);
        UnsafeLongArrayAccess.soLongElement(lArray, l2, l + l3 + 1L);
        return e;
    }

    @Override
    public E peek() {
        Object e;
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        long l2 = -1L;
        while (true) {
            long l3;
            long l4;
            long l5;
            long l6;
            if ((l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l5 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l4 = this.lvConsumerIndex(), l))) < (l3 = l4 + 1L)) {
                if (l4 < l2 || l4 != (l2 = this.lvProducerIndex())) continue;
                return null;
            }
            if (l6 != l3) continue;
            long l7 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l4, l);
            e = UnsafeRefArrayAccess.lvRefElement(this.buffer, l7);
            if (this.lvConsumerIndex() == l4) break;
        }
        return e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        long l;
        long l2;
        if (e == null) {
            throw new NullPointerException();
        }
        long l3 = this.mask;
        long[] lArray = this.sequenceBuffer;
        while (true) {
            long l4;
            if ((l4 = UnsafeLongArrayAccess.lvLongElement(lArray, l2 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l = this.lvProducerIndex(), l3))) < l) {
                return false;
            }
            if (l4 > l) continue;
            long l5 = l;
            if (this.casProducerIndex(l5, l5 + 1L)) break;
        }
        UnsafeRefArrayAccess.spRefElement(this.buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(l, l3), e);
        UnsafeLongArrayAccess.soLongElement(lArray, l2, l + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        long l;
        long l2;
        long l3;
        long l4;
        long[] lArray = this.sequenceBuffer;
        long l5 = this.mask;
        do {
            if ((l4 = UnsafeLongArrayAccess.lvLongElement(lArray, l = UnsafeLongArrayAccess.calcCircularLongElementOffset(l2 = this.lvConsumerIndex(), l5))) >= (l3 = l2 + 1L)) continue;
            return null;
        } while (l4 > l3 || !this.casConsumerIndex(l2, l3));
        long l6 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l5);
        Object e = UnsafeRefArrayAccess.lpRefElement(this.buffer, l6);
        UnsafeRefArrayAccess.spRefElement(this.buffer, l6, null);
        UnsafeLongArrayAccess.soLongElement(lArray, l, l2 + l5 + 1L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        Object e;
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        while (true) {
            long l2;
            long l3;
            long l4;
            long l5;
            if ((l5 = UnsafeLongArrayAccess.lvLongElement(lArray, l4 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l3 = this.lvConsumerIndex(), l))) < (l2 = l3 + 1L)) {
                return null;
            }
            if (l5 != l2) continue;
            long l6 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l3, l);
            e = UnsafeRefArrayAccess.lvRefElement(this.buffer, l6);
            if (this.lvConsumerIndex() == l3) break;
        }
        return e;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer, int n) {
        int n2;
        if (consumer == null) {
            throw new IllegalArgumentException("c is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative: " + n);
        }
        if (n == 0) {
            return 0;
        }
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        E[] EArray = this.buffer;
        int n3 = Math.min(this.lookAheadStep, n);
        for (int i = 0; i < n; i += n2) {
            long l2;
            int n4 = n - i;
            n2 = Math.min(n4, n3);
            long l3 = this.lvConsumerIndex();
            long l4 = l3 + (long)n2 - 1L;
            long l5 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l4, l);
            long l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l5);
            if (l6 == (l2 = l4 + 1L) && this.casConsumerIndex(l3, l2)) {
                for (n4 = 0; n4 < n2; ++n4) {
                    long l7 = l3 + (long)n4;
                    long l8 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l7, l);
                    long l9 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l7, l);
                    long l10 = l7 + 1L;
                    while (UnsafeLongArrayAccess.lvLongElement(lArray, l8) != l10) {
                    }
                    Object e = UnsafeRefArrayAccess.lpRefElement(EArray, l9);
                    UnsafeRefArrayAccess.spRefElement(EArray, l9, null);
                    UnsafeLongArrayAccess.soLongElement(lArray, l8, l7 + l + 1L);
                    consumer.accept(e);
                }
                continue;
            }
            if (l6 < l2 && this.notAvailable(l3, l, lArray, l3 + 1L)) {
                return i;
            }
            return i + this.drainOneByOne(consumer, n4);
        }
        return n;
    }

    private int drainOneByOne(MessagePassingQueue.Consumer<E> consumer, int n) {
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        E[] EArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3;
            while (true) {
                long l4;
                long l5;
                if ((l5 = UnsafeLongArrayAccess.lvLongElement(lArray, l3 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l2 = this.lvConsumerIndex(), l))) < (l4 = l2 + 1L)) {
                    return i;
                }
                if (l5 > l4) continue;
                long l6 = l2;
                if (this.casConsumerIndex(l6, l6 + 1L)) break;
            }
            long l7 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l);
            Object e = UnsafeRefArrayAccess.lpRefElement(EArray, l7);
            UnsafeRefArrayAccess.spRefElement(EArray, l7, null);
            UnsafeLongArrayAccess.soLongElement(lArray, l3, l2 + l + 1L);
            consumer.accept(e);
        }
        return n;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier, int n) {
        int n2;
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("limit is negative:" + n);
        }
        if (n == 0) {
            return 0;
        }
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        E[] EArray = this.buffer;
        int n3 = Math.min(this.lookAheadStep, n);
        for (int i = 0; i < n; i += n2) {
            long l2;
            int n4 = n - i;
            n2 = Math.min(n4, n3);
            long l3 = this.lvProducerIndex();
            long l4 = l3 + (long)n2 - 1L;
            long l5 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l4, l);
            long l6 = UnsafeLongArrayAccess.lvLongElement(lArray, l5);
            if (l6 == (l2 = l4) && this.casProducerIndex(l3, l2 + 1L)) {
                for (n4 = 0; n4 < n2; ++n4) {
                    long l7 = l3 + (long)n4;
                    long l8 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l7, l);
                    long l9 = UnsafeRefArrayAccess.calcCircularRefElementOffset(l7, l);
                    while (UnsafeLongArrayAccess.lvLongElement(lArray, l8) != l7) {
                    }
                    UnsafeRefArrayAccess.soRefElement(EArray, l9, supplier.get());
                    UnsafeLongArrayAccess.soLongElement(lArray, l8, l7 + 1L);
                }
                continue;
            }
            if (l6 < l2 && this.notAvailable(l3, l, lArray, l3)) {
                return i;
            }
            return i + this.fillOneByOne(supplier, n4);
        }
        return n;
    }

    private boolean notAvailable(long l, long l2, long[] lArray, long l3) {
        long l4 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l, l2);
        long l5 = UnsafeLongArrayAccess.lvLongElement(lArray, l4);
        return l5 < l3;
    }

    private int fillOneByOne(MessagePassingQueue.Supplier<E> supplier, int n) {
        long[] lArray = this.sequenceBuffer;
        long l = this.mask;
        E[] EArray = this.buffer;
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3;
            while (true) {
                long l4;
                if ((l4 = UnsafeLongArrayAccess.lvLongElement(lArray, l3 = UnsafeLongArrayAccess.calcCircularLongElementOffset(l2 = this.lvProducerIndex(), l))) < l2) {
                    return i;
                }
                if (l4 > l2) continue;
                long l5 = l2;
                if (this.casProducerIndex(l5, l5 + 1L)) break;
            }
            UnsafeRefArrayAccess.soRefElement(EArray, UnsafeRefArrayAccess.calcCircularRefElementOffset(l2, l), supplier.get());
            UnsafeLongArrayAccess.soLongElement(lArray, l3, l2 + 1L);
        }
        return n;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> consumer) {
        return MessagePassingQueueUtil.drain(this, consumer);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> supplier) {
        return MessagePassingQueueUtil.fillBounded(this, supplier);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> consumer, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.drain(this, consumer, waitStrategy, exitCondition);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> supplier, MessagePassingQueue.WaitStrategy waitStrategy, MessagePassingQueue.ExitCondition exitCondition) {
        MessagePassingQueueUtil.fill(this, supplier, waitStrategy, exitCondition);
    }
}

