/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;
    private int mark;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        this.mark = -1;
    }

    @Override
    public final int available() {
        return this.buf.remaining();
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final synchronized void mark(int n) {
        this.mark = this.buf.position();
    }

    @Override
    public final synchronized void reset() {
        if (this.mark == -1) {
            throw new IOException();
        }
        this.buf.position(this.mark);
    }

    @Override
    public final long skip(long l) {
        if (0L > l) {
            return 0L;
        }
        int n = (int)Math.min((long)this.buf.remaining(), l);
        this.buf.position(this.buf.position() + n);
        return n;
    }

    @Override
    public final int read() {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("offset " + n + ", length " + n2 + ", b.length " + byArray.length);
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.buf.remaining();
        if (n3 == 0) {
            return -1;
        }
        n2 = Math.min(n3, n2);
        if (this.buf.hasArray()) {
            System.arraycopy(this.buf.array(), this.buf.arrayOffset() + this.buf.position(), byArray, n, n2);
            this.buf.position(this.buf.position() + n2);
        } else {
            this.buf.get(byArray, n, n2);
        }
        return n2;
    }

    public final int read(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byteBuffer.remaining()) {
            throw new IndexOutOfBoundsException("length " + n + ", b " + byteBuffer);
        }
        if (n == 0) {
            return 0;
        }
        int n2 = this.buf.remaining();
        if (n2 == 0) {
            return -1;
        }
        n = Math.min(n2, n);
        if (this.buf.hasArray() && byteBuffer.hasArray()) {
            System.arraycopy(this.buf.array(), this.buf.arrayOffset() + this.buf.position(), byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
            this.buf.position(this.buf.position() + n);
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.position(byteBuffer2.position() + n);
        } else if (n == n2) {
            byteBuffer.put(this.buf);
        } else {
            n2 = this.buf.limit();
            this.buf.limit(n);
            try {
                byteBuffer.put(this.buf);
            }
            finally {
                this.buf.limit(n2);
            }
        }
        return n;
    }

    public final ByteBuffer getBuffer() {
        return this.buf;
    }
}

