/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jogamp.common.Debug;

public class JarUtil {
    private static final boolean DEBUG = Debug.debug("JarUtil");
    private static final int BUFFER_SIZE = 4096;
    private static Resolver resolver;

    public static void setResolver(Resolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Null Resolver passed");
        }
        if (JarUtil.resolver != null) {
            throw new IllegalStateException("Resolver already set!");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        JarUtil.resolver = resolver;
    }

    public static boolean hasJarUri(String string, ClassLoader classLoader) {
        try {
            return null != JarUtil.getJarUri(string, classLoader);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Uri getJarUri(String string, ClassLoader object) {
        if (string == null || object == null) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + string + ", cl " + object);
        }
        URL uRL = IOUtil.getClassURL(string, (ClassLoader)object);
        object = uRL.getProtocol();
        if (!(resolver == null || ((String)object).equals("jar") || ((String)object).equals("file") || ((String)object).equals("http") || ((String)object).equals("https"))) {
            URL uRL2 = resolver.resolve(uRL);
            object = Uri.valueOf(uRL2);
            if (DEBUG) {
                System.err.println("getJarUri Resolver: " + uRL + "\n\t-> " + uRL2 + "\n\t-> " + object);
            }
        } else {
            object = Uri.valueOf(uRL);
            if (DEBUG) {
                System.err.println("getJarUri Default " + uRL + "\n\t-> " + object);
            }
        }
        if (!((Uri)object).isJarScheme()) {
            throw new IllegalArgumentException("Uri is not using scheme jar: <" + object + ">");
        }
        if (DEBUG) {
            System.err.println("getJarUri res: " + string + " -> " + uRL + " -> " + object);
        }
        return object;
    }

    public static Uri.Encoded getJarBasename(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri is null");
        }
        if (!uri.isJarScheme()) {
            throw new IllegalArgumentException("Uri is not using scheme jar: <" + uri + ">");
        }
        Uri.Encoded encoded = uri.schemeSpecificPart;
        int n = encoded.lastIndexOf(33);
        if (n < 0) {
            throw new IllegalArgumentException("Uri does not contain jar uri terminator '!', in <" + uri + ">");
        }
        encoded = encoded.substring(0, n);
        n = encoded.lastIndexOf(47);
        if (n < 0 && (n = encoded.lastIndexOf(58)) < 0) {
            throw new IllegalArgumentException("Uri does not contain protocol terminator ':', in <" + uri + ">");
        }
        if (0 >= (encoded = encoded.substring(n + 1)).lastIndexOf(".jar")) {
            throw new IllegalArgumentException("No Jar name in <" + uri + ">");
        }
        if (DEBUG) {
            System.err.println("getJarName res: " + encoded);
        }
        return encoded;
    }

    public static Uri.Encoded getJarBasename(String string, ClassLoader classLoader) {
        return JarUtil.getJarBasename(JarUtil.getJarUri(string, classLoader));
    }

    public static Uri.Encoded getJarEntry(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri is null");
        }
        if (!uri.isJarScheme()) {
            throw new IllegalArgumentException("Uri is not a using scheme jar: <" + uri + ">");
        }
        Uri.Encoded encoded = uri.schemeSpecificPart;
        int n = encoded.lastIndexOf(33);
        if (n >= 0) {
            Uri.Encoded encoded2 = encoded.substring(n + 1);
            if (DEBUG) {
                System.err.println("getJarEntry res: " + uri + " -> " + encoded + " -> " + n + " -> " + encoded2);
            }
            return encoded2;
        }
        throw new IllegalArgumentException("JAR Uri does not contain jar uri terminator '!', uri <" + uri + ">");
    }

    public static Uri getJarFileUri(String object, ClassLoader classLoader) {
        if (object == null || classLoader == null) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + (String)object + ", cl " + classLoader);
        }
        object = JarUtil.getJarUri((String)object, classLoader).getContainedUri();
        object = Uri.cast("jar:" + ((Uri)object).toString() + "!/");
        if (DEBUG) {
            System.err.println("getJarFileUri res: " + object);
        }
        return object;
    }

    public static Uri getJarFileUri(Uri uri, Uri.Encoded encoded) {
        if (uri == null || encoded == null) {
            throw new IllegalArgumentException("null arguments: baseUri " + uri + ", jarFileName " + encoded);
        }
        return Uri.cast("jar:" + uri.toString() + encoded + "!/");
    }

    public static Uri getJarFileUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("jarSubUri is null");
        }
        return Uri.cast("jar:" + uri.toString() + "!/");
    }

    public static Uri getJarFileUri(Uri.Encoded encoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("jarSubUriS is null");
        }
        return Uri.cast("jar:" + encoded + "!/");
    }

    public static Uri getJarEntryUri(Uri uri, Uri.Encoded encoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("jarEntry is null");
        }
        return Uri.cast(uri.toString() + encoded);
    }

    public static JarFile getJarFile(String string, ClassLoader classLoader) {
        return JarUtil.getJarFile(JarUtil.getJarFileUri(string, classLoader));
    }

    public static JarFile getJarFile(Uri object) {
        URLConnection uRLConnection;
        if (object == null) {
            throw new IllegalArgumentException("null jarFileUri");
        }
        if (DEBUG) {
            System.err.println("getJarFile.0: " + ((Uri)object).toString());
        }
        object = ((Uri)object).toURL();
        if (DEBUG) {
            System.err.println("getJarFile.1: " + ((URL)object).toString());
        }
        if ((uRLConnection = ((URL)object).openConnection()) instanceof JarURLConnection) {
            object = (JarURLConnection)((URL)object).openConnection();
            object = ((JarURLConnection)object).getJarFile();
            if (DEBUG) {
                System.err.println("getJarFile res: " + ((ZipFile)object).getName());
            }
            return object;
        }
        if (DEBUG) {
            System.err.println("getJarFile res: NULL");
        }
        return null;
    }

    public static Uri getRelativeOf(Class<?> object, Uri.Encoded encoded, Uri.Encoded encoded2) {
        Object object2 = ((Class)object).getClassLoader();
        object2 = JarUtil.getJarUri(((Class)object).getName(), (ClassLoader)object2);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: (classFromJavaJar " + object + ", classJarUri " + object2 + ", cutOffInclSubDir " + encoded + ", relResPath " + encoded2 + "): ");
        }
        if ((object = ((Uri)object2).getContainedUri()) == null) {
            throw new IllegalArgumentException("JarSubUri is null of: " + object2);
        }
        object2 = ((Uri)object).getDirectory().getEncoded();
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: uri " + ((Uri)object).toString() + " -> " + object2);
        }
        object = encoded == null || ((Uri.Encoded)object2).endsWith(encoded.get()) ? ((Uri.Encoded)object2).concat(encoded2) : ((Uri.Encoded)object2).concat(encoded).concat(encoded2);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: ...  -> " + object);
        }
        object = JarUtil.getJarFileUri((Uri.Encoded)object);
        if (DEBUG) {
            System.err.println("JarUtil.getRelativeOf: fin " + object);
        }
        return object;
    }

    public static Map<String, String> getNativeLibNames(JarFile object) {
        if (DEBUG) {
            System.err.println("JarUtil: getNativeLibNames: " + object);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = ((JarFile)object).entries();
        while (object.hasMoreElements()) {
            Object object2 = (JarEntry)object.nextElement();
            String string = NativeLibrary.isValidNativeLibraryName((String)(object2 = ((ZipEntry)object2).getName()), false);
            if (string == null) continue;
            hashMap.put(string, (String)object2);
        }
        return hashMap;
    }

    public static final int extract(File file, Map<String, String> map, JarFile jarFile, String string, boolean bl, boolean bl2, boolean bl3) {
        if (DEBUG) {
            System.err.println("JarUtil: extract: " + jarFile.getName() + " -> " + file + ", extractNativeLibraries " + bl + " (" + string + "), extractClassFiles " + bl2 + ", extractOtherFiles " + bl3);
        }
        int n = 0;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n2;
            boolean bl4;
            boolean bl5;
            Object object = enumeration.nextElement();
            String string2 = ((ZipEntry)object).getName();
            String string3 = NativeLibrary.isValidNativeLibraryName(string2, false);
            boolean bl6 = string3 != null;
            if (bl6) {
                if (!bl) {
                    if (!DEBUG) continue;
                    System.err.println("JarUtil: JarEntry : " + string2 + " native-lib skipped, skip all native libs");
                    continue;
                }
                if (string != null) {
                    String string4;
                    String string5;
                    try {
                        string5 = IOUtil.slashify(string, false, true);
                        string4 = IOUtil.getDirname(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new IOException(uRISyntaxException);
                    }
                    if (!string5.equals(string4)) {
                        if (!DEBUG) continue;
                        System.err.println("JarUtil: JarEntry : " + string2 + " native-lib skipped, not in path: " + string5);
                        continue;
                    }
                }
            }
            if ((bl5 = string2.endsWith(".class")) && !bl2) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string2 + " class-file skipped");
                continue;
            }
            if (!(bl6 || bl5 || bl3)) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string2 + " other-file skipped");
                continue;
            }
            boolean bl7 = string2.endsWith("/");
            boolean bl8 = bl4 = string2.indexOf(47) == -1 && string2.indexOf(File.separatorChar) == -1;
            if (DEBUG) {
                System.err.println("JarUtil: JarEntry : isNativeLib " + bl6 + ", isClassFile " + bl5 + ", isDir " + bl7 + ", isRootEntry " + bl4);
            }
            File file2 = new File(file, string2);
            if (bl7) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR: " + string2 + " -> " + file2);
                }
                file2.mkdirs();
                continue;
            }
            Object object2 = new File(file2.getParent());
            if (!((File)object2).exists()) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR (parent): " + string2 + " -> " + object2);
                }
                ((File)object2).mkdirs();
            }
            object = new BufferedInputStream(jarFile.getInputStream((ZipEntry)object));
            object2 = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                n2 = IOUtil.copyStream2Stream(4096, (InputStream)object, (OutputStream)object2);
            }
            finally {
                ((InputStream)object).close();
                ((OutputStream)object2).close();
            }
            boolean bl9 = false;
            if (n2 > 0) {
                ++n;
                if (bl6 && (bl4 || !map.containsKey(string3))) {
                    map.put(string3, file2.getAbsolutePath());
                    bl9 = true;
                    JarUtil.fixNativeLibAttribs(file2);
                }
            }
            if (!DEBUG) continue;
            System.err.println("JarUtil: EXTRACT[" + n + "]: [" + string3 + " -> ] " + string2 + " -> " + file2 + ": " + n2 + " bytes, addedAsNativeLib: " + bl9);
        }
        return n;
    }

    private static final void fixNativeLibAttribs(File object) {
        block4: {
            if (Platform.OSType.MACOS == Platform.getOSType() || Platform.OSType.IOS == Platform.getOSType()) {
                object = ((File)object).getAbsolutePath();
                try {
                    JarUtil.fixNativeLibAttribs((String)object);
                    if (DEBUG) {
                        System.err.println("JarUtil.fixNativeLibAttribs: " + (String)object + " - OK");
                    }
                    return;
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    System.err.println("JarUtil.fixNativeLibAttribs: " + (String)object + " - " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
                }
            }
        }
    }

    private static native boolean fixNativeLibAttribs(String var0);

    public static final void validateCertificates(Certificate[] certificateArray, JarFile jarFile) {
        if (DEBUG) {
            System.err.println("JarUtil: validateCertificates: " + jarFile.getName());
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Null certificates passed");
        }
        byte[] byArray = new byte[1024];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/")) continue;
            JarUtil.validateCertificate(certificateArray, jarFile, jarEntry, byArray);
        }
    }

    private static final void validateCertificate(Certificate[] certificateArray, JarFile jarFile, JarEntry jarEntry, byte[] objectArray) {
        if (DEBUG) {
            System.err.println("JarUtil: validate JarEntry : " + jarEntry.getName());
        }
        try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
            while (inputStream.read((byte[])objectArray) > 0) {
            }
        }
        Certificate[] certificateArray2 = jarEntry.getCertificates();
        objectArray = certificateArray2;
        if (certificateArray2 == null || objectArray.length == 0) {
            throw new SecurityException("no certificate for " + jarEntry.getName() + " in " + jarFile.getName());
        }
        if (!SecurityUtil.equals(certificateArray, (Certificate[])objectArray)) {
            throw new SecurityException("certificates not equal for " + jarEntry.getName() + " in " + jarFile.getName());
        }
    }

    public static interface Resolver {
        public URL resolve(URL var1);
    }
}

