/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.TaskBase;
import java.io.PrintStream;

public class RunnableTask
extends TaskBase {
    protected final Runnable runnable;

    public static RunnableTask invokeOnCurrentThread(Runnable runnable) {
        runnable = new RunnableTask(runnable, null, false, null);
        ((TaskBase)runnable).run();
        return runnable;
    }

    public static RunnableTask invokeOnNewThread(ThreadGroup object, String object2, boolean bl, Runnable runnable) {
        RunnableTask runnableTask;
        if (!bl) {
            runnableTask = new RunnableTask(runnable, null, true, System.err);
            InterruptSource.Thread thread = InterruptSource.Thread.create((ThreadGroup)object, runnableTask, (String)object2);
            thread.start();
        } else {
            Object object3 = new Object();
            runnableTask = new RunnableTask(runnable, object3, true, null);
            object = InterruptSource.Thread.create((ThreadGroup)object, runnableTask, (String)object2);
            object2 = object3;
            synchronized (object2) {
                ((Thread)object).start();
                while (runnableTask.isInQueue()) {
                    try {
                        object3.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedRuntimeException(interruptedException);
                    }
                    object = runnableTask.getThrowable();
                    if (object == null) continue;
                    throw new JogampRuntimeException((Throwable)object);
                }
            }
        }
        return runnableTask;
    }

    public RunnableTask(Runnable runnable, Object object, boolean bl, PrintStream printStream) {
        super(object, bl, printStream);
        this.runnable = runnable;
    }

    public final Runnable getRunnable() {
        return this.runnable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void run() {
        this.execThread = Thread.currentThread();
        this.runnableException = null;
        this.tStarted = System.currentTimeMillis();
        if (null == this.syncObject) {
            try {
                this.runnable.run();
                return;
            }
            catch (Throwable throwable) {
                this.runnableException = throwable;
                if (null != this.exceptionOut) {
                    this.exceptionOut.println("RunnableTask.run(): " + this.getExceptionOutIntro() + " exception occured on thread " + Thread.currentThread().getName() + ": " + this.toString());
                    this.printSourceTrace();
                    this.runnableException.printStackTrace(this.exceptionOut);
                }
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.tExecuted = System.currentTimeMillis();
                this.isExecuted = true;
            }
        }
        Object object = this.syncObject;
        synchronized (object) {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                this.runnableException = throwable;
                if (null != this.exceptionOut) {
                    this.exceptionOut.println("RunnableTask.run(): " + this.getExceptionOutIntro() + " exception occured on thread " + Thread.currentThread().getName() + ": " + this.toString());
                    this.printSourceTrace();
                    throwable.printStackTrace(this.exceptionOut);
                }
                if (this.catchExceptions) return;
                throw new RuntimeException(this.runnableException);
            }
            finally {
                this.tExecuted = System.currentTimeMillis();
                this.isExecuted = true;
                this.syncObject.notifyAll();
            }
            return;
        }
    }
}

