/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import jogamp.common.Debug;

public class SHASum {
    private static final boolean DEBUG = Debug.debug("SHASum");
    final MessageDigest digest;
    final List<String> origins;
    final List<Pattern> excludes;
    final List<Pattern> includes;

    public static long updateDigest(MessageDigest messageDigest, List<String> list) {
        long l = 0L;
        byte[] byArray = new byte[4096];
        for (int i = 0; i < list.size(); ++i) {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(list.get(i)));){
                int n;
                while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                    messageDigest.update(byArray, 0, n);
                    l += (long)n;
                }
                continue;
            }
        }
        return l;
    }

    public static StringBuilder toHexString(byte[] byArray, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format(null, "%02x", byArray[i]));
        }
        return stringBuilder;
    }

    public static List<String> sort(ArrayList<String> stringArray) {
        stringArray = stringArray.toArray(new String[stringArray.size()]);
        Arrays.sort(stringArray, 0, stringArray.length, null);
        return Arrays.asList(stringArray);
    }

    public SHASum(MessageDigest messageDigest, List<String> list, List<Pattern> list2, List<Pattern> list3) {
        this.digest = messageDigest;
        this.origins = list;
        this.excludes = list2;
        this.includes = list3;
    }

    public final byte[] compute(boolean bl) {
        Object object = SHASum.sort(IOUtil.filesOf(this.origins, this.excludes, this.includes));
        if (bl) {
            for (int i = 0; i < object.size(); ++i) {
                System.err.println(object.get(i));
            }
        }
        long l = SHASum.updateDigest(this.digest, object);
        object = this.digest.digest();
        if (bl) {
            System.err.println("Digested " + l + " bytes, shasum size " + ((Object)object).length + " bytes");
            System.err.println("Digested result: " + SHASum.toHexString((byte[])object, null).toString());
        }
        return object;
    }

    public final List<String> getOrigins() {
        return this.origins;
    }

    public final List<Pattern> getExcludes() {
        return this.excludes;
    }

    public final List<Pattern> getIncludes() {
        return this.includes;
    }

    public static void main(String[] object) {
        Object object2;
        int n;
        boolean bl = false;
        int n2 = 256;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Pattern> arrayList2 = new ArrayList<Pattern>();
        ArrayList<Pattern> arrayList3 = new ArrayList<Pattern>();
        for (n = 0; n < ((String[])object).length; ++n) {
            if (null == object[n]) continue;
            if (object[n].startsWith("--")) {
                if (((String)object[n]).equals("--algorithm")) {
                    n2 = Integer.parseInt((String)object[++n]);
                    continue;
                }
                if (((String)object[n]).equals("--exclude")) {
                    arrayList2.add(Pattern.compile((String)object[++n]));
                    if (!DEBUG) continue;
                    ArrayList<Pattern> arrayList4 = arrayList2;
                    System.err.println("adding exclude: <" + (String)object[n] + "> -> <" + arrayList4.get(arrayList4.size() - 1) + ">");
                    continue;
                }
                if (((String)object[n]).equals("--include")) {
                    arrayList3.add(Pattern.compile((String)object[++n]));
                    if (!DEBUG) continue;
                    ArrayList<Pattern> arrayList5 = arrayList3;
                    System.err.println("adding include: <" + (String)object[n] + "> -> <" + arrayList5.get(arrayList5.size() - 1) + ">");
                    continue;
                }
                if (((String)object[n]).equals("--listfilesonly")) {
                    bl = true;
                    continue;
                }
                System.err.println("Abort, unknown argument: " + (String)object[n]);
                return;
            }
            arrayList.add((String)object[n]);
            if (!DEBUG) continue;
            System.err.println("adding path: <" + (String)object[n] + ">");
        }
        if (bl) {
            object = SHASum.sort(IOUtil.filesOf(arrayList, arrayList2, arrayList3));
            for (n = 0; n < object.size(); ++n) {
                System.out.println((String)object.get(n));
            }
            return;
        }
        object = "SHA-" + n2;
        try {
            object2 = MessageDigest.getInstance((String)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("Abort, implementation for " + (String)object + " not available: " + noSuchAlgorithmException.getMessage());
            return;
        }
        object2 = new SHASum((MessageDigest)object2, arrayList, arrayList2, arrayList3);
        System.out.println(SHASum.toHexString(((SHASum)object2).compute(DEBUG), null).toString());
    }

    public static class TempJarSHASum
    extends SHASum {
        public TempJarSHASum(MessageDigest messageDigest, Class<?> clazz, List<Pattern> list, List<Pattern> list2) {
            super(messageDigest, Arrays.asList(IOUtil.slashify(TempJarCache.getTempFileCache().getTempDir().getAbsolutePath(), false, false)), list, list2);
            Class<?> clazz2 = clazz;
            TempJarCache.addAll(clazz2, JarUtil.getJarFileUri(clazz2.getName(), clazz.getClassLoader()));
        }

        public final String getOrigin() {
            return this.origins.get(0);
        }
    }
}

