/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.Bitfield;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private final Map<IdentityWeakReference<K>, V> backingStore;

    public WeakIdentityHashMap() {
        this.backingStore = new HashMap<IdentityWeakReference<K>, V>();
    }

    public WeakIdentityHashMap(int n, float f) {
        this.backingStore = new HashMap<IdentityWeakReference<K>, V>(n, f);
    }

    public static WeakIdentityHashMap<?, ?> createWithRequiredSize(int n, float f) {
        float[] fArray = new float[]{f};
        n = WeakIdentityHashMap.capacityForRequiredSize(n, fArray);
        return new WeakIdentityHashMap(n, fArray[0]);
    }

    public static int capacityForRequiredSize(int n, float[] fArray) {
        if (n >= 0x40000000) {
            return Integer.MAX_VALUE;
        }
        float f = fArray[0];
        int n2 = (int)((float)n / f + 1.0f);
        if (!Bitfield.Util.isPowerOf2(n2) || 0.86f <= f) {
            return n2;
        }
        while (Bitfield.Util.isPowerOf2(n2 = (int)((float)n / (f += 0.01f) + 1.0f)) && 0.86f > f) {
        }
        fArray[0] = f;
        return n2;
    }

    @Override
    public void clear() {
        this.backingStore.clear();
        this.reap();
    }

    @Override
    public boolean containsKey(Object object) {
        this.reap();
        return this.backingStore.containsKey(new IdentityWeakReference<Object>(object, (ReferenceQueue<Object>)this.queue));
    }

    @Override
    public boolean containsValue(Object object) {
        this.reap();
        return this.backingStore.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.reap();
        HashSet<1> hashSet = new HashSet<1>();
        for (Map.Entry<IdentityWeakReference<K>, V> entry : this.backingStore.entrySet()) {
            final Object t = entry.getKey().get();
            if (t == null) continue;
            final V v = entry.getValue();
            Map.Entry entry2 = new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return t;
                }

                @Override
                public V getValue() {
                    return v;
                }

                @Override
                public V setValue(V v2) {
                    throw new UnsupportedOperationException();
                }
            };
            hashSet.add(entry2);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Set<K> keySet() {
        this.reap();
        HashSet<IdentityWeakReference<K>> hashSet = new HashSet<IdentityWeakReference<K>>();
        for (IdentityWeakReference<Object> identityWeakReference : this.backingStore.keySet()) {
            if ((identityWeakReference = identityWeakReference.get()) == null) continue;
            hashSet.add(identityWeakReference);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WeakIdentityHashMap)) {
            return false;
        }
        return this.backingStore.equals(((WeakIdentityHashMap)object).backingStore);
    }

    @Override
    public V get(Object object) {
        this.reap();
        return this.backingStore.get(new IdentityWeakReference<Object>(object, (ReferenceQueue<Object>)this.queue));
    }

    @Override
    public V put(K k, V v) {
        this.reap();
        return this.backingStore.put(new IdentityWeakReference<K>(k, this.queue), v);
    }

    @Override
    public int hashCode() {
        this.reap();
        return this.backingStore.hashCode();
    }

    @Override
    public boolean isEmpty() {
        this.reap();
        return this.backingStore.isEmpty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> object) {
        int n = object.size();
        if (n > 0) {
            Object object2 = new float[]{0.75f};
            n = WeakIdentityHashMap.capacityForRequiredSize(n, (float[])object2);
            HashMap hashMap = new HashMap(n, object2[0]);
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                object2 = (Map.Entry)object.next();
                hashMap.put(new IdentityWeakReference(object2.getKey(), this.queue), object2.getValue());
            }
            this.backingStore.putAll(hashMap);
            this.reap();
        }
    }

    @Override
    public V remove(Object object) {
        this.reap();
        return this.backingStore.remove(new IdentityWeakReference<Object>(object, (ReferenceQueue<Object>)this.queue));
    }

    @Override
    public int size() {
        this.reap();
        return this.backingStore.size();
    }

    @Override
    public Collection<V> values() {
        this.reap();
        return this.backingStore.values();
    }

    private synchronized void reap() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            reference = reference;
            this.backingStore.remove(reference);
            reference = this.queue.poll();
        }
    }

    private static class IdentityWeakReference<K>
    extends WeakReference<K> {
        final int hash;

        IdentityWeakReference(K k, ReferenceQueue<K> referenceQueue) {
            super(k, referenceQueue);
            this.hash = System.identityHashCode(k);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IdentityWeakReference)) {
                return false;
            }
            object = (IdentityWeakReference)object;
            return this.get() == ((Reference)object).get();
        }
    }
}

