/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.e.a.a;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.SubscribeListener;

public class RosterUtil {
    public static void waitUntilOtherEntityIsSubscribed(Roster roster, a a2, long l) {
        Date date = new Date(System.currentTimeMillis() + l);
        RosterUtil.waitUntilOtherEntityIsSubscribed(roster, a2, date);
    }

    public static void waitUntilOtherEntityIsSubscribed(Roster roster, a a2, Date date) {
        final ReentrantLock reentrantLock = new ReentrantLock();
        final Condition condition = reentrantLock.newCondition();
        AbstractRosterListener abstractRosterListener = new AbstractRosterListener(){

            private void signal() {
                reentrantLock.lock();
                try {
                    condition.signal();
                    return;
                }
                finally {
                    reentrantLock.unlock();
                }
            }

            @Override
            public void entriesAdded(Collection<i> collection) {
                this.signal();
            }

            @Override
            public void entriesUpdated(Collection<i> collection) {
                this.signal();
            }
        };
        roster.addRosterListener(abstractRosterListener);
        boolean bl = true;
        reentrantLock.lock();
        try {
            while (!roster.isSubscribedToMyPresence((i)a2)) {
                if (!bl) {
                    throw new TimeoutException();
                }
                bl = condition.awaitUntil(date);
            }
            return;
        }
        finally {
            reentrantLock.unlock();
            roster.removeRosterListener(abstractRosterListener);
        }
    }

    public static void preApproveSubscriptionIfRequiredAndPossible(Roster roster, a a2) {
        if (!roster.isSubscriptionPreApprovalSupported()) {
            return;
        }
        RosterEntry rosterEntry = roster.getEntry(a2);
        if (rosterEntry == null || !rosterEntry.canSeeMyPresence() && !rosterEntry.isApproved()) {
            try {
                roster.preApprove(a2);
                return;
            }
            catch (SmackException.FeatureNotSupportedException featureNotSupportedException) {
                throw new AssertionError((Object)featureNotSupportedException);
            }
        }
    }

    public static void askForSubscriptionIfRequired(Roster roster, a a2) {
        RosterEntry rosterEntry = roster.getEntry(a2);
        if (rosterEntry == null || !rosterEntry.canSeeHisPresence() && !rosterEntry.isSubscriptionPending()) {
            roster.sendSubscriptionRequest(a2);
        }
    }

    public static void ensureNotSubscribedToEachOther(XMPPConnection xMPPConnection, XMPPConnection xMPPConnection2) {
        Roster roster = Roster.getInstanceFor(xMPPConnection);
        xMPPConnection = xMPPConnection.getUser().n();
        Roster roster2 = Roster.getInstanceFor(xMPPConnection2);
        xMPPConnection2 = xMPPConnection2.getUser().n();
        RosterUtil.ensureNotSubscribed(roster, (a)xMPPConnection2);
        RosterUtil.ensureNotSubscribed(roster2, (a)xMPPConnection);
    }

    public static void ensureNotSubscribed(Roster manager, a a2) {
        if ((manager = manager.getEntry(a2)) != null && manager.canSeeMyPresence()) {
            manager.cancelSubscription();
        }
    }

    public static void ensureSubscribed(XMPPConnection xMPPConnection, XMPPConnection xMPPConnection2, long l) {
        RosterUtil.ensureSubscribedTo(xMPPConnection, xMPPConnection2, l);
        RosterUtil.ensureSubscribedTo(xMPPConnection2, xMPPConnection, l);
    }

    public static void ensureSubscribedTo(XMPPConnection xMPPConnection, XMPPConnection xMPPConnection2, long l) {
        Date date = new Date(System.currentTimeMillis() + l);
        RosterUtil.ensureSubscribedTo(xMPPConnection, xMPPConnection2, date);
    }

    public static void ensureSubscribedTo(XMPPConnection xMPPConnection, XMPPConnection object, Date date) {
        a a2;
        Roster roster = Roster.getInstanceFor(xMPPConnection);
        if (roster.iAmSubscribedTo((i)(a2 = object.getUser().n()))) {
            return;
        }
        xMPPConnection = xMPPConnection.getUser().n();
        SubscribeListener subscribeListener = new SubscribeListener((a)xMPPConnection){
            final /* synthetic */ a val$jidOne;
            {
                this.val$jidOne = a2;
            }

            @Override
            public SubscribeListener.SubscribeAnswer processSubscribe(i i2, Presence presence) {
                if (i2.a((CharSequence)this.val$jidOne)) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return null;
            }
        };
        object = Roster.getInstanceFor((XMPPConnection)object);
        ((Roster)((Object)object)).addSubscribeListener(subscribeListener);
        try {
            roster.sendSubscriptionRequest(a2);
            RosterUtil.waitUntilOtherEntityIsSubscribed((Roster)((Object)object), (a)xMPPConnection, date);
            return;
        }
        finally {
            ((Roster)((Object)object)).removeSubscribeListener(subscribeListener);
        }
    }
}

