/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.ALVersion;
import java.util.jar.Manifest;

public class JoalVersion
extends JogampVersion {
    protected static volatile JoalVersion jogampCommonVersionInfo;

    protected JoalVersion(String string, Manifest manifest) {
        super(string, manifest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JoalVersion getInstance() {
        if (jogampCommonVersionInfo != null) return jogampCommonVersionInfo;
        Class<JoalVersion> clazz = JoalVersion.class;
        synchronized (JoalVersion.class) {
            if (jogampCommonVersionInfo != null) return jogampCommonVersionInfo;
            Manifest manifest = VersionUtil.getManifest((ClassLoader)JoalVersion.class.getClassLoader(), (String)"com.jogamp.openal");
            jogampCommonVersionInfo = new JoalVersion("com.jogamp.openal", manifest);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jogampCommonVersionInfo;
        }
    }

    public StringBuilder getBriefOSALBuildInfo(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("OS: ").append(Platform.getOSName()).append(", version ").append(Platform.getOSVersion()).append(", arch ").append(Platform.getArchName());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("JOAL GIT sha1 ").append(this.getImplementationCommit());
        stringBuilder.append(Platform.getNewline());
        return stringBuilder;
    }

    public StringBuilder toString(ALC aLC, StringBuilder stringBuilder) {
        stringBuilder = super.toString(stringBuilder).append(Platform.getNewline());
        JoalVersion.getALStrings(aLC, stringBuilder);
        return stringBuilder;
    }

    public String toString(ALC aLC) {
        return this.toString(aLC, null).toString();
    }

    public static StringBuilder getALStrings(ALC aLC, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (aLC == null) {
            stringBuilder.append("ALC null");
            return stringBuilder;
        }
        ALCdevice aLCdevice = aLC.alcOpenDevice(null);
        ALCcontext aLCcontext = aLC.alcCreateContext(aLCdevice, null);
        aLC.alcMakeContextCurrent(aLCcontext);
        Object object = ALFactory.getAL();
        ALVersion aLVersion = new ALVersion((AL)object);
        aLVersion.toString(true, stringBuilder);
        stringBuilder.append("AL_EXTENSIONS  ").append(object.alGetString(45060));
        stringBuilder.append(Platform.getNewline());
        object = new int[]{0, 0};
        aLC.alcGetIntegerv(aLCdevice, 4096, 1, (int[])object, 0);
        aLC.alcGetIntegerv(aLCdevice, 4097, 1, (int[])object, 1);
        stringBuilder.append("ALC_VERSION     ").append((int)object[0]).append(".").append((int)object[1]);
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("ALC_DEF_OUTPUT  ").append(aLC.alcGetString(aLCdevice, 4100));
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("ALC_DEF_CAPTURE ").append(aLC.alcGetString(aLCdevice, 785));
        stringBuilder.append(Platform.getNewline());
        aLC.alcMakeContextCurrent(null);
        aLC.alcDestroyContext(aLCcontext);
        aLC.alcCloseDevice(aLCdevice);
        JoalVersion.devicesToString(stringBuilder, aLC);
        return stringBuilder;
    }

    private static boolean checkALCError(ALC aLC, ALCdevice aLCdevice, String string) {
        int n = aLC.alcGetError(aLCdevice);
        if (n != 0) {
            System.err.printf("ALC Error 0x%x occurred: '%s' while '%s'%n", n, aLC.alcGetString(aLCdevice, n), string);
            return true;
        }
        return false;
    }

    public static void deviceToString(StringBuilder stringBuilder, ALC aLC, String string, boolean bl, String string2, String string3) {
        if (bl) {
            bl = string.equals(string3);
            stringBuilder.append("    " + string + ", input, default " + bl + System.lineSeparator());
            return;
        }
        bl = string.equals(string2);
        string2 = bl ? "default " : "";
        int[] nArray = new int[]{0};
        ALCdevice aLCdevice = aLC.alcOpenDevice(string);
        if (aLCdevice == null) {
            System.err.println("Error: Failed to open " + string2 + "output device " + string);
            return;
        }
        ALCcontext aLCcontext = aLC.alcCreateContext(aLCdevice, null);
        if (aLCcontext == null) {
            System.err.println("Error: Failed to create context for " + string2 + "output device " + string);
            aLC.alcCloseDevice(aLCdevice);
            return;
        }
        if (!aLC.alcMakeContextCurrent(aLCcontext)) {
            System.err.println("Error: Failed to make context current for " + string2 + "output device " + string);
            JoalVersion.checkALCError(aLC, aLCdevice, "alcMakeContextCurrent");
            aLC.alcDestroyContext(aLCcontext);
            aLC.alcCloseDevice(aLCdevice);
            return;
        }
        nArray[0] = 0;
        aLC.alcGetIntegerv(aLCdevice, 4103, 1, nArray, 0);
        int n = JoalVersion.checkALCError(aLC, aLCdevice, "read ALC_FREQUENCY") ? -1 : nArray[0];
        nArray[0] = 0;
        aLC.alcGetIntegerv(aLCdevice, 4104, 1, nArray, 0);
        int n2 = JoalVersion.checkALCError(aLC, aLCdevice, "read ALC_REFRESH") ? -1 : nArray[0];
        nArray[0] = 0;
        aLC.alcGetIntegerv(aLCdevice, 4112, 1, nArray, 0);
        int n3 = JoalVersion.checkALCError(aLC, aLCdevice, "read ALC_MONO_SOURCES") ? -1 : nArray[0];
        nArray[0] = 0;
        aLC.alcGetIntegerv(aLCdevice, 4113, 1, nArray, 0);
        int n4 = JoalVersion.checkALCError(aLC, aLCdevice, "read ALC_STEREO_SOURCES") ? -1 : nArray[0];
        stringBuilder.append("    " + string + ", output" + ", default " + bl + ", mixer[freq " + n + ", refresh " + n2 + " (min latency " + 1000.0f / (float)n2 + " ms)], sources[mono " + n3 + ", stereo " + n4 + "]" + System.lineSeparator());
        aLC.alcMakeContextCurrent(null);
        aLC.alcDestroyContext(aLCcontext);
        aLC.alcCloseDevice(aLCdevice);
    }

    public static void devicesToString(StringBuilder stringBuilder, ALC aLC) {
        String string = aLC.alcGetString(null, 4100);
        String string2 = aLC.alcGetString(null, 785);
        stringBuilder.append("Output devices:" + System.lineSeparator());
        String[] stringArray = aLC.alcGetDeviceSpecifiers();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                JoalVersion.deviceToString(stringBuilder, aLC, string3, false, string, string2);
            }
        }
        stringBuilder.append("Capture devices:" + System.lineSeparator());
        stringArray = aLC.alcGetCaptureDeviceSpecifiers();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                JoalVersion.deviceToString(stringBuilder, aLC, string3, true, string, string2);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(JoalVersion.getInstance().toString(ALFactory.getALC()));
    }
}

