/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.HashFunction;
import io.ktor.util.HashFunctionKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0018R\u0016\u0010\u001d\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0018R\u0016\u0010\u001e\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0018R\u0016\u0010\u001f\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0018R\u0016\u0010 \u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u0018\u00a8\u0006!"}, d2={"Lio/ktor/util/Sha1;", "Lio/ktor/util/HashFunction;", "<init>", "()V", "", "input", "", "offset", "length", "", "update", "([BII)V", "pos", "processChunk", "([BI)V", "digest", "()[B", "reset", "", "messageLength", "J", "unprocessed", "[B", "unprocessedLimit", "I", "", "words", "[I", "h0", "h1", "h2", "h3", "h4", "ktor-utils"})
public final class Sha1
implements HashFunction {
    private long messageLength;
    private final byte[] unprocessed = new byte[64];
    private int unprocessedLimit;
    private final int[] words = new int[80];
    private int h0 = 1732584193;
    private int h1 = -271733879;
    private int h2 = -1732584194;
    private int h3 = 271733878;
    private int h4 = -1009589776;

    @Override
    public final void update(byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        this.messageLength += (long)n2;
        int n3 = n;
        int n4 = n + n2;
        byte[] byArray2 = this.unprocessed;
        int n5 = this.unprocessedLimit;
        if (n5 > 0) {
            if (n5 + n2 < 64) {
                ArraysKt.copyInto((byte[])byArray, (byte[])byArray2, (int)n5, (int)n, (int)n4);
                this.unprocessedLimit = n5 + n2;
                return;
            }
            n2 = 64 - n5;
            int n6 = n;
            ArraysKt.copyInto((byte[])byArray, (byte[])byArray2, (int)n5, (int)n6, (int)(n6 + n2));
            this.processChunk(byArray2, 0);
            this.unprocessedLimit = 0;
            n3 = n + n2;
        }
        while (n3 < n4) {
            n2 = n3 + 64;
            if (n2 > n4) {
                ArraysKt.copyInto((byte[])byArray, (byte[])byArray2, (int)0, (int)n3, (int)n4);
                this.unprocessedLimit = n4 - n3;
                return;
            }
            this.processChunk(byArray, n3);
            n3 = n2;
        }
    }

    private final void processChunk(byte[] byArray, int n) {
        int n2;
        int[] nArray = this.words;
        for (n2 = 0; n2 < 16; ++n2) {
            nArray[n2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        }
        for (n2 = 16; n2 < 80; ++n2) {
            nArray[n2] = HashFunctionKt.access$leftRotate(nArray[n2 - 3] ^ nArray[n2 - 8] ^ nArray[n2 - 14] ^ nArray[n2 - 16], 1);
        }
        n2 = this.h0;
        int n3 = this.h1;
        n = this.h2;
        int n4 = this.h3;
        int n5 = this.h4;
        for (int k = 0; k < 80; ++k) {
            int n6;
            int n7;
            if (k < 20) {
                n7 = n4 ^ n3 & (n ^ n4);
                n6 = HashFunctionKt.access$leftRotate(n2, 5) + n7 + n5 + 1518500249 + nArray[k];
            } else if (k < 40) {
                n7 = n3 ^ n ^ n4;
                n6 = HashFunctionKt.access$leftRotate(n2, 5) + n7 + n5 + 1859775393 + nArray[k];
            } else if (k < 60) {
                n7 = n3 & n | n3 & n4 | n & n4;
                n6 = HashFunctionKt.access$leftRotate(n2, 5) + n7 + n5 + -1894007588 + nArray[k];
            } else {
                n7 = n3 ^ n ^ n4;
                n6 = HashFunctionKt.access$leftRotate(n2, 5) + n7 + n5 + -899497514 + nArray[k];
            }
            n7 = n6;
            n5 = n4;
            n4 = n;
            n = HashFunctionKt.access$leftRotate(n3, 30);
            n3 = n2;
            n2 = n7;
        }
        this.h0 += n2;
        this.h1 += n3;
        this.h2 += n;
        this.h3 += n4;
        this.h4 += n5;
    }

    @Override
    public final byte[] digest() {
        byte[] byArray = this.unprocessed;
        int n = this.unprocessedLimit;
        long l = this.messageLength << 3;
        byArray[n++] = -128;
        if (n > 56) {
            ArraysKt.fill((byte[])byArray, (byte)0, (int)n, (int)64);
            this.processChunk(byArray, 0);
            ArraysKt.fill((byte[])byArray, (byte)0, (int)0, (int)n);
        } else {
            ArraysKt.fill((byte[])byArray, (byte)0, (int)n, (int)56);
        }
        byArray[56] = (byte)(l >>> 56);
        byArray[57] = (byte)(l >>> 48);
        byArray[58] = (byte)(l >>> 40);
        byArray[59] = (byte)(l >>> 32);
        byArray[60] = (byte)(l >>> 24);
        byArray[61] = (byte)(l >>> 16);
        byArray[62] = (byte)(l >>> 8);
        byArray[63] = (byte)l;
        this.processChunk(byArray, 0);
        int n2 = this.h0;
        n = this.h1;
        int n3 = this.h2;
        int n4 = this.h3;
        int n5 = this.h4;
        this.reset();
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = byArray2;
        byArray2[0] = (byte)(n2 >> 24);
        byArray3[1] = (byte)(n2 >> 16);
        byArray3[2] = (byte)(n2 >> 8);
        byArray3[3] = (byte)n2;
        byArray3[4] = (byte)(n >> 24);
        byArray3[5] = (byte)(n >> 16);
        byArray3[6] = (byte)(n >> 8);
        byArray3[7] = (byte)n;
        byArray3[8] = (byte)(n3 >> 24);
        byArray3[9] = (byte)(n3 >> 16);
        byArray3[10] = (byte)(n3 >> 8);
        byArray3[11] = (byte)n3;
        byArray3[12] = (byte)(n4 >> 24);
        byArray3[13] = (byte)(n4 >> 16);
        byArray3[14] = (byte)(n4 >> 8);
        byArray3[15] = (byte)n4;
        byArray3[16] = (byte)(n5 >> 24);
        byArray3[17] = (byte)(n5 >> 16);
        byArray3[18] = (byte)(n5 >> 8);
        byArray3[19] = (byte)n5;
        return byArray3;
    }

    private final void reset() {
        this.messageLength = 0L;
        ArraysKt.fill$default((byte[])this.unprocessed, (byte)0, (int)0, (int)0, (int)6, null);
        this.unprocessedLimit = 0;
        ArraysKt.fill$default((int[])this.words, (int)0, (int)0, (int)0, (int)6, null);
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }
}

