/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.converters;

import io.ktor.util.converters.DataConversionException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u001a%\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0001\u001a\u00020\u00002\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a%\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0001\u001a\u00020\u00002\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006\u001a\u001f\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\b2\u0006\u0010\u0001\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"", "value", "Lkotlin/reflect/KClass;", "klass", "", "platformDefaultFromValues", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "convertSimpleTypes", "", "platformDefaultToValues", "(Ljava/lang/Object;)Ljava/util/List;", "ktor-utils"})
public final class ConversionServiceJvmKt {
    public static final Object platformDefaultFromValues(String string, KClass<?> kClass) {
        block6: {
            T[] TArray;
            block8: {
                block7: {
                    T[] TArray2;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"");
                        Intrinsics.checkNotNullParameter(kClass, (String)"");
                        T[] TArray3 = ConversionServiceJvmKt.convertSimpleTypes(string, kClass);
                        if (TArray3 != null) {
                            return TArray3;
                        }
                        if (!JvmClassMappingKt.getJavaClass(kClass).isEnum()) break block6;
                        TArray = JvmClassMappingKt.getJavaClass(kClass).getEnumConstants();
                        if (TArray == null) break block7;
                        TArray3 = TArray;
                        int n = TArray3.length;
                        for (int k = 0; k < n; ++k) {
                            Object t2;
                            Object t3 = t2 = TArray3[k];
                            Intrinsics.checkNotNull(t2);
                            if (!Intrinsics.areEqual((Object)((Enum)t3).name(), (Object)string)) continue;
                            TArray2 = (T[])t2;
                            break block5;
                        }
                        TArray2 = TArray = null;
                    }
                    if (TArray2 != null) break block8;
                }
                throw new DataConversionException("Value " + string + " is not a enum member name of " + kClass);
            }
            return TArray;
        }
        return null;
    }

    private static final Object convertSimpleTypes(String string, KClass<?> kClass) {
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.class))) {
            return Integer.parseInt(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.class))) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.class))) {
            return Double.parseDouble(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.class))) {
            return Long.parseLong(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.class))) {
            return Short.parseShort(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.class))) {
            return Boolean.parseBoolean(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            return string;
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.class))) {
            return Character.valueOf(string.charAt(0));
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            return new BigDecimal(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            return new BigInteger(string);
        }
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UUID.class))) {
            return UUID.fromString(string);
        }
        return null;
    }

    public static final List<String> platformDefaultToValues(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (object instanceof Enum) {
            return CollectionsKt.listOf((Object)((Enum)object).name());
        }
        Object object2 = object;
        if (object2 instanceof Integer) {
            return CollectionsKt.listOf((Object)((Integer)object).toString());
        }
        if (object2 instanceof Float) {
            return CollectionsKt.listOf((Object)((Float)object).toString());
        }
        if (object2 instanceof Double) {
            return CollectionsKt.listOf((Object)((Double)object).toString());
        }
        if (object2 instanceof Long) {
            return CollectionsKt.listOf((Object)((Long)object).toString());
        }
        if (object2 instanceof Boolean) {
            return CollectionsKt.listOf((Object)((Boolean)object).toString());
        }
        if (object2 instanceof Short) {
            return CollectionsKt.listOf((Object)((Short)object).toString());
        }
        if (object2 instanceof String) {
            return CollectionsKt.listOf((Object)((String)object).toString());
        }
        if (object2 instanceof Character) {
            return CollectionsKt.listOf((Object)((Character)object).toString());
        }
        if (object2 instanceof BigDecimal) {
            return CollectionsKt.listOf((Object)((BigDecimal)object).toString());
        }
        if (object2 instanceof BigInteger) {
            return CollectionsKt.listOf((Object)((BigInteger)object).toString());
        }
        if (object2 instanceof UUID) {
            return CollectionsKt.listOf((Object)((UUID)object).toString());
        }
        return null;
    }
}

