/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.TransferParametersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003JO\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006("}, d2={"Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "", "gamma", "", "a", "b", "c", "d", "e", "f", "<init>", "(DDDDDDD)V", "getGamma", "()D", "getA", "getB", "getC", "getD", "getE", "getF", "isHLGish", "", "isHLGish$ui_graphics", "()Z", "isPQish", "isPQish$ui_graphics", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "", "toString", "", "ui-graphics"})
public final class TransferParameters {
    private final double gamma;
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double e;
    private final double f;

    public TransferParameters(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.gamma = d2;
        this.a = d3;
        this.b = d4;
        this.c = d5;
        this.d = d6;
        this.e = d7;
        this.f = d8;
        if (Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isNaN(this.c) || Double.isNaN(this.d) || Double.isNaN(this.e) || Double.isNaN(this.f) || Double.isNaN(this.gamma)) {
            throw new IllegalArgumentException("Parameters cannot be NaN");
        }
        if (!TransferParametersKt.access$isSpecialG(this.gamma)) {
            if (!(this.d >= 0.0) || !(this.d <= 1.0)) {
                throw new IllegalArgumentException("Parameter d must be in the range [0..1], was " + this.d);
            }
            if (this.d == 0.0 && (this.a == 0.0 || this.gamma == 0.0)) {
                throw new IllegalArgumentException("Parameter a or g is zero, the transfer function is constant");
            }
            if (this.d >= 1.0 && this.c == 0.0) {
                throw new IllegalArgumentException("Parameter c is zero, the transfer function is constant");
            }
            if ((this.a == 0.0 || this.gamma == 0.0) && this.c == 0.0) {
                throw new IllegalArgumentException("Parameter a or g is zero, and c is zero, the transfer function is constant");
            }
            if (this.c < 0.0) {
                throw new IllegalArgumentException("The transfer function must be increasing");
            }
            if (this.a < 0.0 || this.gamma < 0.0) {
                throw new IllegalArgumentException("The transfer function must be positive or increasing");
            }
        }
    }

    public /* synthetic */ TransferParameters(double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            d7 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d8 = 0.0;
        }
        this(d2, d3, d4, d5, d6, d7, d8);
    }

    public final double getGamma() {
        return this.gamma;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getC() {
        return this.c;
    }

    public final double getD() {
        return this.d;
    }

    public final double getE() {
        return this.e;
    }

    public final double getF() {
        return this.f;
    }

    public final boolean isHLGish$ui_graphics() {
        return this.gamma == -3.0;
    }

    public final boolean isPQish$ui_graphics() {
        return this.gamma == -2.0;
    }

    public final double component1() {
        return this.gamma;
    }

    public final double component2() {
        return this.a;
    }

    public final double component3() {
        return this.b;
    }

    public final double component4() {
        return this.c;
    }

    public final double component5() {
        return this.d;
    }

    public final double component6() {
        return this.e;
    }

    public final double component7() {
        return this.f;
    }

    public final TransferParameters copy(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return new TransferParameters(d2, d3, d4, d5, d6, d7, d8);
    }

    public static /* synthetic */ TransferParameters copy$default(TransferParameters transferParameters, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, Object object) {
        if ((n & 1) != 0) {
            d2 = transferParameters.gamma;
        }
        if ((n & 2) != 0) {
            d3 = transferParameters.a;
        }
        if ((n & 4) != 0) {
            d4 = transferParameters.b;
        }
        if ((n & 8) != 0) {
            d5 = transferParameters.c;
        }
        if ((n & 0x10) != 0) {
            d6 = transferParameters.d;
        }
        if ((n & 0x20) != 0) {
            d7 = transferParameters.e;
        }
        if ((n & 0x40) != 0) {
            d8 = transferParameters.f;
        }
        return transferParameters.copy(d2, d3, d4, d5, d6, d7, d8);
    }

    public final String toString() {
        return "TransferParameters(gamma=" + this.gamma + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", e=" + this.e + ", f=" + this.f + ")";
    }

    public final int hashCode() {
        int n = Double.hashCode(this.gamma);
        n = n * 31 + Double.hashCode(this.a);
        n = n * 31 + Double.hashCode(this.b);
        n = n * 31 + Double.hashCode(this.c);
        n = n * 31 + Double.hashCode(this.d);
        n = n * 31 + Double.hashCode(this.e);
        n = n * 31 + Double.hashCode(this.f);
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TransferParameters)) {
            return false;
        }
        object = (TransferParameters)object;
        if (Double.compare(this.gamma, ((TransferParameters)object).gamma) != 0) {
            return false;
        }
        if (Double.compare(this.a, ((TransferParameters)object).a) != 0) {
            return false;
        }
        if (Double.compare(this.b, ((TransferParameters)object).b) != 0) {
            return false;
        }
        if (Double.compare(this.c, ((TransferParameters)object).c) != 0) {
            return false;
        }
        if (Double.compare(this.d, ((TransferParameters)object).d) != 0) {
            return false;
        }
        if (Double.compare(this.e, ((TransferParameters)object).e) != 0) {
            return false;
        }
        return Double.compare(this.f, ((TransferParameters)object).f) == 0;
    }
}

