/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001aT\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0014\u001a-\u0010\u0015\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001aH\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0019\u001a6\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"closeStatementsAndConnection", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "handleSQLException", "cause", "Ljava/sql/SQLException;", "attempts", "", "inTopLevelTransaction", "T", "transactionIsolation", "readOnly", "", "db", "Lorg/jetbrains/exposed/sql/Database;", "outerTransaction", "statement", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(IZLorg/jetbrains/exposed/sql/Database;Lorg/jetbrains/exposed/sql/Transaction;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "keepAndRestoreTransactionRefAfterRun", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(IZLorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exposed-core"})
public final class ThreadLocalTransactionManagerKt {
    public static final <T> T transaction(Database database, Function1<? super Transaction, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return ThreadLocalTransactionManagerKt.transaction(TransactionApiKt.getTransactionManager(database).getDefaultIsolationLevel(), TransactionApiKt.getTransactionManager(database).getDefaultReadOnly(), database, function1);
    }

    public static /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(database, function1);
    }

    public static final <T> T transaction(int n, boolean bl, Database database, Function1<? super Transaction, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, (Function0)new Function0<T>(database, n, bl, function1){
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ boolean $readOnly;
            final /* synthetic */ Function1<Transaction, T> $statement;
            {
                this.$db = database;
                this.$transactionIsolation = n;
                this.$readOnly = bl;
                this.$statement = function1;
                super(0);
            }

            public final T invoke() {
                Object object;
                block17: {
                    block16: {
                        Object object2 = TransactionManager.Companion.currentOrNull();
                        if (object2 != null && (this.$db == null || Intrinsics.areEqual((Object)((Transaction)object2).getDb(), (Object)this.$db))) {
                            Object object3;
                            TransactionManager transactionManager = TransactionApiKt.getTransactionManager(((Transaction)object2).getDb());
                            Transaction transaction2 = transactionManager.newTransaction(this.$transactionIsolation, this.$readOnly, (Transaction)object2);
                            try {
                                object3 = this.$statement.invoke((Object)transaction2);
                                if (((Transaction)object2).getDb().getUseNestedTransactions()) {
                                    transaction2.commit();
                                }
                            }
                            finally {
                                TransactionManager.Companion.resetCurrent(transactionManager);
                            }
                            return (T)object3;
                        }
                        Database database = this.$db;
                        Object object4 = database != null ? TransactionApiKt.getTransactionManager(database) : null;
                        object = object4;
                        if (object4 == null || (object = object.currentOrNull()) == null) break block16;
                        Object object5 = object;
                        Function1<Transaction, T> function1 = this.$statement;
                        Database database2 = this.$db;
                        Transaction transaction3 = object2;
                        object2 = TransactionApiKt.getTransactionManager(transaction3 != null ? transaction3.getDb() : null);
                        try {
                            TransactionManager.Companion.resetCurrent((TransactionManager)object4);
                            object4 = function1.invoke(object5);
                            if (database2.getUseNestedTransactions()) {
                                ((Transaction)object5).commit();
                            }
                        }
                        finally {
                            TransactionManager.Companion.resetCurrent((TransactionManager)object2);
                        }
                        object = object4;
                        if (object != null) break block17;
                    }
                    object = ThreadLocalTransactionManagerKt.inTopLevelTransaction(this.$transactionIsolation, this.$readOnly, this.$db, null, this.$statement);
                }
                return (T)object;
            }
        });
    }

    public static /* synthetic */ Object transaction$default(int n, boolean bl, Database database, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(n, bl, database, function1);
    }

    public static final <T> T inTopLevelTransaction(int n, boolean bl, Database database, Transaction transaction2, Function1<? super Transaction, ? extends T> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, (Function0)new Function0<T>(transaction2, database, n, bl, function1){
            final /* synthetic */ Transaction $outerTransaction;
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ boolean $readOnly;
            final /* synthetic */ Function1<Transaction, T> $statement;
            {
                this.$outerTransaction = transaction2;
                this.$db = database;
                this.$transactionIsolation = n;
                this.$readOnly = bl;
                this.$statement = function1;
                super(0);
            }

            public final T invoke() {
                return (T)ThreadLocalTransactionManagerKt.access$inTopLevelTransaction$run(this.$outerTransaction, this.$db, this.$transactionIsolation, this.$readOnly, this.$statement);
            }
        });
    }

    public static /* synthetic */ Object inTopLevelTransaction$default(int n, boolean bl, Database database, Transaction transaction2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        if ((n2 & 8) != 0) {
            transaction2 = null;
        }
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction(n, bl, database, transaction2, function1);
    }

    private static final <T> T keepAndRestoreTransactionRefAfterRun(Database object, Function0<? extends T> object2) {
        object = TransactionApiKt.getTransactionManager((Database)object);
        Transaction transaction2 = object.currentOrNull();
        try {
            object2 = object2.invoke();
        }
        finally {
            object.bindTransactionToThread(transaction2);
        }
        return (T)object2;
    }

    static /* synthetic */ Object keepAndRestoreTransactionRefAfterRun$default(Database database, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, function0);
    }

    public static final void handleSQLException(SQLException sQLException, Transaction transaction2, int n) {
        Intrinsics.checkNotNullParameter((Object)sQLException, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        Object object = sQLException instanceof ExposedSQLException ? (ExposedSQLException)sQLException : null;
        Object object2 = object;
        if (object == null || (object2 = ((ExposedSQLException)object2).causedByQueries()) == null || (object2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)";\n", null, null, (int)0, null, null, (int)62, null)) == null) {
            object2 = String.valueOf(transaction2.getCurrentStatement());
        }
        Object object3 = object2;
        String string = "Transaction attempt #" + n + " failed: " + sQLException.getMessage() + ". Statement(s): " + (String)object3;
        Object object4 = object;
        if (object4 != null && (object4 = ((ExposedSQLException)object4).getContexts()) != null) {
            object = (Iterable)object4;
            object = object.iterator();
            while (object.hasNext()) {
                object3 = object.next();
                object3 = (StatementContext)object3;
                Iterator iterator2 = transaction2.getInterceptors$exposed_core();
                Object object5 = new ArrayList();
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!(e instanceof SqlLogger)) continue;
                    object5.add(e);
                }
                iterator2 = (List)object5;
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    object5 = iterator2.next();
                    object5 = (SqlLogger)object5;
                    object5.log((StatementContext)object3, transaction2);
                }
            }
        }
        SQLLogKt.getExposedLogger().warn(string, (Throwable)sQLException);
        TransactionApiKt.rollbackLoggingException(transaction2, (Function1<? super Exception, Unit>)((Function1)handleSQLException.2.INSTANCE));
    }

    public static final void closeStatementsAndConnection(Transaction object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        PreparedStatementApi preparedStatementApi = ((Transaction)object).getCurrentStatement();
        try {
            PreparedStatementApi preparedStatementApi2 = preparedStatementApi;
            if (preparedStatementApi2 != null) {
                object2 = preparedStatementApi2;
                preparedStatementApi2.closeIfPossible();
                ((Transaction)object).setCurrentStatement(null);
            }
            ((Transaction)object).closeExecutedStatements();
        }
        catch (Exception exception) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", (Throwable)exception);
        }
        object2 = (TransactionInterface)object;
        try {
            object2.close();
            return;
        }
        catch (Exception exception) {
            object = exception;
            object = exception;
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + ((Throwable)object).getMessage() + ". Statement: " + preparedStatementApi, (Throwable)object);
            return;
        }
    }

    private static final <T> T inTopLevelTransaction$run(Transaction transaction2, Database database, int n, boolean bl, Function1<? super Transaction, ? extends T> function1) {
        TransactionManager transactionManager;
        int n2 = 0;
        Transaction transaction3 = transaction2;
        TransactionManager transactionManager2 = transactionManager = TransactionApiKt.getTransactionManager(transaction3 != null ? transaction3.getDb() : null);
        TransactionManager transactionManager3 = transactionManager.currentOrNull() != null ? transactionManager : null;
        long l = 0L;
        Long l2 = null;
        while (true) {
            Object object;
            Object object2;
            if (database != null) {
                object2 = TransactionApiKt.getTransactionManager(database);
                TransactionManager.Companion.resetCurrent((TransactionManager)object2);
            }
            Transaction transaction4 = TransactionApiKt.getTransactionManager(database).newTransaction(n, bl, transaction2);
            try {
                Schema schema = transaction4.getDb().getConfig().getDefaultSchema();
                if (schema != null) {
                    object2 = schema;
                    SchemaUtils.setSchema$default(SchemaUtils.INSTANCE, (Schema)object2, false, 2, null);
                }
                object = function1.invoke((Object)transaction4);
                transaction4.commit();
                Object object3 = object;
                return (T)object3;
            }
            catch (SQLException sQLException) {
                long l3;
                object = sQLException;
                ThreadLocalTransactionManagerKt.handleSQLException(sQLException, transaction4, n2);
                if (++n2 >= transaction4.getMaxAttempts()) {
                    throw object;
                }
                if (l2 == null) {
                    l2 = transaction4.getRetryInterval$exposed_core();
                    l = transaction4.getMinRetryDelay();
                }
                if (transaction4.getMinRetryDelay() < transaction4.getMaxRetryDelay()) {
                    long l4 = l += l2 * (long)n2;
                    l3 = ThreadLocalRandom.current().nextLong(l4, l4 + l2);
                } else {
                    l3 = transaction4.getMinRetryDelay() == transaction4.getMaxRetryDelay() ? transaction4.getMinRetryDelay() : 0L;
                }
                long l5 = l3;
                SQLLogKt.getExposedLogger().warn("Wait " + l5 + " milliseconds before retrying");
                try {
                    Thread.sleep(l5);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Throwable throwable) {
                PreparedStatementApi preparedStatementApi = transaction4.getCurrentStatement();
                TransactionApiKt.rollbackLoggingException(transaction4, (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(preparedStatementApi){
                    final /* synthetic */ PreparedStatementApi $currentStatement;
                    {
                        this.$currentStatement = preparedStatementApi;
                        super(1);
                    }

                    public final void invoke(Exception exception) {
                        Intrinsics.checkNotNullParameter((Object)exception, (String)"");
                        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + exception.getMessage() + ". Statement: " + this.$currentStatement, (Throwable)exception);
                    }
                }));
                throw throwable;
            }
            finally {
                TransactionManager.Companion.resetCurrent(transactionManager3);
                ThreadLocalTransactionManagerKt.closeStatementsAndConnection(transaction4);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ Object access$inTopLevelTransaction$run(Transaction transaction2, Database database, int n, boolean bl, Function1 function1) {
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction$run(transaction2, database, n, bl, function1);
    }
}

