/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.TypeParameterMatcher;
import java.net.SocketAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAddressResolver<T extends SocketAddress>
implements AddressResolver<T> {
    private final EventExecutor executor;
    private final TypeParameterMatcher matcher;

    protected AbstractAddressResolver(EventExecutor eventExecutor) {
        this.executor = (EventExecutor)ObjectUtil.checkNotNull((Object)eventExecutor, (String)"executor");
        this.matcher = TypeParameterMatcher.find((Object)this, AbstractAddressResolver.class, (String)"T");
    }

    protected AbstractAddressResolver(EventExecutor eventExecutor, Class<? extends T> clazz) {
        this.executor = (EventExecutor)ObjectUtil.checkNotNull((Object)eventExecutor, (String)"executor");
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isSupported(SocketAddress socketAddress) {
        return this.matcher.match((Object)socketAddress);
    }

    @Override
    public final boolean isResolved(SocketAddress socketAddress) {
        if (!this.isSupported(socketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        return this.doIsResolved(socketAddress);
    }

    protected abstract boolean doIsResolved(T var1);

    @Override
    public final Future<T> resolve(SocketAddress socketAddress) {
        if (!this.isSupported((SocketAddress)ObjectUtil.checkNotNull((Object)socketAddress, (String)"address"))) {
            return this.executor().newFailedFuture((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(socketAddress)) {
            return this.executor.newSucceededFuture((Object)socketAddress);
        }
        try {
            Promise promise = this.executor().newPromise();
            this.doResolve(socketAddress, promise);
            return promise;
        }
        catch (Exception exception) {
            return this.executor().newFailedFuture((Throwable)exception);
        }
    }

    @Override
    public final Future<T> resolve(SocketAddress socketAddress, Promise<T> promise) {
        ObjectUtil.checkNotNull((Object)socketAddress, (String)"address");
        ObjectUtil.checkNotNull(promise, (String)"promise");
        if (!this.isSupported(socketAddress)) {
            return promise.setFailure((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(socketAddress)) {
            return promise.setSuccess((Object)socketAddress);
        }
        try {
            this.doResolve(socketAddress, promise);
            return promise;
        }
        catch (Exception exception) {
            return promise.setFailure((Throwable)exception);
        }
    }

    @Override
    public final Future<List<T>> resolveAll(SocketAddress socketAddress) {
        if (!this.isSupported((SocketAddress)ObjectUtil.checkNotNull((Object)socketAddress, (String)"address"))) {
            return this.executor().newFailedFuture((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(socketAddress)) {
            return this.executor.newSucceededFuture(Collections.singletonList(socketAddress));
        }
        try {
            Promise promise = this.executor().newPromise();
            this.doResolveAll(socketAddress, promise);
            return promise;
        }
        catch (Exception exception) {
            return this.executor().newFailedFuture((Throwable)exception);
        }
    }

    @Override
    public final Future<List<T>> resolveAll(SocketAddress socketAddress, Promise<List<T>> promise) {
        ObjectUtil.checkNotNull((Object)socketAddress, (String)"address");
        ObjectUtil.checkNotNull(promise, (String)"promise");
        if (!this.isSupported(socketAddress)) {
            return promise.setFailure((Throwable)new UnsupportedAddressTypeException());
        }
        if (this.isResolved(socketAddress)) {
            return promise.setSuccess(Collections.singletonList(socketAddress));
        }
        try {
            this.doResolveAll(socketAddress, promise);
            return promise;
        }
        catch (Exception exception) {
            return promise.setFailure((Throwable)exception);
        }
    }

    protected abstract void doResolve(T var1, Promise<T> var2);

    protected abstract void doResolveAll(T var1, Promise<List<T>> var2);

    @Override
    public void close() {
    }
}

