/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.lazy.layout.LazyLayoutScrollScope;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerScrollPositionKt;
import androidx.compose.foundation.pager.PagerState;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"LazyLayoutScrollScope", "Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;", "state", "Landroidx/compose/foundation/pager/PagerState;", "scrollScope", "Landroidx/compose/foundation/gestures/ScrollScope;", "foundation"})
public final class PagerScrollScopeKt {
    public static final LazyLayoutScrollScope LazyLayoutScrollScope(PagerState pagerState, ScrollScope scrollScope2) {
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        Intrinsics.checkNotNullParameter((Object)scrollScope2, (String)"");
        return (LazyLayoutScrollScope)new ScrollScope(scrollScope2, pagerState){
            private final /* synthetic */ ScrollScope $$delegate_0;
            final /* synthetic */ PagerState $state;
            {
                this.$state = pagerState;
                this.$$delegate_0 = scrollScope2;
            }

            public final int getFirstVisibleItemIndex() {
                return this.$state.getFirstVisiblePage$foundation();
            }

            public final int getFirstVisibleItemScrollOffset() {
                return this.$state.getFirstVisiblePageOffset$foundation();
            }

            public final int getLastVisibleItemIndex() {
                return ((PageInfo)CollectionsKt.last(this.$state.getLayoutInfo().getVisiblePagesInfo())).getIndex();
            }

            public final int getItemCount() {
                return this.$state.getPageCount();
            }

            public final void snapToItem(int n2, int n3) {
                float f2 = (float)n3 / (float)this.$state.getPageSizeWithSpacing$foundation();
                this.$state.snapToItem$foundation(n2, f2, true);
            }

            public final int calculateDistanceTo(int n2, int n3) {
                n2 = MathKt.roundToInt((float)((float)((n2 - this.$state.getCurrentPage()) * this.$state.getPageSizeWithSpacing$foundation()) - this.$state.getCurrentPageOffsetFraction() * (float)this.$state.getPageSizeWithSpacing$foundation() + (float)n3));
                long l2 = RangesKt.coerceIn((long)(PagerScrollPositionKt.currentAbsoluteScrollOffset(this.$state) + (long)n2), (long)this.$state.getMinScrollOffset$foundation(), (long)this.$state.getMaxScrollOffset$foundation());
                return (int)(l2 - PagerScrollPositionKt.currentAbsoluteScrollOffset(this.$state));
            }

            public final float scrollBy(float f2) {
                return this.$$delegate_0.scrollBy(f2);
            }
        };
    }
}

