/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.compose.ui.semantics.SemanticsRegion;
import androidx.compose.ui.unit.IntRect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.Region;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0001H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/semantics/SemanticRegionImpl;", "Landroidx/compose/ui/semantics/SemanticsRegion;", "<init>", "()V", "region", "Lorg/jetbrains/skia/Region;", "getRegion", "()Lorg/jetbrains/skia/Region;", "set", "", "rect", "Landroidx/compose/ui/unit/IntRect;", "bounds", "getBounds", "()Landroidx/compose/ui/unit/IntRect;", "isEmpty", "", "()Z", "intersect", "difference", "ui"})
final class SemanticRegionImpl
implements SemanticsRegion {
    private final Region region = new Region();

    public final Region getRegion() {
        return this.region;
    }

    @Override
    public final void set(IntRect intRect) {
        Intrinsics.checkNotNullParameter((Object)intRect, (String)"");
        this.region.setRect(IRect.Companion.makeLTRB(intRect.getLeft(), intRect.getTop(), intRect.getRight(), intRect.getBottom()));
    }

    @Override
    public final IntRect getBounds() {
        IRect iRect = this.region.getBounds();
        return new IntRect(iRect.getLeft(), iRect.getTop(), iRect.getRight(), iRect.getBottom());
    }

    @Override
    public final boolean isEmpty() {
        return this.region.isEmpty();
    }

    @Override
    public final boolean intersect(SemanticsRegion semanticsRegion) {
        Intrinsics.checkNotNullParameter((Object)semanticsRegion, (String)"");
        return this.region.op(((SemanticRegionImpl)semanticsRegion).region, Region.Op.INTERSECT);
    }

    @Override
    public final boolean difference(IntRect intRect) {
        Intrinsics.checkNotNullParameter((Object)intRect, (String)"");
        return this.region.op(IRect.Companion.makeLTRB(intRect.getLeft(), intRect.getTop(), intRect.getRight(), intRect.getBottom()), Region.Op.DIFFERENCE);
    }
}

