/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.internal.SystemPropertyUtil;

public final class KQueue {
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static boolean isTcpFastOpenClientSideAvailable() {
        return KQueue.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    }

    public static boolean isTcpFastOpenServerSideAvailable() {
        return KQueue.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    }

    private KQueue() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Throwable throwable;
        block7: {
            throwable = null;
            if (SystemPropertyUtil.getBoolean((String)"io.netty.transport.noNative", (boolean)false)) {
                throwable = new UnsupportedOperationException("Native transport was explicit disabled with -Dio.netty.transport.noNative=true");
            } else {
                FileDescriptor fileDescriptor;
                try {
                    fileDescriptor = Native.newKQueue();
                    if (fileDescriptor == null) break block7;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throwable = throwable2;
                    break block7;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                try {
                    fileDescriptor.close();
                }
                catch (Exception exception) {}
            }
        }
        UNAVAILABILITY_CAUSE = throwable;
    }
}

