/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueueChannelOption;
import io.netty.channel.unix.IntegerUnixChannelOption;
import io.netty.channel.unix.Limits;
import io.netty.channel.unix.RawUnixChannelOption;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class KQueueChannelConfig
extends DefaultChannelConfig {
    private volatile boolean transportProvidesGuess;
    private volatile long maxBytesPerGatheringWrite = Limits.SSIZE_MAX;

    KQueueChannelConfig(AbstractKQueueChannel abstractKQueueChannel) {
        super((Channel)abstractKQueueChannel);
    }

    KQueueChannelConfig(AbstractKQueueChannel abstractKQueueChannel, RecvByteBufAllocator recvByteBufAllocator) {
        super((Channel)abstractKQueueChannel, recvByteBufAllocator);
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        KQueueChannelConfig kQueueChannelConfig = this;
        return kQueueChannelConfig.getOptions(super.getOptions(), new ChannelOption[]{KQueueChannelOption.RCV_ALLOC_TRANSPORT_PROVIDES_GUESS});
    }

    public <T> T getOption(ChannelOption<T> integerUnixChannelOption) {
        if (integerUnixChannelOption == KQueueChannelOption.RCV_ALLOC_TRANSPORT_PROVIDES_GUESS) {
            return (T)Boolean.valueOf(this.getRcvAllocTransportProvidesGuess());
        }
        try {
            if (integerUnixChannelOption instanceof IntegerUnixChannelOption) {
                integerUnixChannelOption = integerUnixChannelOption;
                return (T)Integer.valueOf(((AbstractKQueueChannel)this.channel).socket.getIntOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname()));
            }
            if (integerUnixChannelOption instanceof RawUnixChannelOption) {
                integerUnixChannelOption = (RawUnixChannelOption)integerUnixChannelOption;
                ByteBuffer byteBuffer = ByteBuffer.allocate(integerUnixChannelOption.length());
                ((AbstractKQueueChannel)this.channel).socket.getRawOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname(), byteBuffer);
                return (T)byteBuffer.flip();
            }
        }
        catch (IOException iOException) {
            throw new ChannelException((Throwable)iOException);
        }
        return (T)super.getOption((ChannelOption)integerUnixChannelOption);
    }

    public <T> boolean setOption(ChannelOption<T> integerUnixChannelOption, T t) {
        this.validate((ChannelOption)integerUnixChannelOption, t);
        if (integerUnixChannelOption != KQueueChannelOption.RCV_ALLOC_TRANSPORT_PROVIDES_GUESS) {
            try {
                if (integerUnixChannelOption instanceof IntegerUnixChannelOption) {
                    integerUnixChannelOption = integerUnixChannelOption;
                    ((AbstractKQueueChannel)this.channel).socket.setIntOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname(), (Integer)t);
                    return true;
                }
                if (integerUnixChannelOption instanceof RawUnixChannelOption) {
                    integerUnixChannelOption = (RawUnixChannelOption)integerUnixChannelOption;
                    ((AbstractKQueueChannel)this.channel).socket.setRawOpt(integerUnixChannelOption.level(), integerUnixChannelOption.optname(), (ByteBuffer)t);
                    return true;
                }
            }
            catch (IOException iOException) {
                throw new ChannelException((Throwable)iOException);
            }
            return super.setOption((ChannelOption)integerUnixChannelOption, t);
        }
        this.setRcvAllocTransportProvidesGuess((Boolean)t);
        return true;
    }

    public KQueueChannelConfig setRcvAllocTransportProvidesGuess(boolean bl) {
        this.transportProvidesGuess = bl;
        return this;
    }

    public boolean getRcvAllocTransportProvidesGuess() {
        return this.transportProvidesGuess;
    }

    public KQueueChannelConfig setConnectTimeoutMillis(int n) {
        super.setConnectTimeoutMillis(n);
        return this;
    }

    @Deprecated
    public KQueueChannelConfig setMaxMessagesPerRead(int n) {
        super.setMaxMessagesPerRead(n);
        return this;
    }

    public KQueueChannelConfig setWriteSpinCount(int n) {
        super.setWriteSpinCount(n);
        return this;
    }

    public KQueueChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    public KQueueChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        if (!(recvByteBufAllocator.newHandle() instanceof RecvByteBufAllocator.ExtendedHandle)) {
            throw new IllegalArgumentException("allocator.newHandle() must return an object of type: " + RecvByteBufAllocator.ExtendedHandle.class);
        }
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    public KQueueChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Deprecated
    public KQueueChannelConfig setWriteBufferHighWaterMark(int n) {
        super.setWriteBufferHighWaterMark(n);
        return this;
    }

    @Deprecated
    public KQueueChannelConfig setWriteBufferLowWaterMark(int n) {
        super.setWriteBufferLowWaterMark(n);
        return this;
    }

    public KQueueChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    public KQueueChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    protected final void autoReadCleared() {
        ((AbstractKQueueChannel)this.channel).clearReadFilter();
    }

    final void setMaxBytesPerGatheringWrite(long l) {
        this.maxBytesPerGatheringWrite = Math.min(Limits.SSIZE_MAX, l);
    }

    final long getMaxBytesPerGatheringWrite() {
        return this.maxBytesPerGatheringWrite;
    }
}

