/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\u0004\u001a\u00020\u0000*\u00020\u00002\n\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0006\u001a\u00020\u0000*\u00020\u00002\n\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u0019\u0010\u0003\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00020\u0007\u00a2\u0006\u0004\b\u0003\u0010\b\u00a8\u0006\t"}, d2={"Lio/ktor/http/ContentType;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "withCharset", "(Lio/ktor/http/ContentType;Ljava/nio/charset/Charset;)Lio/ktor/http/ContentType;", "withCharsetIfNeeded", "Lio/ktor/http/HeaderValueWithParameters;", "(Lio/ktor/http/HeaderValueWithParameters;)Ljava/nio/charset/Charset;", "ktor-http"})
public final class ContentTypesKt {
    public static final ContentType withCharset(ContentType contentType, Charset charset) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"");
        return contentType.withParameter("charset", CharsetJVMKt.getName((Charset)charset));
    }

    public static final ContentType withCharsetIfNeeded(ContentType contentType, Charset charset) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"");
        String string = contentType.getContentType().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        if (!Intrinsics.areEqual((Object)string, (Object)"text")) {
            return contentType;
        }
        return contentType.withParameter("charset", CharsetJVMKt.getName((Charset)charset));
    }

    public static final Charset charset(HeaderValueWithParameters object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        String string = ((HeaderValueWithParameters)object).parameter("charset");
        if (string != null) {
            object = string;
            try {
                object = CharsetJVMKt.forName((Charsets)Charsets.INSTANCE, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = null;
            }
            return object;
        }
        return null;
    }
}

