/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserException;
import io.ktor.http.URLParserKt;
import io.ktor.http.Url;
import io.ktor.util.StringValuesBuilder;
import io.ktor.util.StringValuesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007\u001a&\u0010\f\u001a\u00020\u00022\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u0004\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0012\u001a\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0013\u001a\u0019\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0019\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0016\u001a/\u0010\u001d\u001a\u00020\t*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a-\u0010\u001d\u001a\u00020\t*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010!\u001a+\u0010&\u001a\u00020\t*\u00060\"j\u0002`#2\b\u0010$\u001a\u0004\u0018\u00010\u00002\b\u0010%\u001a\u0004\u0018\u00010\u0000H\u0000\u00a2\u0006\u0004\b&\u0010'\"\u0015\u0010*\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0015\u0010,\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)\"\u0015\u0010.\u001a\u00020\u0000*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b-\u0010)\"\u0015\u0010/\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0015\u00101\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b1\u00100\"\u0015\u0010/\u001a\u00020\u001b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u00102\"\u0015\u00101\u001a\u00020\u001b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"", "urlString", "Lio/ktor/http/Url;", "Url", "(Ljava/lang/String;)Lio/ktor/http/Url;", "Lio/ktor/http/URLBuilder;", "builder", "(Lio/ktor/http/URLBuilder;)Lio/ktor/http/Url;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "buildUrl", "(Lkotlin/jvm/functions/Function1;)Lio/ktor/http/Url;", "parseUrl", "URLBuilder", "(Ljava/lang/String;)Lio/ktor/http/URLBuilder;", "url", "(Lio/ktor/http/Url;)Lio/ktor/http/URLBuilder;", "(Lio/ktor/http/URLBuilder;)Lio/ktor/http/URLBuilder;", "takeFrom", "(Lio/ktor/http/URLBuilder;Lio/ktor/http/URLBuilder;)Lio/ktor/http/URLBuilder;", "(Lio/ktor/http/URLBuilder;Lio/ktor/http/Url;)Lio/ktor/http/URLBuilder;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "encodedPath", "encodedQuery", "", "trailingQuery", "appendUrlFullPath", "(Ljava/lang/Appendable;Ljava/lang/String;Ljava/lang/String;Z)V", "Lio/ktor/http/ParametersBuilder;", "encodedQueryParameters", "(Ljava/lang/Appendable;Ljava/lang/String;Lio/ktor/http/ParametersBuilder;Z)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "encodedUser", "encodedPassword", "appendUserAndPassword", "(Ljava/lang/StringBuilder;Ljava/lang/String;Ljava/lang/String;)V", "getFullPath", "(Lio/ktor/http/Url;)Ljava/lang/String;", "fullPath", "getHostWithPort", "hostWithPort", "getHostWithPortIfSpecified", "hostWithPortIfSpecified", "isAbsolutePath", "(Lio/ktor/http/Url;)Z", "isRelativePath", "(Lio/ktor/http/URLBuilder;)Z", "ktor-http"})
public final class URLUtilsKt {
    public static final Url Url(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return URLUtilsKt.URLBuilder(string).build();
    }

    public static final Url Url(URLBuilder uRLBuilder) {
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), uRLBuilder).build();
    }

    public static final Url buildUrl(Function1<? super URLBuilder, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        URLBuilder uRLBuilder = new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null);
        function1.invoke((Object)uRLBuilder);
        return uRLBuilder.build();
    }

    public static final Url parseUrl(String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        try {
            object = URLUtilsKt.URLBuilder((String)object);
            URLBuilder uRLBuilder = object;
            Object object2 = ((CharSequence)((URLBuilder)object).getHost()).length() > 0 ? object : null;
            object = object2 != null ? ((URLBuilder)object2).build() : null;
        }
        catch (URLParserException uRLParserException) {
            object = null;
        }
        return object;
    }

    public static final URLBuilder URLBuilder(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return URLParserKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), string);
    }

    public static final URLBuilder URLBuilder(Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), url);
    }

    public static final URLBuilder URLBuilder(URLBuilder uRLBuilder) {
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        return URLUtilsKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), uRLBuilder);
    }

    public static final URLBuilder takeFrom(URLBuilder uRLBuilder, URLBuilder uRLBuilder2) {
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)uRLBuilder2, (String)"");
        uRLBuilder.setProtocolOrNull(uRLBuilder2.getProtocolOrNull());
        uRLBuilder.setHost(uRLBuilder2.getHost());
        uRLBuilder.setPort(uRLBuilder2.getPort());
        uRLBuilder.setEncodedPathSegments(uRLBuilder2.getEncodedPathSegments());
        uRLBuilder.setEncodedUser(uRLBuilder2.getEncodedUser());
        uRLBuilder.setEncodedPassword(uRLBuilder2.getEncodedPassword());
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        URLBuilder uRLBuilder3 = uRLBuilder;
        StringValuesKt.appendAll((StringValuesBuilder)parametersBuilder2, (StringValuesBuilder)uRLBuilder2.getEncodedParameters());
        uRLBuilder3.setEncodedParameters(parametersBuilder);
        uRLBuilder.setEncodedFragment(uRLBuilder2.getEncodedFragment());
        uRLBuilder.setTrailingQuery(uRLBuilder2.getTrailingQuery());
        return uRLBuilder;
    }

    public static final URLBuilder takeFrom(URLBuilder uRLBuilder, Url url) {
        ParametersBuilder parametersBuilder;
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        uRLBuilder.setProtocolOrNull(url.getProtocolOrNull());
        uRLBuilder.setHost(url.getHost());
        uRLBuilder.setPort(url.getPort());
        URLBuilderKt.setEncodedPath(uRLBuilder, url.getEncodedPath());
        uRLBuilder.setEncodedUser(url.getEncodedUser());
        uRLBuilder.setEncodedPassword(url.getEncodedPassword());
        ParametersBuilder parametersBuilder2 = parametersBuilder = ParametersKt.ParametersBuilder$default(0, 1, null);
        URLBuilder uRLBuilder2 = uRLBuilder;
        parametersBuilder2.appendAll(QueryKt.parseQueryString$default(url.getEncodedQuery(), 0, 0, false, 6, null));
        uRLBuilder2.setEncodedParameters(parametersBuilder);
        uRLBuilder.setEncodedFragment(url.getEncodedFragment());
        uRLBuilder.setTrailingQuery(url.getTrailingQuery());
        return uRLBuilder;
    }

    public static final String getFullPath(Url url) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        URLUtilsKt.appendUrlFullPath((Appendable)stringBuilder, url.getEncodedPath(), url.getEncodedQuery(), url.getTrailingQuery());
        return stringBuilder.toString();
    }

    public static final String getHostWithPort(Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        return url.getHost() + ':' + url.getPort();
    }

    public static final String getHostWithPortIfSpecified(Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        int n = url.getSpecifiedPort();
        if (n == 0 || n == url.getProtocol().getDefaultPort()) {
            return url.getHost();
        }
        return URLUtilsKt.getHostWithPort(url);
    }

    public static final void appendUrlFullPath(Appendable appendable, String string, String string2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (!StringsKt.isBlank((CharSequence)string) && !StringsKt.startsWith$default((String)string, (String)"/", (boolean)false, (int)2, null)) {
            appendable.append('/');
        }
        appendable.append(string);
        if (((CharSequence)string2).length() > 0 || bl) {
            appendable.append("?");
        }
        appendable.append(string2);
    }

    public static final void appendUrlFullPath(Appendable appendable, String iterator, ParametersBuilder object, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (!StringsKt.isBlank((CharSequence)((CharSequence)((Object)iterator))) && !StringsKt.startsWith$default((String)((Object)iterator), (String)"/", (boolean)false, (int)2, null)) {
            appendable.append('/');
        }
        appendable.append((CharSequence)((Object)iterator));
        if (!object.isEmpty() || bl) {
            appendable.append("?");
        }
        iterator = object.entries();
        object = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            List list;
            Object object2 = iterator.next();
            object2 = (Map.Entry)object2;
            String string = (String)object2.getKey();
            if ((object2 = (List)object2.getValue()).isEmpty()) {
                list = CollectionsKt.listOf((Object)TuplesKt.to((Object)string, null));
            } else {
                Object object3 = object2 = (Iterable)object2;
                object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    Object object4 = object3.next();
                    object4 = (String)object4;
                    Object object5 = object2;
                    object5.add(TuplesKt.to((Object)string, object4));
                }
                list = (List)object2;
            }
            object2 = list;
            CollectionsKt.addAll((Collection)object, (Iterable)object2);
        }
        CollectionsKt.joinTo$default((Iterable)((List)object), (Appendable)appendable, (CharSequence)"&", null, null, (int)0, null, URLUtilsKt::appendUrlFullPath$lambda$6, (int)60, null);
    }

    public static final boolean isAbsolutePath(Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        return Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(url.getRawSegments()), (Object)"");
    }

    public static final boolean isRelativePath(Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"");
        return !URLUtilsKt.isAbsolutePath(url);
    }

    public static final boolean isAbsolutePath(URLBuilder uRLBuilder) {
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        return Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(uRLBuilder.getPathSegments()), (Object)"");
    }

    public static final boolean isRelativePath(URLBuilder uRLBuilder) {
        Intrinsics.checkNotNullParameter((Object)uRLBuilder, (String)"");
        return !URLUtilsKt.isAbsolutePath(uRLBuilder);
    }

    public static final void appendUserAndPassword(StringBuilder stringBuilder, String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        if (string == null) {
            return;
        }
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(':');
            stringBuilder.append(string2);
        }
        stringBuilder.append("@");
    }

    private static final CharSequence appendUrlFullPath$lambda$6(Pair object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        String string = (String)object.getFirst();
        if (object.getSecond() == null) {
            return string;
        }
        object = String.valueOf(object.getSecond());
        return string + '=' + (String)object;
    }
}

