/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

public class IncomingFileTransfer
extends FileTransfer {
    private static final Logger LOGGER = Logger.getLogger(IncomingFileTransfer.class.getName());
    private FileTransferRequest receiveRequest;
    private InputStream inputStream;

    protected IncomingFileTransfer(FileTransferRequest fileTransferRequest, FileTransferNegotiator fileTransferNegotiator) {
        super(fileTransferRequest.getRequestor(), fileTransferRequest.getStreamID(), fileTransferNegotiator);
        this.receiveRequest = fileTransferRequest;
    }

    public InputStream receiveFile() {
        if (this.inputStream != null) {
            throw new IllegalStateException("Transfer already negotiated!");
        }
        try {
            this.inputStream = this.negotiateStream();
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            this.setException((Exception)((Object)xMPPErrorException));
            throw xMPPErrorException;
        }
        return this.inputStream;
    }

    public void receiveFile(File object) {
        if (object == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!((File)object).exists()) {
            ((File)object).createNewFile();
        }
        if (!((File)object).canWrite()) {
            throw new IllegalArgumentException("Cannot write to provided file");
        }
        object = new Thread(new Runnable((File)object){
            final /* synthetic */ File val$file;
            {
                this.val$file = file;
            }

            @Override
            public void run() {
                try {
                    IncomingFileTransfer.this.inputStream = IncomingFileTransfer.this.negotiateStream();
                }
                catch (Exception exception) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setException(exception);
                    return;
                }
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(this.val$file);
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.in_progress);
                    IncomingFileTransfer.this.writeToStream(IncomingFileTransfer.this.inputStream, fileOutputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setError(FileTransfer.Error.bad_file);
                    IncomingFileTransfer.this.setException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.error);
                    IncomingFileTransfer.this.setError(FileTransfer.Error.stream);
                    IncomingFileTransfer.this.setException(iOException);
                }
                if (IncomingFileTransfer.this.getStatus().equals((Object)FileTransfer.Status.in_progress)) {
                    IncomingFileTransfer.this.setStatus(FileTransfer.Status.complete);
                }
                CloseableUtil.maybeClose((Closeable)IncomingFileTransfer.this.inputStream, (Logger)LOGGER);
                CloseableUtil.maybeClose((Closeable)fileOutputStream, (Logger)LOGGER);
            }
        }, "File Transfer " + this.streamID);
        ((Thread)object).start();
    }

    private InputStream negotiateStream() {
        InputStream inputStream;
        this.setStatus(FileTransfer.Status.negotiating_transfer);
        Object object = this.negotiator.selectStreamNegotiator(this.receiveRequest);
        this.setStatus(FileTransfer.Status.negotiating_stream);
        object = new FutureTask<InputStream>(new Callable<InputStream>((StreamNegotiator)((Object)object)){
            final /* synthetic */ StreamNegotiator val$streamNegotiator;
            {
                this.val$streamNegotiator = streamNegotiator;
            }

            @Override
            public InputStream call() {
                return this.val$streamNegotiator.createIncomingStream(IncomingFileTransfer.this.receiveRequest.getStreamInitiation());
            }
        });
        ((FutureTask)object).run();
        try {
            inputStream = (InputStream)((FutureTask)object).get(15L, TimeUnit.SECONDS);
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            Throwable throwable = executionException.getCause();
            if (throwable instanceof XMPPException.XMPPErrorException) {
                throw (XMPPException.XMPPErrorException)throwable;
            }
            if (throwable instanceof InterruptedException) {
                throw (InterruptedException)throwable;
            }
            if (throwable instanceof SmackException.NoResponseException) {
                throw (SmackException.NoResponseException)throwable;
            }
            if (throwable instanceof SmackException) {
                throw (SmackException)throwable;
            }
            throw new SmackException.SmackWrappedException("Error in execution", (Exception)executionException2);
        }
        catch (TimeoutException timeoutException) {
            throw new SmackException.SmackWrappedException("Request timed out", (Exception)timeoutException);
        }
        finally {
            ((FutureTask)object).cancel(true);
        }
        this.setStatus(FileTransfer.Status.negotiated);
        return inputStream;
    }

    @Override
    public void cancel() {
        this.setStatus(FileTransfer.Status.cancelled);
    }
}

