/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements;

import org.e.a.a.d;
import org.e.a.i;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.InternetAddress;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.element.JingleContentTransportCandidate;

public final class JingleS5BTransportCandidate
extends JingleContentTransportCandidate {
    public static final String NAMESPACE = "urn:xmpp:jingle:transports:s5b:1";
    public static final String ATTR_CID = "cid";
    public static final String ATTR_HOST = "host";
    public static final String ATTR_JID = "jid";
    public static final String ATTR_PORT = "port";
    public static final String ATTR_PRIORITY = "priority";
    public static final String ATTR_TYPE = "type";
    private final String cid;
    private final InternetAddress host;
    private final i jid;
    private final int port;
    private final int priority;
    private final Type type;

    public JingleS5BTransportCandidate(String string, String string2, i i2, int n, int n2, Type type) {
        this(string, InternetAddress.fromIgnoringZoneId((String)string2), i2, n, n2, type);
    }

    public JingleS5BTransportCandidate(String string, InternetAddress internetAddress, i i2, int n, int n2, Type type) {
        Objects.requireNonNull((Object)string);
        Objects.requireNonNull((Object)internetAddress);
        Objects.requireNonNull((Object)i2);
        if (n2 < 0) {
            throw new IllegalArgumentException("Priority MUST NOT be less than 0.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Port MUST NOT be less than 0.");
        }
        this.cid = string;
        this.host = internetAddress;
        this.jid = i2;
        this.port = n;
        this.priority = n2;
        this.type = type;
    }

    public JingleS5BTransportCandidate(Bytestream.StreamHost streamHost, int n, Type type) {
        this(StringUtils.randomString((int)24), streamHost.getAddress(), streamHost.getJID(), streamHost.getPort(), n, type);
    }

    public final String getCandidateId() {
        return this.cid;
    }

    public final InternetAddress getHost() {
        return this.host;
    }

    public final i getJid() {
        return this.jid;
    }

    public final int getPort() {
        return this.port;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final Type getType() {
        return this.type;
    }

    public final Bytestream.StreamHost getStreamHost() {
        return new Bytestream.StreamHost(this.jid, this.host, this.port);
    }

    public final String getNamespace() {
        return NAMESPACE;
    }

    public final XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        xmlEnvironment.attribute(ATTR_CID, this.cid);
        xmlEnvironment.attribute(ATTR_HOST, (CharSequence)this.host);
        xmlEnvironment.attribute(ATTR_JID, (CharSequence)this.jid);
        if (this.port >= 0) {
            xmlEnvironment.attribute(ATTR_PORT, this.port);
        }
        xmlEnvironment.attribute(ATTR_PRIORITY, this.priority);
        xmlEnvironment.optAttribute(ATTR_TYPE, (Enum)this.type);
        xmlEnvironment.closeEmptyElement();
        return xmlEnvironment;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String cid;
        private InternetAddress host;
        private i jid;
        private int port = -1;
        private int priority = -1;
        private Type type;

        private Builder() {
        }

        public final Builder setCandidateId(String string) {
            this.cid = string;
            return this;
        }

        public final Builder setHost(String string) {
            string = InternetAddress.fromIgnoringZoneId((String)string);
            return this.setHost((InternetAddress)string);
        }

        public final Builder setHost(InternetAddress internetAddress) {
            this.host = internetAddress;
            return this;
        }

        public final Builder setJid(String string) {
            this.jid = d.a((String)string);
            return this;
        }

        public final Builder setPort(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Port MUST NOT be less than 0.");
            }
            this.port = n;
            return this;
        }

        public final Builder setPriority(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Priority MUST NOT be less than 0.");
            }
            this.priority = n;
            return this;
        }

        public final Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public final JingleS5BTransportCandidate build() {
            return new JingleS5BTransportCandidate(this.cid, this.host, this.jid, this.port, this.priority, this.type);
        }
    }

    public static enum Type {
        assisted(120),
        direct(126),
        proxy(10),
        tunnel(110);

        private final int weight;

        public final int getWeight() {
            return this.weight;
        }

        private Type(int n2) {
            this.weight = n2;
        }

        public static Type fromString(String string) {
            for (Type type : Type.values()) {
                if (!type.toString().equals(string)) continue;
                return type;
            }
            throw new IllegalArgumentException("Illegal type: " + string);
        }
    }
}

