/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.logging.Logger;
import org.e.a.b.d;
import org.e.a.i;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCUser;

public class Occupant {
    private static final Logger LOGGER = Logger.getLogger(Occupant.class.getName());
    private final MUCAffiliation affiliation;
    private final MUCRole role;
    private final i jid;
    private final d nick;

    Occupant(MUCItem mUCItem) {
        this.jid = mUCItem.getJid();
        this.affiliation = mUCItem.getAffiliation();
        this.role = mUCItem.getRole();
        this.nick = mUCItem.getNick();
    }

    Occupant(Presence presence) {
        Object object = (MUCUser)presence.getExtensionElement("x", "http://jabber.org/protocol/muc#user");
        object = ((MUCUser)object).getItem();
        this.jid = ((MUCItem)object).getJid();
        this.affiliation = ((MUCItem)object).getAffiliation();
        this.role = ((MUCItem)object).getRole();
        object = presence.getFrom().q();
        if (object == null) {
            LOGGER.warning("Occupant presence without resource: " + presence.getFrom());
            this.nick = null;
            return;
        }
        this.nick = object.d();
    }

    public i getJid() {
        return this.jid;
    }

    public MUCAffiliation getAffiliation() {
        return this.affiliation;
    }

    public MUCRole getRole() {
        return this.role;
    }

    public d getNick() {
        return this.nick;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Occupant)) {
            return false;
        }
        object = (Occupant)object;
        return this.jid.a((CharSequence)((Occupant)object).jid);
    }

    public int hashCode() {
        int n = this.affiliation.hashCode();
        n = n * 17 + this.role.hashCode();
        n = n * 17 + (this.jid != null ? this.jid.hashCode() : 0);
        n = n * 17 + (this.nick != null ? this.nick.hashCode() : 0);
        return n;
    }
}

