/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.packet;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdatavalidation.ValidationConsistencyException;

public abstract class ValidateElement
implements FormFieldChildElement {
    public static final String DATATYPE_XS_STRING = "xs:string";
    public static final String ELEMENT = "validate";
    public static final String NAMESPACE = "http://jabber.org/protocol/xdata-validate";
    public static final QName QNAME = new QName("http://jabber.org/protocol/xdata-validate", "validate");
    private final String datatype;
    private ListRange listRange;

    private ValidateElement(String string) {
        this.datatype = StringUtils.isNotEmpty((CharSequence)string) ? string : null;
    }

    public String getDatatype() {
        if (this.datatype != null) {
            return this.datatype;
        }
        return DATATYPE_XS_STRING;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public QName getQName() {
        return QNAME;
    }

    @Override
    public final boolean mustBeOnlyOfHisKind() {
        return true;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        xmlEnvironment.optAttribute("datatype", this.datatype);
        xmlEnvironment.rightAngleBracket();
        this.appendXML((XmlStringBuilder)xmlEnvironment);
        xmlEnvironment.optAppend((Element)this.getListRange());
        xmlEnvironment.closeElement((NamedElement)this);
        return xmlEnvironment;
    }

    protected abstract void appendXML(XmlStringBuilder var1);

    public void setListRange(ListRange listRange) {
        this.listRange = listRange;
    }

    public ListRange getListRange() {
        return this.listRange;
    }

    @Override
    public abstract void checkConsistency(FormField.Builder<?, ?> var1);

    public static ValidateElement from(FormField formField) {
        return (ValidateElement)formField.getFormFieldChildElement(QNAME);
    }

    protected void checkListRangeConsistency(FormField.Builder<?, ?> builder) {
        ListRange listRange = this.getListRange();
        if (listRange == null) {
            return;
        }
        UInt32 uInt32 = listRange.getMax();
        listRange = listRange.getMin();
        if ((uInt32 != null || listRange != null) && builder.getType() != FormField.Type.list_multi) {
            throw new ValidationConsistencyException("Field type is not of type 'list-multi' while a 'list-range' is defined.");
        }
    }

    protected void checkNonMultiConsistency(FormField.Builder<?, ?> builder, String string) {
        this.checkListRangeConsistency(builder);
        if (builder.getType() != null) {
            switch (builder.getType()) {
                case hidden: 
                case jid_multi: 
                case list_multi: 
                case text_multi: {
                    throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{builder.getType(), string}));
                }
            }
        }
    }

    public static class ListRange
    implements FullyQualifiedElement {
        public static final String ELEMENT = "list-range";
        private final UInt32 min;
        private final UInt32 max;

        public ListRange(Long l, Long l2) {
            this(l != null ? UInt32.from((long)l) : null, l2 != null ? UInt32.from((long)l2) : null);
        }

        public ListRange(UInt32 uInt32, UInt32 uInt322) {
            if (uInt322 == null && uInt32 == null) {
                throw new IllegalArgumentException("Either min or max must be given");
            }
            this.min = uInt32;
            this.max = uInt322;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            xmlEnvironment = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlEnvironment.optAttributeCs("min", (CharSequence)this.getMin());
            xmlEnvironment.optAttributeCs("max", (CharSequence)this.getMax());
            xmlEnvironment.closeEmptyElement();
            return xmlEnvironment;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public UInt32 getMin() {
            return this.min;
        }

        public UInt32 getMax() {
            return this.max;
        }

        public String getNamespace() {
            return ValidateElement.NAMESPACE;
        }
    }

    public static class RegexValidateElement
    extends ValidateElement {
        public static final String METHOD = "regex";
        private final String regex;

        public RegexValidateElement(String string, String string2) {
            super(string);
            this.regex = string2;
        }

        public String getRegex() {
            return this.regex;
        }

        @Override
        protected void appendXML(XmlStringBuilder xmlStringBuilder) {
            xmlStringBuilder.element(METHOD, this.getRegex());
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> builder) {
            this.checkNonMultiConsistency(builder, METHOD);
        }
    }

    public static class RangeValidateElement
    extends ValidateElement {
        public static final String METHOD = "range";
        private final String min;
        private final String max;

        public RangeValidateElement(String string, String string2, String string3) {
            super(string);
            this.min = string2;
            this.max = string3;
        }

        @Override
        protected void appendXML(XmlStringBuilder xmlStringBuilder) {
            xmlStringBuilder.halfOpenElement(METHOD);
            xmlStringBuilder.optAttribute("min", this.getMin());
            xmlStringBuilder.optAttribute("max", this.getMax());
            xmlStringBuilder.closeEmptyElement();
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> builder) {
            this.checkNonMultiConsistency(builder, METHOD);
            if (this.getDatatype().equals(ValidateElement.DATATYPE_XS_STRING)) {
                throw new ValidationConsistencyException(String.format("Field data type '%1$s' is not consistent with validation method '%2$s'.", this.getDatatype(), METHOD));
            }
        }

        @Override
        public void validate(FormField object) {
            if ((object = ((FormField)object).ifPossibleAs(AbstractSingleStringValueFormField.class)) == null) {
                return;
            }
            object = ((AbstractSingleStringValueFormField)object).getValue();
            switch (this.getDatatype()) {
                case "xs:int": 
                case "xs:integer": {
                    Object object2;
                    Object object3 = new BigInteger((String)object);
                    Object object4 = this.getMin();
                    if (object4 != null && ((BigInteger)object3).compareTo((BigInteger)(object2 = new BigInteger((String)object4))) < 0) {
                        throw new IllegalArgumentException("The provided value " + (String)object + " is lower than the allowed minimum of " + (String)object4);
                    }
                    object2 = this.getMax();
                    if (object2 == null || ((BigInteger)object3).compareTo((BigInteger)(object4 = new BigInteger((String)object2))) <= 0) break;
                    throw new IllegalArgumentException("The provided value " + (String)object + " is higher than the allowed maximum of " + (String)object2);
                }
            }
        }
    }

    public static class OpenValidateElement
    extends ValidateElement {
        public static final String METHOD = "open";

        public OpenValidateElement(String string) {
            super(string);
        }

        @Override
        protected void appendXML(XmlStringBuilder xmlStringBuilder) {
            xmlStringBuilder.emptyElement(METHOD);
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> builder) {
            this.checkListRangeConsistency(builder);
            if (builder.getType() != null) {
                switch (builder.getType()) {
                    case hidden: {
                        throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{builder.getType(), METHOD}));
                    }
                }
            }
        }
    }

    public static class BasicValidateElement
    extends ValidateElement {
        public static final String METHOD = "basic";

        public BasicValidateElement(String string) {
            super(string);
        }

        @Override
        protected void appendXML(XmlStringBuilder xmlStringBuilder) {
            xmlStringBuilder.emptyElement(METHOD);
        }

        @Override
        public void checkConsistency(FormField.Builder<?, ?> builder) {
            this.checkListRangeConsistency(builder);
            if (builder.getType() != null) {
                switch (builder.getType()) {
                    case hidden: 
                    case jid_multi: 
                    case jid_single: {
                        throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{builder.getType(), METHOD}));
                    }
                }
            }
        }
    }
}

