/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures.snapping;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.FinalSnappingItem;
import androidx.compose.foundation.gestures.snapping.LazyListSnapLayoutInfoProviderKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.gestures.snapping.SnapPositionKt;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerSnapDistance;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\f\u0010\f\u001a\u00020\b*\u00020\u0003H\u0002\u001a\u0017\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0082\b\u001a8\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a8\u0006\u0018"}, d2={"SnapLayoutInfoProvider", "Landroidx/compose/foundation/gestures/snapping/SnapLayoutInfoProvider;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "pagerSnapDistance", "Landroidx/compose/foundation/pager/PagerSnapDistance;", "calculateFinalSnappingBound", "Lkotlin/Function3;", "", "isScrollingForward", "", "velocity", "dragGestureDelta", "debugLog", "", "generateMsg", "Lkotlin/Function0;", "", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "snapPositionalThreshold", "flingVelocity", "lowerBoundOffset", "upperBoundOffset", "foundation"})
public final class PagerSnapLayoutInfoProviderKt {
    public static final SnapLayoutInfoProvider SnapLayoutInfoProvider(PagerState pagerState, PagerSnapDistance pagerSnapDistance, Function3<? super Float, ? super Float, ? super Float, Float> function3) {
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        Intrinsics.checkNotNullParameter((Object)pagerSnapDistance, (String)"");
        Intrinsics.checkNotNullParameter(function3, (String)"");
        return new SnapLayoutInfoProvider(pagerState, function3, pagerSnapDistance){
            final /* synthetic */ PagerState $pagerState;
            final /* synthetic */ Function3<Float, Float, Float, Float> $calculateFinalSnappingBound;
            final /* synthetic */ PagerSnapDistance $pagerSnapDistance;
            {
                this.$pagerState = pagerState;
                this.$calculateFinalSnappingBound = function3;
                this.$pagerSnapDistance = pagerSnapDistance;
            }

            public final PagerLayoutInfo getLayoutInfo() {
                return this.$pagerState.getLayoutInfo();
            }

            public final boolean isValidDistance(float f2) {
                return !(f2 == Float.POSITIVE_INFINITY) && !(f2 == Float.NEGATIVE_INFINITY);
            }

            public final float calculateSnapOffset(float f2) {
                boolean bl;
                Pair<Float, Float> pair = this.$pagerState.getLayoutInfo().getSnapPosition();
                pair = this.searchForSnappingBounds((SnapPosition)pair, f2);
                float f3 = ((Number)pair.component1()).floatValue();
                float f4 = ((Number)pair.component2()).floatValue();
                if (!((f2 = ((Number)this.$calculateFinalSnappingBound.invoke((Object)Float.valueOf(f2), (Object)Float.valueOf(f3), (Object)Float.valueOf(f4))).floatValue()) == f3 || f2 == f4 || f2 == 0.0f ? true : (bl = false))) {
                    InlineClassHelperKt.throwIllegalStateException("Final Snapping Offset Should Be one of " + f3 + ", " + f4 + " or 0.0");
                }
                if (this.isValidDistance(f2)) {
                    return f2;
                }
                return 0.0f;
            }

            public final float calculateApproachOffset(float f2, float f3) {
                int n = this.$pagerState.getPageSize$foundation() + this.$pagerState.getPageSpacing$foundation();
                if (n == 0) {
                    return 0.0f;
                }
                int n2 = f2 < 0.0f ? this.$pagerState.getFirstVisiblePage$foundation() + 1 : this.$pagerState.getFirstVisiblePage$foundation();
                int n3 = RangesKt.coerceIn((int)(n2 + (int)(f3 /= (float)n)), (int)0, (int)this.$pagerState.getPageCount());
                n3 = RangesKt.coerceIn((int)this.$pagerSnapDistance.calculateTargetPage(n2, n3, f2, this.$pagerState.getPageSize$foundation(), this.$pagerState.getPageSpacing$foundation()), (int)0, (int)this.$pagerState.getPageCount());
                n3 = (n3 - n2) * n;
                n3 = RangesKt.coerceAtLeast((int)(Math.abs(n3) - n), (int)0);
                f2 = n3 == 0 ? (float)n3 : (float)n3 * Math.signum(f2);
                return f2;
            }

            private final Pair<Float, Float> searchForSnappingBounds(SnapPosition snapPosition, float f2) {
                float f3 = Float.NEGATIVE_INFINITY;
                float f4 = Float.POSITIVE_INFINITY;
                List<PageInfo> list = this.getLayoutInfo().getVisiblePagesInfo();
                PagerState pagerState = this.$pagerState;
                int n = ((Collection)list).size();
                for (int i2 = 0; i2 < n; ++i2) {
                    float f5;
                    PageInfo pageInfo = list.get(i2);
                    float f6 = SnapPositionKt.calculateDistanceToDesiredSnapPosition(PagerLayoutInfoKt.getMainAxisViewportSize(this.getLayoutInfo()), this.getLayoutInfo().getBeforeContentPadding(), this.getLayoutInfo().getAfterContentPadding(), this.getLayoutInfo().getPageSize(), pageInfo.getOffset(), pageInfo.getIndex(), snapPosition, pagerState.getPageCount());
                    if (f5 <= 0.0f && f6 > f3) {
                        f3 = f6;
                    }
                    if (!(f6 >= 0.0f) || !(f6 < f4)) continue;
                    f4 = f6;
                }
                if (f3 == Float.NEGATIVE_INFINITY) {
                    f3 = f4;
                }
                if (f4 == Float.POSITIVE_INFINITY) {
                    f4 = f3;
                }
                if (!this.$pagerState.getCanScrollForward()) {
                    f4 = 0.0f;
                    if (PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState, f2)) {
                        f3 = 0.0f;
                    }
                }
                if (!this.$pagerState.getCanScrollBackward()) {
                    f3 = 0.0f;
                    if (!PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState, f2)) {
                        f4 = 0.0f;
                    }
                }
                return TuplesKt.to((Object)Float.valueOf(f3), (Object)Float.valueOf(f4));
            }
        };
    }

    private static final boolean isScrollingForward(PagerState pagerState, float f2) {
        boolean bl = pagerState.getLayoutInfo().getReverseLayout();
        boolean bl2 = (pagerState.isNotGestureAction$foundation() ? -f2 : PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState)) > 0.0f;
        return bl2 && bl || !bl2 && !bl;
    }

    private static final float dragGestureDelta(PagerState pagerState) {
        if (pagerState.getLayoutInfo().getOrientation() == Orientation.Horizontal) {
            long l = pagerState.getUpDownDifference-F1C5BW0$foundation();
            int n = (int)(l >> 32);
            return Float.intBitsToFloat(n);
        }
        long l = pagerState.getUpDownDifference-F1C5BW0$foundation();
        int n = (int)l;
        return Float.intBitsToFloat(n);
    }

    private static final void debugLog(Function0<String> function0) {
    }

    public static final float calculateFinalSnappingBound(PagerState pagerState, LayoutDirection layoutDirection, float f2, float f3, float f4, float f5) {
        int n;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        int n2 = PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState, f3);
        int n3 = pagerState.getLayoutInfo().getOrientation() == Orientation.Vertical ? n2 : (layoutDirection == LayoutDirection.Ltr ? n2 : (n2 == 0 ? 1 : 0));
        n2 = pagerState.getLayoutInfo().getPageSize();
        float f6 = n2 == 0 ? 0.0f : PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState) / (float)n2;
        float f7 = f6 - (float)((int)f6);
        Density density = pagerState.getDensity$foundation();
        int n4 = LazyListSnapLayoutInfoProviderKt.calculateFinalSnappingItem(density, f3);
        n4 = n4;
        if (FinalSnappingItem.equals-impl0(n, FinalSnappingItem.Companion.getClosestItem-bbeMdSM())) {
            if (Math.abs(f7) > f2) {
                if (n3 != 0) {
                    return f5;
                }
                return f4;
            }
            if (Math.abs(f6) >= Math.abs(pagerState.getPositionThresholdFraction$foundation())) {
                if (n3 != 0) {
                    return f4;
                }
                return f5;
            }
            if (Math.abs(f4) < Math.abs(f5)) {
                return f4;
            }
            return f5;
        }
        if (FinalSnappingItem.equals-impl0(n4, FinalSnappingItem.Companion.getNextItem-bbeMdSM())) {
            return f5;
        }
        if (FinalSnappingItem.equals-impl0(n4, FinalSnappingItem.Companion.getPreviousItem-bbeMdSM())) {
            return f4;
        }
        return 0.0f;
    }

    public static final /* synthetic */ boolean access$isScrollingForward(PagerState pagerState, float f2) {
        return PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState, f2);
    }
}

