/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.BaseTextPreparedSelection;
import androidx.compose.foundation.text.selection.TextPreparedSelectionState;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0016\u00a2\u0006\u0002\b\u0017J\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0000J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/text/selection/TextFieldPreparedSelection;", "Landroidx/compose/foundation/text/selection/BaseTextPreparedSelection;", "currentValue", "Landroidx/compose/ui/text/input/TextFieldValue;", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "layoutResultProxy", "Landroidx/compose/foundation/text/TextLayoutResultProxy;", "state", "Landroidx/compose/foundation/text/selection/TextPreparedSelectionState;", "<init>", "(Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/foundation/text/TextLayoutResultProxy;Landroidx/compose/foundation/text/selection/TextPreparedSelectionState;)V", "getCurrentValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "getLayoutResultProxy", "()Landroidx/compose/foundation/text/TextLayoutResultProxy;", "value", "getValue", "deleteIfSelectedOr", "", "Landroidx/compose/ui/text/input/EditCommand;", "or", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "moveCursorUpByPage", "moveCursorDownByPage", "jumpByPagesOffset", "", "pagesAmount", "foundation"})
public final class TextFieldPreparedSelection
extends BaseTextPreparedSelection<TextFieldPreparedSelection> {
    private final TextFieldValue currentValue;
    private final TextLayoutResultProxy layoutResultProxy;
    public static final int $stable = 8;

    public TextFieldPreparedSelection(TextFieldValue textFieldValue, OffsetMapping offsetMapping, TextLayoutResultProxy textLayoutResultProxy, TextPreparedSelectionState textPreparedSelectionState) {
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"");
        Intrinsics.checkNotNullParameter((Object)textPreparedSelectionState, (String)"");
        AnnotatedString annotatedString = textFieldValue.getAnnotatedString();
        long l2 = textFieldValue.getSelection-d9O1mEE();
        TextLayoutResultProxy textLayoutResultProxy2 = textLayoutResultProxy;
        TextLayoutResult textLayoutResult = textLayoutResultProxy2 != null ? textLayoutResultProxy2.getValue() : null;
        super(annotatedString, l2, textLayoutResult, offsetMapping, textPreparedSelectionState, null);
        this.currentValue = textFieldValue;
        this.layoutResultProxy = textLayoutResultProxy;
    }

    public /* synthetic */ TextFieldPreparedSelection(TextFieldValue textFieldValue, OffsetMapping offsetMapping, TextLayoutResultProxy textLayoutResultProxy, TextPreparedSelectionState textPreparedSelectionState, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            offsetMapping = OffsetMapping.Companion.getIdentity();
        }
        if ((n2 & 8) != 0) {
            textPreparedSelectionState = new TextPreparedSelectionState();
        }
        this(textFieldValue, offsetMapping, textLayoutResultProxy, textPreparedSelectionState);
    }

    public final TextFieldValue getCurrentValue() {
        return this.currentValue;
    }

    public final TextLayoutResultProxy getLayoutResultProxy() {
        return this.layoutResultProxy;
    }

    public final TextFieldValue getValue() {
        return TextFieldValue.copy-3r_uNRQ$default((TextFieldValue)this.currentValue, (AnnotatedString)this.getAnnotatedString(), (long)this.getSelection-d9O1mEE(), null, (int)4, null);
    }

    public final List<EditCommand> deleteIfSelectedOr(Function1<? super TextFieldPreparedSelection, ? extends EditCommand> editCommand) {
        Intrinsics.checkNotNullParameter(editCommand, (String)"");
        if (TextRange.getCollapsed-impl((long)this.getSelection-d9O1mEE())) {
            EditCommand editCommand2 = (EditCommand)editCommand.invoke((Object)this);
            if (editCommand2 != null) {
                editCommand = editCommand2;
                return CollectionsKt.listOf((Object)editCommand2);
            }
            return null;
        }
        EditCommand editCommand3 = new EditCommand[2];
        editCommand = editCommand3;
        editCommand3[0] = new CommitTextCommand("", 0);
        editCommand[1] = new SetSelectionCommand(TextRange.getMin-impl((long)this.getSelection-d9O1mEE()), TextRange.getMin-impl((long)this.getSelection-d9O1mEE()));
        return CollectionsKt.listOf((Object[])editCommand);
    }

    public final TextFieldPreparedSelection moveCursorUpByPage() {
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        TextFieldPreparedSelection textFieldPreparedSelection = this;
        if (((CharSequence)baseTextPreparedSelection.getText$foundation()).length() > 0) {
            baseTextPreparedSelection = textFieldPreparedSelection;
            TextLayoutResultProxy textLayoutResultProxy = ((TextFieldPreparedSelection)baseTextPreparedSelection).layoutResultProxy;
            if (textLayoutResultProxy != null) {
                int n2 = super.jumpByPagesOffset(textLayoutResultProxy, -1);
                baseTextPreparedSelection.setCursor(n2);
            }
        }
        Intrinsics.checkNotNull((Object)textFieldPreparedSelection);
        return (TextFieldPreparedSelection)((BaseTextPreparedSelection)textFieldPreparedSelection);
    }

    public final TextFieldPreparedSelection moveCursorDownByPage() {
        BaseTextPreparedSelection baseTextPreparedSelection = this;
        TextFieldPreparedSelection textFieldPreparedSelection = this;
        if (((CharSequence)baseTextPreparedSelection.getText$foundation()).length() > 0) {
            baseTextPreparedSelection = textFieldPreparedSelection;
            TextLayoutResultProxy textLayoutResultProxy = ((TextFieldPreparedSelection)baseTextPreparedSelection).layoutResultProxy;
            if (textLayoutResultProxy != null) {
                int n2 = super.jumpByPagesOffset(textLayoutResultProxy, 1);
                baseTextPreparedSelection.setCursor(n2);
            }
        }
        Intrinsics.checkNotNull((Object)textFieldPreparedSelection);
        return (TextFieldPreparedSelection)((BaseTextPreparedSelection)textFieldPreparedSelection);
    }

    private final int jumpByPagesOffset(TextLayoutResultProxy textLayoutResultProxy, int n2) {
        long l2;
        LayoutCoordinates layoutCoordinates;
        LayoutCoordinates layoutCoordinates2;
        block3: {
            block2: {
                layoutCoordinates2 = textLayoutResultProxy.getInnerTextFieldCoordinates();
                if (layoutCoordinates2 == null) break block2;
                layoutCoordinates = layoutCoordinates2;
                LayoutCoordinates layoutCoordinates3 = textLayoutResultProxy.getDecorationBoxCoordinates();
                layoutCoordinates2 = layoutCoordinates3 != null ? LayoutCoordinates.localBoundingBoxOf$default((LayoutCoordinates)layoutCoordinates3, (LayoutCoordinates)layoutCoordinates, (boolean)false, (int)2, null) : null;
                if (layoutCoordinates2 != null) break block3;
            }
            layoutCoordinates2 = Rect.Companion.getZero();
        }
        layoutCoordinates = layoutCoordinates2;
        int n3 = this.getOffsetMapping().originalToTransformed(TextRange.getEnd-impl((long)this.currentValue.getSelection-d9O1mEE()));
        Rect rect = textLayoutResultProxy.getValue().getCursorRect(n3);
        float f2 = rect.getLeft();
        long l3 = l2 = layoutCoordinates.getSize-NH-jbRc();
        int n4 = (int)l2;
        float f3 = rect.getTop() + Float.intBitsToFloat(n4) * (float)n2;
        long l4 = Float.floatToRawIntBits(f2);
        long l5 = Float.floatToRawIntBits(f3);
        return this.getOffsetMapping().transformedToOriginal(textLayoutResultProxy.getValue().getOffsetForPosition-k-4lQ0M(Offset.constructor-impl((long)(l4 << 32 | l5 & 0xFFFFFFFFL))));
    }
}

