/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.tyler;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.LevelUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.util.PropertyModelHandlerHelper;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;
import ch.qos.logback.core.util.StringUtil;
import java.util.Map;

public class TylerConfiguratorBase
extends ContextAwareBase
implements ContextAwarePropertyContainer {
    public static final String SET_CONTEXT_METHOD_NAME = "setContext";
    public static final String SET_CONTEXT_NAME_METHOD_NAME = "setContextName";
    public static final String SETUP_LOGGER_METHOD_NAME = "setupLogger";
    public static final String VARIABLE_SUBSTITUTIONS_HELPER_FIELD_NAME = "variableSubstitutionsHelper";
    public static final String PROPERTY_MODEL_HANDLER_HELPER_FIELD_NAME = "propertyModelHandlerHelper";
    protected VariableSubstitutionsHelper variableSubstitutionsHelper;
    protected PropertyModelHandlerHelper propertyModelHandlerHelper = new PropertyModelHandlerHelper((ContextAware)this);

    protected Logger setupLogger(String object, String object2, Boolean bl) {
        LoggerContext loggerContext = (LoggerContext)this.context;
        object = loggerContext.getLogger((String)object);
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)object2)) {
            object2 = LevelUtil.levelStringToLevel((String)object2);
            ((Logger)object).setLevel((Level)object2);
        }
        if (bl != null) {
            ((Logger)object).setAdditive(bl);
        }
        return object;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(context);
        this.propertyModelHandlerHelper.setContext(context);
    }

    protected void setContextName(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            this.addError("Cannot set context name to null or empty string");
            return;
        }
        try {
            String string2 = this.subst(string);
            this.addInfo("Setting context name to [" + string2 + "]");
            this.context.setName(string2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.addError("Failed to rename context as [" + string + "]");
            return;
        }
    }

    protected void addOnConsoleStatusListener() {
        StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)this.context, (OnConsoleStatusListener)new OnConsoleStatusListener());
    }

    public String subst(String string) {
        return this.variableSubstitutionsHelper.subst(string);
    }

    public void addSubstitutionProperty(String string, String string2) {
        this.variableSubstitutionsHelper.addSubstitutionProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.variableSubstitutionsHelper.getProperty(string);
    }

    public Map<String, String> getCopyOfPropertyMap() {
        return this.variableSubstitutionsHelper.getCopyOfPropertyMap();
    }

    public boolean isNull(String string) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        return (string = OptionHelper.propertyLookup((String)string, (PropertyContainer)tylerConfiguratorBase, (PropertyContainer)tylerConfiguratorBase.context)) == null;
    }

    public boolean isDefined(String string) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        return (string = OptionHelper.propertyLookup((String)string, (PropertyContainer)tylerConfiguratorBase, (PropertyContainer)tylerConfiguratorBase.context)) != null;
    }

    public String p(String string) {
        return this.property(string);
    }

    public String property(String string) {
        TylerConfiguratorBase tylerConfiguratorBase = this;
        if ((string = OptionHelper.propertyLookup((String)string, (PropertyContainer)tylerConfiguratorBase, (PropertyContainer)tylerConfiguratorBase.context)) != null) {
            return string;
        }
        return "";
    }
}

